turtles-own [
  strategy
  money
  gift
  reward
  trustee?
  satisfied?
]


globals [
  groups
  turnId
  dissatisfied
  satisfied
]


to setup
  ;; resizing world and set some globals
  ca
  while [remainder N groupSize > 0] [
    set N N + 1
  ]
  let m (ceiling (sqrt N)) - 1
  let p (600 / m)
  resize-world 0 m 0 m
  set-patch-size p
  set groups N / groupSize
  if replicator > 10 [set replicator (replicator / 10)]

  ;; initialize turtles
  ask n-of N patches [
    sprout 1 [
      set strategy n-values 8 [precision (random-float 1) 2]
      set trustee? false
      set satisfied? false
      ;; this list codes strategy and its updating in one-way no-iteration trust game:
      ;; item 0 - gift
      ;; item 1 - expected reward
      ;; item 2 - downgrading gift
      ;; item 3 - upgrading gift
      ;; item 4 - reward
      ;; item 5 - expected gift
      ;; item 6 - downgrading reward
      ;; item 7 - upgrading reward
    ]
  ]
  ask n-of (N / 2) turtles [
    set trustee? true
  ]

  ;; initialize playgounds
  ask n-of groups patches [
    set pcolor blue
  ]

  ;; preparing last things
  ask turtles [
    recolour
    move-to one-of patches with [pcolor = black]
  ]
  count-satisfied

  reset-ticks
end


to go
    round-starts
    set turnId 0
    repeat turns [
      set turnId (turnId + 1)
      turn
    ]
    round-ends
    tick

  if ticks >= (rounds) [stop]
end


to round-starts
  ;; trustees find free playground, non-trustees pairs with a trustee
  ask turtles with [trustee?][move-to one-of patches with [pcolor = blue and not any? turtles-here]]
  ask turtles with [not trustee?] [move-to one-of patches with [pcolor = blue and count (turtles-here) = 1]]
end


to round-ends
  ask turtles [
    move-to one-of patches with [pcolor = black]
    if changeRolesAtEoR? and not changeRolesAtEoT? [
      set trustee? (not trustee?)
      recolour
    ]
  ]
  count-satisfied
end


to turn
  ;; turtles receive money
  ask turtles [
    set money (money + moneyPerTurn)
  ]

  ;; non-trustees send money
  ask turtles with [not trustee?] [
    set gift (item 0 strategy * moneyPerTurn)
    set money (money - gift)
    ask other turtles-here [set gift (replicator * [gift] of myself)]
  ]

  ;; trustees receive money, update strategy, set reward and send reward back
  ask turtles with [trustee?][
    set money (money + gift)
    if updateStrategy? [update-trustee-strategy]
    let s4 (item 4 strategy)
    set reward ifelse-value trusteeIncludesHerMoney? [(gift + moneyPerTurn) * s4][gift * s4]
    set money (money - reward)
    ask other turtles-here [set reward ([reward] of myself)]
  ]

  ;; non-trustees receive reward and update strategy
  ask turtles with [not trustee?] [
    set money (money + reward)
    if updateStrategy? [update-non-trustee-strategy]
  ]

  ;; changing roles
  if changeRolesAtEoT? [
    ask turtles [
      set trustee? (not trustee?)
      recolour
    ]
  ]
end


to update-trustee-strategy
  let s4 (item 4 strategy)
  let s5 (item 5 strategy)
  let s6 (item 6 strategy)
  let s7 (item 7 strategy)
  let expectedGift (moneyPerTurn * replicator * s5)
  set satisfied? ifelse-value basedOnMoney? [(money - gift) > (first [money] of other turtles-here) ][gift > expectedGift]
  ifelse satisfied? [
    set s4 precision (s4 + (s7 * (1 - s4))) 3
    set strategy replace-item 4 strategy s4
  ]
   [set s4 precision (s4 * s6) 3
    set strategy replace-item 4 strategy s4
  ]
end


to update-non-trustee-strategy
  let s0 (item 0 strategy)
  let s1 (item 1 strategy)
  let s2 (item 2 strategy)
  let s3 (item 3 strategy)
  let expectedReward ifelse-value trusteeIncludesHerMoney? [((replicator * gift) + moneyPerTurn) * s1][gift * replicator * s1]
  set satisfied? ifelse-value basedOnMoney? [money > (first [money] of other turtles-here) ][reward > expectedReward]
  ifelse satisfied? [
    set s0 precision (s0 + (s3 * (1 - s0))) 3
    set strategy replace-item 0 strategy s0
  ]
   [set s0 precision (s0 * s2) 3
    set strategy replace-item 0 strategy s0
  ]
end

      ;; this list codes strategy and its updating in trust game:
      ;; item 0 - gift
      ;; item 1 - expected reward
      ;; item 2 - downgrading gift
      ;; item 3 - upgrading gift
      ;; item 4 - reward
      ;; item 5 - expected gift
      ;; item 6 - downgrading reward
      ;; item 7 - upgrading reward

to recolour
  set color ifelse-value trustee? [red] [green]
end


to count-satisfied
  set dissatisfied (count turtles with [not satisfied?])
  set satisfied (count turtles with [satisfied?])
end
@#$#@#$#@
GRAPHICS-WINDOW
6
10
628
653
-1
-1
19.35483870967742
1
10
1
1
1
0
1
1
1
0
31
0
31
1
1
1
ticks
30.0

SLIDER
696
44
868
77
N
N
5
10000
1000
1
1
NIL
HORIZONTAL

BUTTON
696
10
763
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
805
10
868
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
696
77
868
110
groupSize
groupSize
2
400
2
1
1
NIL
HORIZONTAL

SLIDER
696
110
868
143
moneyPerTurn
moneyPerTurn
10
100
10
1
1
NIL
HORIZONTAL

SLIDER
696
142
868
175
rounds
rounds
1
200
60
1
1
NIL
HORIZONTAL

SLIDER
696
175
868
208
turns
turns
1
100
13
1
1
NIL
HORIZONTAL

SLIDER
696
208
868
241
replicator
replicator
1
10
1.8
0.1
1
NIL
HORIZONTAL

PLOT
884
104
1775
282
Money
NIL
NIL
9.0
30.0
0.0
10.0
true
true
"" "if ticks < rounds [clear-plot]\n\ncarefully [set-plot-x-range floor (min [money] of turtles) ceiling (max [money] of turtles)] []"
PENS
"dissatisfied" 50.0 1 -2674135 true "" "carefully [histogram [money] of turtles with [not satisfied?]][]"
"satisfied" 50.0 1 -10899396 true "" "carefully [histogram [money] of turtles with [satisfied?]] []"

SWITCH
696
241
868
274
updateStrategy?
updateStrategy?
1
1
-1000

PLOT
884
287
1775
578
Gift [X] vs. Reward [Y]
NIL
NIL
-0.01
1.01
-0.01
1.01
true
false
"" "plot-pen-reset\nask turtles [plotxy (item 0 strategy) (item 4 strategy)]"
PENS
"default" 0.001 2 -16777216 true "plot-pen-reset\nask turtles [plotxy (item 0 strategy) (item 4 strategy)]" "plot-pen-reset\nask turtles [plotxy (item 0 strategy) (item 4 strategy)]"

MONITOR
870
45
958
98
NIL
dissatisfied
17
1
13

MONITOR
957
45
1042
98
NIL
satisfied
17
1
13

CHOOSER
696
577
868
622
distribution
distribution
"gamma" "exp" "gauss"
2

SWITCH
696
274
868
307
changeRolesAtEoR?
changeRolesAtEoR?
1
1
-1000

SWITCH
696
307
868
340
changeRolesAtEoT?
changeRolesAtEoT?
1
1
-1000

SWITCH
696
340
868
373
trusteeIncludesHerMoney?
trusteeIncludesHerMoney?
1
1
-1000

SWITCH
696
373
868
406
basedOnMoney?
basedOnMoney?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="second" repetitions="40" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <metric>reds</metric>
    <metric>greens</metric>
    <metric>turns</metric>
    <metric>precision (((mean [money] of turtles with [envy?]) / turns) / ticks) 3</metric>
    <metric>precision (((mean [money] of turtles with [envy?]) / (turns * (replicator / 10))) / ticks) 3</metric>
    <metric>precision (mean [item 0 strategy] of turtles with [envy?]) 3</metric>
    <metric>precision (mean [item 1 strategy] of turtles with [envy?]) 3</metric>
    <metric>precision (mean [item 2 strategy] of turtles with [envy?]) 3</metric>
    <metric>precision (((mean [money] of turtles with [not envy?]) / turns) / ticks) 3</metric>
    <metric>precision (((mean [money] of turtles with [not envy?]) / (turns * (replicator / 10))) / ticks) 3</metric>
    <metric>precision (mean [item 0 strategy] of turtles with [not envy?]) 3</metric>
    <metric>precision (mean [item 1 strategy] of turtles with [not envy?]) 3</metric>
    <metric>precision (mean [item 2 strategy] of turtles with [not envy?]) 3</metric>
    <enumeratedValueSet variable="replicator">
      <value value="1.4"/>
      <value value="1.6"/>
      <value value="2"/>
      <value value="2.5"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="updateStrategy?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rounds">
      <value value="7"/>
      <value value="14"/>
      <value value="21"/>
      <value value="42"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="copyStrategy?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="N">
      <value value="504"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moneyPerTurn">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="groupSize">
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="6"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="copyAll?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="turnARound">
      <value value="210"/>
    </enumeratedValueSet>
    <steppedValueSet variable="fractionOfEnvy" first="0.1" step="0.2" last="0.9"/>
  </experiment>
  <experiment name="first" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <metric>turns</metric>
    <metric>precision (((mean [money] of turtles) / turns) / ticks) 3</metric>
    <metric>precision (((mean [money] of turtles) / (turns * (replicator / 10))) / ticks) 3</metric>
    <metric>precision (mean [item 0 strategy] of turtles) 3</metric>
    <metric>precision (mean [item 1 strategy] of turtles) 3</metric>
    <metric>precision (mean [item 2 strategy] of turtles) 3</metric>
    <enumeratedValueSet variable="replicator">
      <value value="1.4"/>
      <value value="1.6"/>
      <value value="2"/>
      <value value="2.5"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="envy?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="updateStrategy?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rounds">
      <value value="7"/>
      <value value="14"/>
      <value value="21"/>
      <value value="42"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="copyStrategy?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="N">
      <value value="504"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moneyPerTurn">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="groupSize">
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="6"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="copyAll?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="turnARound">
      <value value="210"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
