globals [time season minutes hours day sea land coast shallow deep reef farmland abroad]

breed [spinners spinner] ; clock in top right corner

breed [fishers fisher] ; people
breed [BMUs BMU]
breed [captains captain]
breed [farmers farmer]

breed [canoes canoe] ; vessels
breed [m-canoes m-canoe]
breed [b-boats b-boat]

breed [rabbitfishes rabbitfish] ; species of schools of fish
breed [kingfishes kingfish]
breed [tunas tuna]


breed [basket-traps basket-trap] ;;rabbitfish ;;canoe
breed [troll-lines troll-line] ;;kingfish ; m-canoe                                                                                                                                                                                                               
breed [ring-nets ring-net] ;;tuna ;; b-boat

breed [storms storm] ; bad weather
breed [black-flags black-flag]

undirected-link-breed [boat-links boat-link]
directed-link-breed [crew-links crew-link]

canoes-own [c-status c-destination c-fish-catch]
m-canoes-own [m-status m-destination m-fish-catch]
b-boats-own [b-status b-destination b-fish-catch]

patches-own [reef-health] ;general variable which affects whether the fish population can grow

rabbitfishes-own [r-fish-stock] ; fish stock in each school
kingfishes-own [k-fish-stock]
tunas-own [t-fish-stock] 

BMUs-own [BMU-balance BMU-income]
fishers-own [f-status f-balance f-income f-boat-type f-decision]
captains-own [boat-type status cpt-income cpt-balance cpt-decision]


to setup
  
 ct 
 
 ;landscape setup
 ask patches [
   if pcolor = black [set pcolor blue]
   if pcolor > 10 and pcolor < 16 [set pcolor 104]
   if pcolor >= 60 and pcolor < 66 [set pcolor 106]
   if pcolor != blue and pcolor != 104 and pcolor != 106 [set pcolor green]
   if pcolor = green and pycor > 30 [set pcolor 54]
   if pcolor = green and pycor < -30 [set pcolor 56]
 ] 
   ask patches with [pcolor = 54 and not any? neighbors4 with [pcolor = 54] ]
     [set pcolor blue]
   ask patches with [pcolor = green   or pcolor = 54 or pcolor = 56 and any? neighbors with [ pcolor = 106 ]] [
   set pcolor yellow]
   
   ask patches with [ pcolor = 104 and any? neighbors with [ pcolor = blue ] ] [
   set pcolor white]
 
 set sea patches with [pcolor = blue]
 set shallow patches with [pcolor = 106]
 set deep patches with [pcolor = 104]
 set land patches with [pcolor = green]
 set coast patches with [pcolor = yellow]
 set reef patches with [pcolor = white]
 set farmland patches with [pcolor = 54]
 set abroad patches with [pcolor = 56]
 
 ;clock
 create-spinners 1 [
    set shape "clock"
    setxy (max-pxcor - 5) (max-pycor - 5)
    set color gray - 1.5
    set size 10
    set heading 0 
 ]
 
 
 set-default-shape farmers "person" ; create people
 create-farmers 10 [
   move-to one-of farmland
   set size 2
   set color black
  ]
    
 set-default-shape fishers "person"
 create-fishers 30 [
   move-to one-of land
   set size 2
   set color blue
   set f-balance 100 + random 500 ;; initial balance so they don't migrate immediately
 ]
 
 set-default-shape captains "person"
 create-captains 18 [
   move-to one-of land
   set size 2
   set color red
   set cpt-balance 500 + random 1000 ;;initial balance so that they don't migrate immediately
 ]
 
  ask n-of 14 captains with [boat-type = 0] [ ; ideally this will depend on income, but not sure how to keep the number of people and number of boats consistent
   set boat-type "canoe"]
 ask n-of 3 captains with [boat-type = 0] [
   set boat-type "m-canoe"]
 ask n-of 1 captains with [boat-type = 0] [
   set boat-type "b-boat"]
 
 
 create-canoes 14 [ ; create vessels
   move-to one-of coast
   set size 5
   set shape "boat"
]
 
 create-m-canoes 3 [
   move-to one-of coast
   set size 5
   set shape "boat top"
 ]

 create-b-boats 1 [
   move-to one-of coast
   set size 10
   set color red
   set shape "boat"
 ]
  
 
 ask patch -7 14 [
   sprout-BMUs 1 [
   set size 5
   set shape "house"
   set color red
   set BMU-balance 1000 ; initial balance
   ]
 ]
 
 let r count sea / 1000 ; create fish
 ask n-of r sea [
     sprout-rabbitfishes 1 [
       set size 2 + random 5 ; initial random size of fish stock *ought to be verified*
       set color [102 0 0 125]
       set shape "circle"
       set r-fish-stock size * 100
     ]
 ]
     
 let k count sea / 1000
 ask n-of k sea [
     sprout-kingfishes 1 [
       set size 2 + random 5
       set color [94 0 0 90]
       set shape "circle"
       set k-fish-stock size * 100
     ]
 ]
     
 let t count sea / 1000
 ask n-of t sea [
     sprout-tunas 1 [
       set size 2 + random 5
       set color [84 0 0 60]
       set shape "circle"
       set t-fish-stock size * 100
     ]    
 ]

ask reef [set reef-health 100] ; arbitrary "reef health" as this affects whether fish population can grow



reset-ticks
end

to go
  
   clock   ;; to keep things moving with "real time"
     
   timings
   
   go-fishing
  
   decide-to-fish ; fisher's actions
   migrate
   spend
   
   
   damage-reef ; environmental actions
   move-fishes
   
   bad-weather
   
      
   ask rabbitfishes [
     set label round r-fish-stock]
   ask kingfishes [
     set label round k-fish-stock]
   ask tunas [
     set label round t-fish-stock]
     

   tick
  
  
end

to decide-to-fish ;only go fishing in good weather unless income is below certain amount
  if hours = 1 [
  ask captains [
      if not any? storms [
        set cpt-decision "yes"]
      if any? storms and cpt-balance < 500 [ ; *min balance required to choose to prioritise safety*
        set cpt-decision "yes"]
    ]
   ask fishers [
       if not any? storms [
        set f-decision "yes"]
      if any? storms and f-balance < 500 [
        set f-decision "yes"]
    ]
  ]
end
  

to go-fishing ;; all the functions which control fishing - crew choice, going out to sea, paying BMU fees etc
   choose-crew ; captains and fishers
   board ; only captains
   leave-vessels ; only boats
   fish-vessels  ; boats 
   return-vessels ; boats
   pay-BMU-fees ; captains, fishers, BMU
   income ; captains fishers
   go-home ; captains, fishers, boats
   
end

to migrate ; if balance falls under minimum, they choose to migrate to farming
  if hours = 8[
  ask captains [
    if cpt-balance < 50 [ ; *min balance required to stay fishing*
      go-home
      move-to one-of farmland
      set breed farmers
      set color black 
     ]
  ]
  ask fishers [
    if f-balance < 50 [
      go-home
      move-to one-of farmland
      set breed farmers
      set color black
    ]
  ]
  ]
end



to pay-BMU-fees ;paying BMU fees
  let cbmuf 0 ; the fees from the captain
  let fbmuf 0 ; fees from fisher
  if hours = 6 and minutes = 0 [ ; payment after a day of fishing
  ask captains [
    set cbmuf cbmuf + (BMU-fees * (cpt-income / 200) ) ; fees are *input fees* times the number of fish caught or kg of fish caught (/200 as income is fish-catch *200)
    set cpt-income cpt-income - (BMU-fees * (cpt-income / 200) ) ; now taken away from income
    set cpt-balance cpt-balance + cpt-income ; balance set with new income
    set cpt-income 0 ; income is reset daily
  ]
  ask fishers [
    set f-income f-income - (BMU-fees * (f-income / 200 ) )
    set fbmuf fbmuf + (BMU-fees * (f-income / 200 ) )
    set f-balance f-balance + f-income
    set f-income 0
  ]
  ask BMUs [
    set BMU-income cbmuf + fbmuf ; BMU income received from fees from fishers and captains
    set BMU-balance BMU-balance + BMU-income
    set BMU-income 0
  ]
  ]
end
  
   

to choose-crew ; captains link with nearest X number of fishers depending on the type of boat they have
  
  ask captains [
    if status = "choosing-crew" [
      let willing-fishers fishers with [ f-decision = "yes"] 
      
      if boat-type = "canoe" [
        ifelse any? willing-fishers with [not any? my-in-links]
        [ create-crew-link-to one-of willing-fishers with [not any? my-in-links] [tie] 
          set status "crew-chosen"]
        [ set status "no-crew" ]
      ]
        
      if boat-type = "m-canoe" [
        ifelse count willing-fishers with [not any? my-in-links] > 2
        [ create-crew-links-to n-of 3 willing-fishers with [not any? my-in-links][tie]
          set status "crew-chosen"]
        [ set status "no-crew" ]
      ]
     
      if boat-type = "b-boat" [
        ifelse count willing-fishers with [not any? my-in-links] > 6
        [ create-crew-links-to n-of 7 willing-fishers with [not any? my-in-links][tie]
          set status "crew-chosen"]
        [set status "no-crew"]
      ]
    ]
  ]
     
      ask fishers [
        if any? my-in-links [
          move-to first [other-end] of my-in-links
          set f-boat-type [boat-type] of one-of captains-here 
          ]
      ]     
end


  
  
to spend ;;daily cost of living is taken away from balance. same for captains and fishers. 
  if hours = 7 and minutes = 0 [
    ask fishers [
      set f-balance f-balance - cost-of-living
    ]
    ask captains [
      set cpt-balance cpt-balance - cost-of-living
    ]
  ]
end

    
  
to income
  ask captains with [status = "fishing"][ ;; income is fishcatch* 200 - 200 KSH earned for each kg of fish caught. *same amount for each type of fish*
    if boat-type = "canoe" [
      set cpt-income ((([c-fish-catch] of min-one-of canoes [distance myself] ) * 200) * 0.75) ;; 75% of the income goes to the captain
    ]
    if boat-type = "m-canoe" [
      set cpt-income ((([m-fish-catch] of min-one-of m-canoes [distance myself] ) * 200) * 0.67) ;; 67% of the income goes to the captain
  ]
    if boat-type = "b-boat" [
      set cpt-income ((([b-fish-catch] of min-one-of b-boats [distance myself] ) * 200) * 0.51) ;; 51% of the income goes to the captain
    ]
  ]
  
  ask fishers with [f-status = "fishing"] [
    if f-boat-type = "canoe" [
      set f-income ((([c-fish-catch] of min-one-of canoes [distance myself] ) * 200) * 0.25) ;; 25% goes to the fisher
    ]
    if f-boat-type = "m-canoe" [
        set f-income ((([m-fish-catch] of min-one-of m-canoes [distance myself] ) * 200) * 0.11) ;; 11% goes to each fisher
    ]
    if f-boat-type = "b-boat" [
      set f-income ((([b-fish-catch] of min-one-of b-boats [distance myself] ) * 200) * 0.7) ;; 7% goes to each fisher
    ]
]
    
  
end
      
      

to board ; captains and fishers move to their boats
  ask captains with [boat-type = "canoe"] [
    if status = "crew-chosen" [
      move-to one-of canoes with [not any? my-links]
      create-boat-link-with min-one-of canoes [distance myself] [tie]
      set status "boat-chosen"
        ]
  ]
  ask captains with [boat-type = "m-canoe"] [
    if status = "crew-chosen" [
      move-to one-of m-canoes with [not any? my-links]
      create-boat-link-with min-one-of m-canoes [distance myself] [tie]
      set status "boat-chosen"
        ]
  ]
  ask captains with [boat-type = "b-boat"] [
    if status = "crew-chosen" [
      move-to one-of b-boats with [not any? my-links]
      create-boat-link-with min-one-of b-boats [distance myself] [tie]
      set status "boat-chosen"
        ]
  ]
    
end
    


to go-home ; kill the links and return to land
  ask captains [
    if status = "release-crew" [
      ask my-links [die]
      move-to one-of land
    
    ask fishers [
      move-to one-of land
    ]
    ask canoes [
      move-to one-of coast
      set c-fish-catch 0
    ]
    ask m-canoes [
      move-to one-of coast
      set m-fish-catch 0
    ]
    ask b-boats [
      set b-fish-catch 0
      move-to one-of coast
    ]
    set status "home"
    ]
   ]
end


to deplete-fish ;; fish stocks and size of schools affected by fishing
  ask canoes [
    avoid-coast
    if any? rabbitfishes in-radius (size / 2) with [ size > 2] [ ; fish caught when boats are on the school of fish, only is the school is over *certain size*
      let cfc ([r-fish-stock] of min-one-of rabbitfishes [distance myself] * 0.001);; here fc is temp fish catch so that the cumulative catch throughout the day is c-fish-catch, *0.1% of fish caught*
      set c-fish-catch c-fish-catch + cfc
     
      ask rabbitfishes in-radius (size / 2) with [ size > 2] [
        set r-fish-stock (r-fish-stock - (r-fish-stock * 0.001))
        set size r-fish-stock / 100
    ]
   ]
  ]
  
  ask m-canoes [
    avoid-coast
    if any? kingfishes in-radius (size / 2) with [ size > 2] [
     let mfc ([k-fish-stock] of min-one-of kingfishes [distance myself] * 0.001)
     set m-fish-catch m-fish-catch + mfc
      
      ask kingfishes in-radius (size / 2) with [ size > 2] [
        set k-fish-stock (k-fish-stock - (k-fish-stock * 0.001))
        set size k-fish-stock / 100
    ]
   ]
    
  ]
  
  ask b-boats [
    avoid-coast 
    if any? tunas in-radius (size / 2) with [ size > 2] [
      let bfc ([t-fish-stock] of min-one-of tunas [distance myself] * 0.001)
      set b-fish-catch b-fish-catch + bfc
      
      ask tunas in-radius (size / 2) with [ size > 2] [
        set t-fish-stock (t-fish-stock - (t-fish-stock * 0.001))
        set size t-fish-stock / 100
    ]
   ]
    
  ]
  
end

to fish-vessels ;moving around in the sea and hovering over schools of fish
  ask canoes [
    if c-status = "fishing" [
      right random 360 fd 2
    
      if any? rabbitfishes in-radius size [
        move-to min-one-of rabbitfishes [distance myself]
    ]
      avoid-coast
      avoid-vessels
      deplete-fish
   ]
  ]
  ask m-canoes [
    if m-status = "fishing" [
      right random 360 fd 3
    
      if any? kingfishes in-radius size [
        move-to min-one-of kingfishes [distance myself]
    ]
      avoid-coast
      avoid-vessels
      deplete-fish
   ]
  ]
  ask b-boats [
    if b-status = "fishing" [
      right random 360 fd 4
    
      if any? tunas in-radius size [
        move-to min-one-of rabbitfishes [distance myself]
    ]
      avoid-coast
      avoid-vessels
      deplete-fish
   ]
  ]
end


to leave-vessels ; set off from the coast
  ask canoes [
    if c-status = "leaving" [
    avoid-coast
    face one-of sea 
    forward random 5
    ]
 ]
  ask m-canoes [
    if m-status = "leaving" [
    avoid-coast
    face one-of sea 
    forward random 5
    ]
 ]
  ask b-boats [
    if b-status = "leaving" [
    avoid-coast
    face one-of sea 
    forward random 5
    ]
 ]
end

to return-vessels ; return at the end of the session to BMU
  ask canoes [
  if c-status = "returning"[
      face one-of BMUs
      forward 5
      ]
     ]
  ask m-canoes [
  if m-status = "returning"[
      face one-of BMUs
      forward 5
      ]
     ]
  ask b-boats [
  if b-status = "returning"[
      face one-of BMUs
      forward 5
      ]
     ]
end
  

to avoid-vessels ; avoid other vessels, the radius depending on each type of boat
    ask canoes [
    if any? (turtle-set canoes m-canoes b-boats) in-radius 5 [
    if-else any? neighbors with [not any? (turtle-set canoes m-canoes b-boats)] 
    [
      move-to one-of neighbors with [not any? (turtle-set canoes m-canoes b-boats)]
      ]
    [
    ]
  ]
    ]
    ask m-canoes [
    if any? (turtle-set canoes m-canoes b-boats) in-radius 10 [
    if-else any? neighbors with [not any? (turtle-set canoes m-canoes b-boats)] 
    [
      move-to one-of neighbors with [not any? (turtle-set canoes m-canoes b-boats)]
      ]
    [
    ]
  ]
    ]
    ask b-boats [
    if any? (turtle-set canoes m-canoes b-boats) in-radius 15 [
    if-else any? neighbors with [not any? (turtle-set canoes m-canoes b-boats)] 
    [
      move-to one-of neighbors with [not any? (turtle-set canoes m-canoes b-boats)]
      ]
    [
    ]
  ]
    ]
end
  
    
to avoid-coast ;; keeps fish and boats away from the land
    if [ pcolor ] of patch-here = 106 [
      face min-one-of sea [distance myself]
      fd 0.1
      ]
end





to change-in-size [ n ] ;;changes population of fish
    ask rabbitfishes [
      if any? reef in-radius 1 and reef-health > 10 [ ;grows when near reef and reef-health over *certain amount*
        if size < 10  [
           let change 1 + random 5 ; *equation of population size change*
           set size size + change
        ]
      ]
    ]
    ask kingfishes [
      if any? reef in-radius 1 and reef-health > 10 [
        if size < 10  [
           let change 1 + random 5  
           set size size + change
        ]
      ]
    ]
    ask tunas [
      if any? reef in-radius 1 and reef-health > 10 [
        if size < 10  [
           let change 1 + random 5 
           set size size + change
        ]
      ]
    ]
end


to move-fishes ; all move randomly in the same way
    ask rabbitfishes [
      set heading heading + (20 - random 40)
      fd 0.1 
    avoid-coast
    change-in-size size 
    ]
    ask kingfishes [
      set heading heading + (20 - random 40)
      fd 0.1 
    avoid-coast
    change-in-size size 
    ]
    ask tunas [
      set heading heading + (20 - random 40)
      fd 0.1 
    avoid-coast
    change-in-size size 
    ]
end



to damage-reef ;; reef damaged by boats which affects if fish stock can replenish
  ask reef [
    if any? canoes in-radius 5  or any? m-canoes in-radius 5 or any? b-boats in-radius 5[
      set reef-health reef-health - 0.5
    ]
  ]
end 

to bad-weather
  if ticks = storm-freq * random 10[ ;;every *storm-freq* a storm happens, for 10 storms....
    ask one-of deep [
      sprout-storms 1 [
      set size 20
      set shape "circle"
      set color [black 0 0 100]
     ]
      ask patch -8 15 [
        sprout-black-flags 1 [ ; black flag goes up for dangerous fishing
          set size 10
          set shape "flag"
          set color black
        ]
      ]
    ]
   ]
  ask storms [ ; move towards coast and grow
    set size size + 1
    face min-one-of coast [distance myself] 
    fd 10
    if size > 200 [
      ask black-flags [die]
      die
      ]
 ]
end
   


to timings ; used to set statuses depending on the time of day. the statuses are used to call the other functions
  
ask captains [
  if cpt-decision = "yes" [
    if hours = 1 and minutes = 30 [
      set status "choosing-crew"
  ]
    if hours > 2 and minutes > 10 and hours < 5 [
      set status "fishing"
  ]
    if hours = 6 and minutes = 0[
      set status "release-crew"
  ]
 ]
]

ask fishers [
  if f-decision = "yes" [
  if hours > 2 and minutes > 10 and hours < 5 [
    set f-status "fishing"
  ]
]
]
  
 
ask canoes [
  if any? captains-here [
    if hours = 2 and minutes = 0 [
      set c-status "leaving"]
    if hours > 2 and minutes > 10 and hours < 5 [
      set c-status "fishing"]
    if hours = 5 or any? black-flags [
      set c-status "returning"]
    if hours >= 6 [
      set c-status "home"]
  ]
]

ask m-canoes [
  if any? captains-here [
    if hours = 2 and minutes = 0 [
      set m-status "leaving"]
    if hours > 2 and minutes > 10 and hours < 5 [
      set m-status "fishing"]
    if hours = 5 or any? black-flags [
      set m-status "returning"]
    if hours >= 6 [
      set m-status "home"]
  ]
]

ask b-boats [
  if any? captains-here [
    if hours = 2 and minutes = 0 [
      set b-status "leaving"]
    if hours > 2 and minutes > 10 and hours < 5 [
      set b-status "fishing"]
    if hours = 5 or any? black-flags [
      set b-status "returning"]
    if hours >= 6 [
      set b-status "home"]
  ]
]

end

to clock
  set minutes minutes + 1 
  
  if minutes = 60 [
    set hours hours + 1
  ]
  
  if minutes = 60 [
    set minutes 0
  ]
  
  if hours = 24 [
    set day day + 1
  ]
  
  if hours = 24 [
    set hours 0 
  ]
  
  ask spinners [
    set heading hours * 30
    set label hours
  ]
  
end
@#$#@#$#@
GRAPHICS-WINDOW
20
10
561
399
70
47
3.77
1
10
1
1
1
0
0
0
1
-70
70
-47
47
0
0
1
ticks
30.0

BUTTON
221
413
284
446
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
131
412
200
445
map
ca\\nimport-pcolors \\"mombasa-coast.jpg\\"\\n  
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
309
413
372
446
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
34
403
91
448
day
day
17
1
11

PLOT
64
502
264
652
BMU balance
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [BMU-balance] of BMUs"

BUTTON
394
413
545
446
buy canoe 2000 KSH
create-canoes 1[\\nmove-to one-of coast\\n   set size 5\\n   set shape \\"boat\\"\\n   ]\\nask BMUs [\\nset BMU-balance BMU-balance - 2000]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
642
10
703
70
bmu-fees
5
1
0
Number

PLOT
316
506
516
656
cpt balance
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [cpt-balance] of captains"

SLIDER
648
97
820
130
storm-freq
storm-freq
0
10000
1720
10
1
NIL
HORIZONTAL

PLOT
545
508
745
658
fishers balance
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [f-balance] of fishers"

BUTTON
230
463
294
496
movie
;; make a 20-step movie of the current view\\nsetup\\nmovie-start \\"out.mov\\"\\nrepeat 500 [\\n  movie-grab-view \\n  go\\n]\\nmovie-close
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
723
15
802
75
cost-of-living
50
1
0
Number

PLOT
77
685
277
835
Rabbitfish stock
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [r-fish-stock] of rabbitfishes"

PLOT
319
685
519
835
Kingfish stock
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [k-fish-stock] of kingfishes"

PLOT
544
686
744
836
Tuna stock
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [t-fish-stock] of tunas"

@#$#@#$#@
## WHAT IS IT?

This is a model of a "beach management unit" (BMU) in Kenya. The aim is to model the human population (fishers and farmers) and the natural environment (fish populations and coral reef health) and better understand the impacts they have on each other. 

## HOW IT WORKS

Environmentally, the fish population grows as long as the health of the coral reef remains over a certain amount. Periodically there are storms which take place.

Each morning the individuals decide whether to go fishing depending on storms and their own balance. When they have decided to go, the captains choose a crew and set off in a boat. The boat types symbolise gear types, so each has a target fish species. At the end of the session, the boats return to the BMU.

BMU fees are paid by each fisher depending on the size of the catch. The income from each catch is divided by the captain and the crew. A cost of living is deducted each day and the rest of the income becomes part of the fisher or captain's balance. If this balance falls under a certain amount, the agent migrates to "farmland" to pursue an alternative livelihood. 

## HOW TO USE IT

The interface tab includes inputs for the BMU-fees and the cost-of-living. By changing these, the impacts of the decisions can be easily seen in the model. There is also a slider for the storm frequency. The frequency of storms is linked to the idea of climate change, so is another important variable which can be experimented with. There is also a button so that the BMU can buy a new canoe and so improve its resources.

There are a number of graphical outputs from the model. This means that the financial situation of all the agents can be easily monitored. The graphs show the aggregate balance of each breed so that the overall changes in balance can be seen. There are also graphs of the changing fish population as fishing and spawning take place.

## THINGS TO NOTICE

How quickly the fishers migrate each time the model is run.

How many fishers decide to fish despite the black flag warning.

## THINGS TO TRY

Changing the BMU fees to see its effect on migration.

Changing the storm frequency to see its effect on the balance of the fishers and captains.

## EXTENDING THE MODEL

1. As well as putting up a black flag for bad weather days, the BMU could do this if fish stocks were running low. It would then have to subsidise the fishers for that day of fishing. Possibly it could also subsidise for bad weather.


2. There could be a way for the fishers who have migrated to return to fishing, either if their balance increases, or if they find the other livelihoods too difficult and decide to return to fishing.


3. Inclusion of the idea of migrant fishers from abroad coming into the BMU fishing area and the possibility of conflicts arising from this.

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

boat
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 33 230 157 182 150 169 151 157 156
Polygon -7500403 true true 149 55 88 143 103 139 111 136 117 139 126 145 130 147 139 147 146 146 149 55

boat top
true
0
Polygon -7500403 true true 150 1 137 18 123 46 110 87 102 150 106 208 114 258 123 286 175 287 183 258 193 209 198 150 191 87 178 46 163 17
Rectangle -16777216 false false 129 92 170 178
Rectangle -16777216 false false 120 63 180 93
Rectangle -7500403 true true 133 89 165 165
Polygon -11221820 true false 150 60 105 105 150 90 195 105
Polygon -16777216 false false 150 60 105 105 150 90 195 105
Rectangle -16777216 false false 135 178 165 262
Polygon -16777216 false false 134 262 144 286 158 286 166 262
Line -16777216 false 129 149 171 149
Line -16777216 false 166 262 188 252
Line -16777216 false 134 262 112 252
Line -16777216 false 150 2 149 62

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

clock
true
0
Circle -7500403 true true 30 30 240
Polygon -16777216 true false 150 31 128 75 143 75 143 150 158 150 158 75 173 75
Circle -16777216 true false 135 135 30

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -7500403 true true 135 285 195 285 270 90 30 90 105 285
Polygon -7500403 true true 270 90 225 15 180 90
Polygon -7500403 true true 30 90 75 15 120 90
Circle -1 true false 183 138 24
Circle -1 true false 93 138 24

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
