globals [ capital-list  total-capital weighted-degree-list total-weighted-degree average-weighted-degree
  P1RProR P1RProNR P1RAntiR P1RAntiNR P2RProR P2RProNR P2RAntiR P2RAntiNR Connections Connected-People Dunbar Bond max-connected-capital ]

links-own [ capital happy? link-weighted-degree-list max-weighted-degree ]

turtles-own [ degree weight-list weighted-degree ]

;; %-Reaction-to-Pro-Behaviour is the probability of Player 2 reacting to pro-group action by Player 1, it is a social norm and applies to all people
;; Reaction to Anti-Behaviour decreases the degree to which social capital reduces the level of anti group action, it has the effect of increasing reaction to anti group action

to setup

  ;; set the initial values of every variable

  clear-all ;; clear all old settings

  ask patches [ set pcolor white]  ;; makes the background white

  ;; set up the network

  create-turtles People [ set color black set shape "person"  ] ;; this sets the group size and the people characteristics

  set connected-people ( 2 + ceiling ( ( People - 2 ) * ( Interdependence / 10 ) ) ) ;; sets the number of people with connections based on the level of Atraction

  set connections (  ceiling ( ( connected-people - 1 ) * ( Interdependence / 10 ) ) ) ;; sets the number of Connections for Connected People based on the level of Attraction

  ask n-of connected-people turtles [ create-links-with n-of connections other turtles ] ;; creates the Connections between Connected People and other People

  set max-connected-capital ( count turtles with [ count my-links > 0 ] - 1 ) * 10 ;; sets the maximum group social capital based on the number of connected people rather than
  ;; all the people in the group, some of whom may not be connected

  repeat 30 [ layout-spring turtles links 0.2 18 1 ] ;; spreads out the network to improve presentation

  ;; set the reward table values

  set P1RProR 1 set P1RProNR -2 set P1RAntiR -1 set P1RAntiNR 2 set P2RProR 1 set P2RProNR 2 set P2RAntiR -1 set P2RAntiNR -2

  ;; set the maximum level of bonding capital for a person following Rbin Dunbar's 150 theory

  set Dunbar (ifelse-value
   People < 6 [ People * 10 ]
   People > 5 and People < 16 [ 50 + ( ( People - 5 ) * 6.6 ) ]
   People > 15 and People < 50 [ 116 + ( ( People - 15 ) * 4.4 ) ]
               [ 263 + ( ( People - 50 ) * 2.9 ) ])

  set Bond Interdependence * Dunbar / ( People * 10 )

  ;; set up the social capital measure using link capital

  ask links [ set capital random Bond + 1
    set thickness capital / 40 set color black set shape "capital"]

  ;; sets the initial capital of each link and link characteristics

  set capital-list [ capital ] of links ;; creates a list of all the link capitals

  set total-capital 2 * sum capital-list / count turtles ;; total-capital is the average of the total link capital per person which is the average weighted degree and group social capital

  ;; set up the social capital measure using turtle degree and link weight

  ask turtles [ set degree count my-links set weight-list [ capital ] of my-links

    set weighted-degree sum weight-list

    set size (1 + weighted-degree / ( 2 * count turtles ) ) ] ;; sets the degree and weighted-degree of each turtle

  set weighted-degree-list [ weighted-degree ] of turtles ;; lists the weighted degrees of all the turtles
  set total-weighted-degree sum weighted-degree-list ;; calculates the total weighted degree of all the turtles combined
  set average-weighted-degree total-weighted-degree / count turtles ;; calculates the average weighted degree which is the social capital of the group

  ;; set up the link view of the weighted degree of the people at each end

  ask links [ set link-weighted-degree-list [ weighted-degree ] of [ both-ends ] of self

  set max-weighted-degree max [ link-weighted-degree-list ] of self ]

  reset-ticks

end

 to go

  every 0.05 [

  if count links = 0 [ set average-weighted-degree 0 set total-capital 0 plot total-capital ask turtles [ die ] stop  ] ;; stops the run if social capital is zero

    ask links [ repeat ( capital ) [ decide reset ] ] ;; Player 1 decides whether to act pro-group or anti-group based on probable rewards

   ;; and the change in social capital for each pair is based on rewards for both Player 1 and Player 2

  ask one-of turtles with [ degree > 0 ] [ grow ] ;; people decide whether to add or subtract connections to other people based on their level of social capital

  repeat 30 [ layout-spring turtles links 0.2 18 1 ]

  set max-connected-capital ( count turtles with [ degree > 0 ] - 1 ) * 10 ;; sets the maximum capital of the number of connected people rather than
  ;; all the people in the group, some of whom may be disconnected

  ;; set the NEW values of turtle variables and re-calculate group capital based on people attributes

  ask turtles [
    set degree count my-links
    set weight-list [ capital ] of my-links
    set weighted-degree sum weight-list
    set size (1 + weighted-degree / ( 2 * count turtles ) )
  ]
  set weighted-degree-list [ weighted-degree ] of turtles
  set total-weighted-degree sum weighted-degree-list
  set average-weighted-degree total-weighted-degree / count turtles


  ;; set the NEW values of link capital and re-calculate group social capital based on link attributes

  set capital-list [ capital ] of links
  set total-capital 2 * sum capital-list / count turtles

  ;; reset the link view of the weighted degree of the people at each end

  ask links [ set link-weighted-degree-list [ weighted-degree ] of [ both-ends ] of self

  set max-weighted-degree max [ link-weighted-degree-list ] of self ]



  tick ] ;; go again

end

to decide

  ;; Player 1 decides whether to act pro or anti Player 2

  ;; set the current pro and anti reaction probabilities
  let ProR ( Reaction-to-Pro-Behaviour / 100 )
  let ProNR 1 - ProR
  let AntiR (1 - ( Capital / ( Reaction-to-Anti-Behaviour * 10 ) ) ) ;; increasing Reaction to Anti Behaviour lessens the reduction impact of higher Capital on AntiR
  let AntiNR 1 - AntiR

  ;; calculate the current pro and anti rewards for Player 1
  let P1RPro ProR * P1RProR + ProNR * P1RProNR
  let P1RAnti AntiR * P1RAntiR + AntiNR * P1RAntiNR

  ;; Player 1 decides on pro or anti group action
  ifelse P1RPro >= P1RAnti  [ set happy? true ]  [ set happy? false ] ;; happy attribute equals do pro, not happy equals do anti

 end

to reset

  ;; based on P1 decision, calculate the increase or decrease in capital for Player 1 plus Player 2, the change in individual link capital
  let ProR ( Reaction-to-Pro-Behaviour / 100 )
   ;; let ProNR 1 - ProR only needed if reward table changed
  let AntiR 1 - ( capital / ( Reaction-to-Anti-Behaviour * 10 ) )
   ;; let AntiNR 1 - AntiR only needed if reward table changed

  ifelse happy? = true

  [ if max-weighted-degree < Dunbar [ set capital capital + ( ProR * 0.01 ) ] ] ;; set new capital for pro action if people at each end have not exceeded capacity
  ;; different equation required if reward table revised
  ;; ( ProR * ( P1RProR + P2RProR ) + ProNR * ( P1RProNR + P2RProNR ) )

  [ set capital capital + ( AntiR * -0.01 ) ] ;; set new capital for anti action, different equation required if reward table revised
  ;; ( AntiR * ( P1RAntiR + P2RAntiR ) + AntiNR * ( P1RAntiNR + P2RAntiNR ) )

  ask links [ if capital >= 10 [ set capital 10 ] ] ;; restricts the capital of a link to the maximum possible
  ask links [ set thickness capital / 40  ] ;; sets the size of the link to match new capital

end

to grow

 ;; people decide whether to create new connections or break old ones based on their personal level of social capital

 ;; individual person decides whether to add a connection

 if ( weighted-degree / degree ) > ( 10 - ( ( Interdependence ) / 1.5 ) ) and weighted-degree < Dunbar [ create-link-with one-of other turtles
    [ set capital random Interdependence + 1 set thickness capital / 40 set color red set shape "capital" ]
    set degree count my-links set size (1 + weighted-degree / ( 2 * count turtles ) ) ]

 ;; individual person decides whether to sever a connection

 if ( weighted-degree / degree ) <  ( ( 10 - Interdependence  ) / 1.5  ) and ( count my-links > 0 )
    [ ask one-of my-links  [ die ]
    set degree count my-links set size (1 + weighted-degree / ( 2 * count turtles ) ) ]

end
@#$#@#$#@
GRAPHICS-WINDOW
295
9
771
486
-1
-1
14.2
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
5
150
72
183
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
70
150
125
183
NIL
Go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
65
177
98
People
People
2
20
10.0
1
1
NIL
HORIZONTAL

SLIDER
5
230
177
263
Interdependence
Interdependence
0
10
5.0
0.1
1
NIL
HORIZONTAL

PLOT
784
13
1192
409
Social Capital
Time
Social Capital
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot total-capital"

MONITOR
90
435
167
480
Connections
count links
0
1
11

SLIDER
5
270
250
303
Reaction-to-Pro-Behaviour
Reaction-to-Pro-Behaviour
0
100
85.0
1
1
NIL
HORIZONTAL

MONITOR
150
385
232
430
SoCap
total-capital
1
1
11

BUTTON
125
150
217
183
Go-forever
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
310
252
343
Reaction-to-Anti-Behaviour
Reaction-to-Anti-Behaviour
1
2
1.3
0.01
1
NIL
HORIZONTAL

MONITOR
15
385
77
430
Max Cap
10 * ( People - 1 )
0
1
11

MONITOR
80
385
145
430
Max Conn
( People * (people - 1 ) ) / 2
0
1
11

MONITOR
15
435
87
480
Connected
count turtles with [ degree > 0 ]
0
1
11

@#$#@#$#@
## WHAT IS IT?

This is a model of the development of Social Capital or bonding within groups of 2 to 20 people. It shows how Social Capital grows or decays from a starting position which is based on the initial levels of attraction within the group. Growth or decay is then dependent on 2 factors:

1. the quality of relationship between connected individuals which is a function of their behaviour towards each other, and 

2. the number of connections between individuals which is a function of the changing attractiveness of the group and the desire and capacity of individuals to maintain relationships.

## HOW IT WORKS

At the outset, a group is created with the number of People in the group given as an input. The number of people connected, the number of connections and the initial level of Social Capital for each connection is determined by the input level of Interdependence. The group is represented visually as a social network of people and their connections.

At each tick, the 2 people at the ends of every connection interact. The number of interactions for each pair is determined by the Social Capital of the connection, the more the pair are bonded, the more they interact. 

One will act and the other will react. The acting person decides whether to act in a 'good' or 'bad' way by checking which behaviour will give them the greater reward with the current probabilities of a counter-reaction by the second person. The second person will then react or not with that probability. 

The resultant rewards for both people from the interaction are combined to calculate the net effect on the Social Capital within the relationship. If the net reward is positive, Social Capital rises and, if the net reward is negative, Social Capital falls. This process is based on a Game Theory approach using a reward matrix and the reaction probabilities.

The Social Capital of the group is then determined by combining the Social Capital of every pair to calculate the Average Weighted Degree of the network. AWD is a standard network metric which reflects of the number of connections each person has and the strength, or level of Social Capital for each pair, for each of their connections. 

Once every pair has interacted, individuals decide whether to make new connections or sever existing connections based on the perceived benefits of Social Capital shared with connected others and inherent levels of interdependence within the group. The level of attraction sets a threshold for Social Capital which determines whether connections will be made or severed. The threshold is a function of a constant within the inequalities. This represents a 'cost/benefit' decision making process, whether it is worth making the effort to make or maintain connections. New connections are coloured red.

The maximum Social Capital for an individual is limited by the individual's ability to expend Emotional Capital, Cognitive Capital and Physical Capital on interacting with others and maintaining relationships. This is calculated using an approach based on the theories of Robin Dunbar and the so-called 'Dunbar Number'. 

Following set-up, the model will run and display the group as a network and Social Capital as a plot. The level of social capital in each connection is reflected in the thickness of the connection. The importance of each person to the group is reflected in the size of the person.


## HOW TO USE IT

To set up the initial group network, set the number of People and the initial level of Attraction. 

Set the level of Reaction to Pro Behaviour. This is the percentage of 'good' actions which will result in a favourable reaction. The higher the level, the more 'good' behaviour will be reinforced. 

Set the level of Reaction to Anti Behaviour. What this does is to reduce the degree to which reaction to 'bad' behaviour is itself reduced as Social Capital rises. The result is that, the higher this input, the more reaction there will be to 'bad' behaviour and the less 'bad' behaviour there will be.

The Go-forever button will set the group into action. Social Capital will rise or fall and connections will be made or lost. The Social Capital of each pair is reflected by the thickness of the connection between them. The importance of each person to the group is reflected in their size. 

While the model is running, interventions can be made by altering the Interdependence and Reaction sliders to see what effect that has on the direction of change in Social Capital and the final outcome.

The first set of monitors show the maximum possible Social Capital, the maximum possible number of connections, and the actual Social Capital achieved by the group. 

The second set of monitors show the actual number of people with connections and the actual number of connections. 

## THINGS TO NOTICE

There is at least one 'tipping point' for a combination of input settings at which a group of any size larger than 3 will always survive in some form with a small level of Social Capital but a single point of reduction in any of the variable input settings of Interdependence or Reaction will guarantee that the group will disintegrate. With settings of Interdependence 6.3, Reaction to Pro-Behaviour 53% and Reaction to Anti-Behaviour 1.26, a group of any size larger than 3 will always just survive. Reduce any of the settings by 1 point and it will always fail.

For groups of 2 or 3, the same settings will sometimes result in survival and sometimes failure. This is because levels of Interdependence are randomly set up to the maximum and there is insufficient 'averaging' effect with small numbers of connections. 

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

capital
5.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
