globals
[

;  rat-reproduce-age      ;;  min age of rats before they can reproduce
;  duiker-reproduce-age  ;;  min age of elephants before they can reproduce
elephant-reproduce-age     ;;  min age of duiker before they can reproduce
;
;  rat-max-age           ;;  max age of rats before they automatically die
;  duiker-max-age          ;;  max age of duiker before they automatically die
  elephant-max-age       ;;  max age of elephants before they automatically die

  max-rats-offspring              ;; maximum number of offspring per reproductive event for a rat
  max-duikers-offspring             ;; maximum number of offspring per reproductive event for a bird
  max-elephants-offspring          ;; maximum number of offspring per reproductive event for an elephant


  rat-energy              ;; maximum number of offspring per reproductive event for a rat
  duiker-energy             ;; maximum number of offspring per reproductive event for a bird
  elephant-energy          ;; maximum number of offspring per reproductive event for an elephant

  rat-reproduce-interval
  duiker-reproduce-interval
  elephant-reproduce-interval

  rat-range           ;;  max age of rats before they automatically die
  duiker-range          ;;  max age of duiker before they automatically die
  elephant-range      ;;  max age of elephants before they automatically die

  total-catch-rat
  total-catch-duiker
  total-catch-elephant

;  rat-cc
;  duiker-cc
;  elephant-cc

  Origin-Reserve
  Origin_Hunting_Area

  border

]

breed [ duikers duiker ]
breed [ elephants elephant ]
breed [ rats rat ]
breed [ hunters hunter ]  ;;  turtles that mark the location of where a rat was removed from disease.

turtles-own [ current-age max-age starting-patch distance-from-home time-since-birth place-of-birth]       ;; these three variables are used for rats, elephants, and duiker
patches-own [reserve]

to setup
  clear-all
; set rat-reproduce-age 20
; set rat-max-age  40
  set  max-rats-offspring   3
  set rat-range 12
;
; set duiker-reproduce-age 40
; set duiker-max-age  60
  set  max-duikers-offspring 2
  set duiker-range 15

  set elephant-reproduce-age 200
  set elephant-max-age  1000
  set  max-elephants-offspring 1
  set elephant-range 60

  set rat-reproduce-interval 7
  set duiker-reproduce-interval 10
  set elephant-reproduce-interval 50


  set rat-energy 30
  set duiker-energy 50
  set elephant-energy 1000


  set-default-shape rats "mouse"
  set-default-shape duikers "fox"
  set-default-shape elephants "mammoth"
  set-default-shape hunters "person"

  ask patches [set pcolor green]
  ask patches with [pxcor > (55 - reserve-size)] [set pcolor 53]
  ask n-of 500 patches  [sprout 1 [set color 54 set size 2 set shape "grass"]]

  ask patches with [ count neighbors != 8 ] [set pcolor 54.5]

  add-rats
  add-duiker
  add-elephants
  add-hunters
  reset-ticks
end


to go
 if ticks >= 3000 and after-3000 [stop]
  ask rats [
    rats-live
    reproduce-rats]
  ask duikers [
    duiker-live
    reproduce-duikers]
  ask elephants [
    elephants-live
    reproduce-elephants]
  ask hunters [hunters-live]
  if  (count elephants + count rats + count duikers) = 0 and on-extiction  [stop]
  tick
end


to add-rats ;; setup rats procedure to add rats based on initial settings
  create-rats initial-number-rats [  ;; create the rats, then initialize their variables
    set color white
    set current-age 0  + random rat-max-age       ;;don't start out with everyone at the same age
    set max-age rat-max-age
    set time-since-birth 100
    set size 2
    setxy random-pxcor random-pycor
    set starting-patch patch-here
  ]
end

to add-duiker ;; setup duiker procedure
  create-duikers initial-number-duikers  ;; create the duikers, then initialize their variables
  [
    set color brown
    set current-age 0  + random duiker-max-age      ;;don't start out with everyone at the same age
    set max-age duiker-max-age
    set time-since-birth 100
    set size 3
    setxy random-pxcor random-pycor
    set starting-patch patch-here
  ]

end

to add-elephants
  create-elephants number-of-elephants ;; elephants the rats, then initialize their variables
  [
    set color grey
    set current-age 0  + random elephant-max-age     ;;don't start out with everyone at the same age
    set max-age elephant-max-age
    set time-since-birth 100
    set size 6
    setxy random-pxcor random-pycor
    set starting-patch patch-here
   ]
end

to add-hunters
  ask n-of number-of-hunters patches with  [pcolor = green]
  [sprout-hunters 1  [ set color black     set size 3
  ]]
end


to rats-live ;; rats procedure
  move-rats
    reproduce-rats
    set current-age (current-age + 1)
      set time-since-birth (time-since-birth + 1)
    death
end

to duiker-live ;; duiker procedure
  move-duiker
  reproduce-duikers
  set current-age (current-age + 1)
      set time-since-birth (time-since-birth + 1)
  death
end

to elephants-live ;; elephants procedure
    move-elephants
    reproduce-elephants
    set current-age (current-age + 1)
    set time-since-birth (time-since-birth + 1)
 death
end

to hunters-live ;; elephants procedure
    move-hunters
    hunter-catch-animal
  set current-age (current-age + 1) ;this is used as a proxy for hunting effort - the amount of time spent looking for animals
end

to move-rats  ;; rats procedure

  ifelse [pcolor] of patch-here = 54.5
    [    rt random 140
         lt random 140
      fd .5 ]

    [ifelse distance starting-patch > rat-range
    [face starting-patch]
    [ rt random 90  lt random 90 ]
  ]

  fd 1

end

to move-duiker  ;; duiker procedure
    ifelse [pcolor] of patch-here = 54.5
    [    rt random 140
         lt random 140
      fd .5 ]

   [ ifelse distance starting-patch > duiker-range
    [face starting-patch]
    [ rt random 90  lt random 90 ]
  ]
    fd 1
end

to move-elephants  ;; elephants procedure
  ifelse [pcolor] of patch-here = 54.5
    [    rt random 140
         lt random 140
      fd .5 ]

    [ifelse distance starting-patch > elephant-range
    [face starting-patch]
    [ rt random 90  lt random 90 ]
  ]

  fd 1
end

to move-hunters ;;
    ifelse [pcolor] of patch-here = 54.5 or [pcolor] of patch-here = 53 [
    rt 180  ]
    [ rt random 40
      lt random 40   ]
  fd 1
end

to hunter-catch-animal  ;; duiker procedure
    if (any? rats in-radius 4 )
        [ask one-of  rats in-radius 4 [  set total-catch-rat (total-catch-rat + rat-energy)
        if place-of-birth = 2  [set Origin-Reserve Origin-Reserve + 1]
         if place-of-birth = 1 [set Origin_Hunting_Area Origin_Hunting_Area + 1] die]]

    if (any? duikers in-radius 4 )
        [ask one-of  duikers in-radius 4 [ set total-catch-duiker (total-catch-duiker + duiker-energy)
         if place-of-birth = 2  [set Origin-Reserve Origin-Reserve + 1]
         if place-of-birth = 1 [set Origin_Hunting_Area Origin_Hunting_Area + 1] die]]

     if hunt-elephants [
      if (any? elephants in-radius 5 )
      [ask one-of  elephants in-radius 5 [die]  set total-catch-elephant (total-catch-elephant + elephant-energy)  ]]
 end


to reproduce-rats  ;; rats procedure
  let number-offspring (random (max-rats-offspring + 1)) ;; set number of potential offspring from 1 to (max-rats-offspring)
  if ( current-age > rat-reproduce-age and time-since-birth > rat-reproduce-interval and random 4 = 1  and ((count rats in-radius rat-cc) < 3))
  [ set time-since-birth 0
    hatch number-offspring
      [
        set size 2
        set color white
        set current-age 0
        set time-since-birth  1000
        set shape "mouse"
        rt random 360 fd 7
        set starting-patch patch-here
        ifelse pxcor > (55 - reserve-size) [set place-of-birth 2 ] [set place-of-birth 1 ] ;; born in or outside a protected area
      ]    ;; hatch an offspring set it heading off in a random direction and move it forward a step
    ]
  end

to reproduce-duikers

  let number-offspring (random (max-rats-offspring + 1)) ;; set number of potential offspring from 1 to (max-rats-offspring)
  if ( current-age > duiker-reproduce-age and time-since-birth > duiker-reproduce-interval and random 4 = 1  and ((count duikers in-radius duiker-cc) < 3))
  [ set time-since-birth 0
    hatch number-offspring
      [
        set size 3
        set color brown
        set current-age 0
        set time-since-birth  1000
        set shape "fox"
        rt random 360 fd 7
        set starting-patch patch-here
        ifelse pxcor > (55 - reserve-size) [set place-of-birth 2 ] [set place-of-birth 1 ] ;; born in or outside a protected area
      ]    ;; hatch an offspring set it heading off in a random direction and move it forward a step
    ]
  end

to reproduce-elephants  ;;
   if ( current-age > elephant-reproduce-age and time-since-birth > elephant-reproduce-interval and random 3 = 1  and ((count elephants in-radius 70) < 3))
  [ set time-since-birth 0
    hatch 1
      [
        set size 6
        set color grey
        set current-age 0
        set time-since-birth  1000
        set shape "mammoth"
        rt random 360 fd 7
        set starting-patch patch-here
        ifelse pxcor > (55 - reserve-size) [set place-of-birth 2 ] [set place-of-birth 1 ] ;; born in or outside a protected area
      ]    ;; hatch an offspring set it heading off in a random direction and move it forward a step
    ]
  end

to death  ;; common procedure for rats duiker & elephants to die
  if (current-age > max-age)
  [ die ]
end



; Copyright 2011 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
300
8
1085
584
-1
-1
7.0
1
6
1
1
1
0
0
0
1
-55
55
-40
40
1
1
1
ticks
30.0

SLIDER
60
274
230
307
initial-number-duikers
initial-number-duikers
0
50
50.0
1
1
NIL
HORIZONTAL

BUTTON
60
10
148
43
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
152
10
244
43
go/pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
1097
13
1352
172
populations
ticks
populations
0.0
1000.0
0.0
60.0
true
true
"" ""
PENS
"Elephants" 1.0 0 -14730904 true "" "plot count elephants * 10"
"Rats" 1.0 0 -2674135 true "" "plot count rats"
"Duikers" 1.0 0 -8431303 true "" "plot count duikers "

MONITOR
1096
178
1160
223
rats
count rats
3
1
11

MONITOR
1160
178
1225
223
duikers
count duikers
3
1
11

SLIDER
60
311
229
344
initial-number-rats
initial-number-rats
0
50
50.0
1
1
NIL
HORIZONTAL

SLIDER
58
75
280
108
Number-of-hunters
Number-of-hunters
0
50
14.0
1
1
NIL
HORIZONTAL

MONITOR
1226
178
1295
223
elephants
count elephants
0
1
11

SWITCH
1226
547
1346
580
after-3000
after-3000
0
1
-1000

SLIDER
60
350
228
383
number-of-elephants
number-of-elephants
0
4
4.0
1
1
NIL
HORIZONTAL

PLOT
1096
314
1356
434
WIld meat biomass extracted
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Rats" 1.0 0 -2674135 true "" "plot total-catch-rat"
"Duikers" 1.0 0 -8431303 true "" "plot total-catch-duiker"
"Elephants" 1.0 0 -14070903 true "" "plot total-catch-elephant"

BUTTON
60
115
138
149
NIL
add-hunters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
147
118
277
151
hunt-elephants
hunt-elephants
0
1
-1000

MONITOR
1300
178
1358
223
hunters
count hunters
17
1
11

SLIDER
60
548
153
581
rat-cc
rat-cc
3
20
16.0
1
1
NIL
HORIZONTAL

SLIDER
160
549
253
582
duiker-cc
duiker-cc
1
20
17.0
1
1
NIL
HORIZONTAL

SLIDER
58
484
158
517
rat-reproduce-age
rat-reproduce-age
0
100
15.0
1
1
NIL
HORIZONTAL

SLIDER
164
486
278
519
duiker-reproduce-age
duiker-reproduce-age
0
100
30.0
1
1
NIL
HORIZONTAL

SLIDER
62
423
164
456
rat-max-age
rat-max-age
0
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
167
422
286
455
duiker-max-age
duiker-max-age
0
100
80.0
1
1
NIL
HORIZONTAL

TEXTBOX
65
404
181
422
Maximum Age
11
0.0
1

TEXTBOX
63
464
179
482
Reproduction Age
11
0.0
1

MONITOR
1100
440
1294
489
Total Catch / Energy Expended
precision (((total-catch-rat + total-catch-duiker + total-catch-elephant)) / (sum ([current-age] of hunters) ))2
17
1
12

TEXTBOX
63
527
257
557
Area required for young to survive
11
0.0
1

SLIDER
60
184
208
217
reserve-size
reserve-size
0
90
0.0
1
1
NIL
HORIZONTAL

BUTTON
60
224
203
258
change reserve size
  ask patches with[pcolor != 54.5] [set pcolor green]\n  ask patches with [pxcor > (55 - reserve-size) and pcolor != 54.5] [set pcolor 53]\n  let res-hunt  count hunters with [[pcolor] of patch-here = 53]\n  ask hunters with [[pcolor] of patch-here = 53] [die ]\n  set number-of-hunters res-hunt add-hunters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
1095
261
1182
306
Hunting Area
Origin_Hunting_Area
17
1
11

MONITOR
1180
261
1269
306
Reserve
Origin-Reserve
17
1
11

TEXTBOX
1149
237
1286
255
Origin of captured animal
11
0.0
1

TEXTBOX
66
163
203
181
Protected Areas
11
0.0
1

TEXTBOX
64
53
201
71
Hunter variables
11
0.0
1

SWITCH
1110
548
1220
581
on-extiction
on-extiction
0
1
-1000

TEXTBOX
1110
520
1247
538
Stop Conditions
11
0.0
1

MONITOR
1272
264
1383
305
Hunt/Reserve Ratio
precision (Origin_Hunting_Area / Origin-Reserve) 2
17
1
10

@#$#@#$#@
## WHAT IS IT?

The wild meat trade is a regular feature in many parts of Africa. People rely on it for livelihoods and, more importantly, for food. Trade in wild meat                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   