<?xml version="1.0" encoding="utf-8"?>
<model version="NetLogo 7.0.0" snapToGrid="false">
  <code><![CDATA[breed [plants plant]
breed [foragers forager]

foragers-own
[eattype
 energy
 flockmates
 mypatch
 strategy]

patches-own [
  is-gap?
  seedpatch?
  seedpatchnum
  foodpatch?
  foodpatchnum
  assortindex
  resource]

globals
[patch-width
 gap
 foodpatchlist
 growth-rate
 carryingcap
 costchild
]

to setup
  clear-all

  set patch-width Size-Resource-Areas
  set gap Distance-Resource-Areas
  set growth-rate 0.2
  set carryingcap 10

  setup-plants
  setup-frgs
  set costchild 10

  reset-ticks
end

to setup-plants
 foreach [ 0 1 2 3 4 5 6 7 8 9 10 11 12 13]
  [ x  ->
      foreach [ 0 1 2 3 4 5 6 7 8 9 10 11 12 13] [ y  ->
  ask patches with [ pxcor = ( gap / 2 ) + (x * ( gap + (patch-width )))  and pycor =  ( gap / 2 ) + (y * (gap + (patch-width))) ]
  [set seedpatch? true
        sprout-plants 1 [set hidden? true]
        set seedpatchnum [who] of plants-here
   ]
  ]
  ]

  ask patches with [seedpatch? = true]
  [ let localpatch (patch-set self patches in-radius patch-width)
    ask localpatch
     [ set resource carryingcap

       if resource = 0 [set resource 0.1]
        set pcolor scale-color brown resource 0 (carryingcap + 10)
        set foodpatch? true
        set foodpatchnum [seedpatchnum] of localpatch with [seedpatch? = true]

    ]
  ]

  set foodpatchlist (  [who] of plants )


end

to setup-frgs
  ask n-of (Number-Agents * Percent-Sustainables / 100) patches with [foodpatch? = true]
  [sprout-foragers 1
    [
      set eattype "low"
      set strategy "cooperator"
      set color green
      set mypatch [foodpatchnum] of patch-here ]
  ]

   ask n-of (Number-Agents * ( 100 - Percent-Sustainables) / 100) patches with [foodpatch? = true]
  [sprout-foragers 1
    [
      set eattype "high"
      set strategy "defector"
      set color red
      set mypatch [foodpatchnum] of patch-here
    ]
  ]

  ask foragers [
    if Agents = "People" [ set shape "person"]
    if Agents = "Bacteria" [ set shape "bacteria" ]
    if Agents = "Cows" [ set shape "cow"]
    if Agents = "Cells" [ set shape "cell"]
  set size 2
  set energy Living-costs]
   ask foragers
  [ ask  patches in-radius patch-width [ set is-gap? false ] ]

end

to go

   ask foragers [ flock ]
   ask foragers [
    if Agents = "People" [ set shape "person"]
    if Agents = "Bacteria" [ set shape "bacteria" ]
    if Agents = "Cows" [ set shape "cow"]
    if Agents = "Cells" [ set shape "cell"]]

  move
  eat
  if Evolution? [reproduce]
  expend-energy
  if Evolution? [death]

  ask patches with [foodpatch? = true]
  [regrow
    recolor]

  tick
end

to flock
  find-flockmates
end

to find-flockmates
  set flockmates other foragers in-radius group-dispersal-range with [strategy = [strategy] of myself]
end

to move
  ask foragers
  [let local ( patch-set patch-here ( patches in-radius 2 with [not any? foragers-here] ))
   if local != nobody
    [let local-max  ( max-one-of local [resource]  )
    ifelse local-max != nobody and [resource] of local-max >= Living-costs
      [face local-max
        move-to local-max
        set mypatch [foodpatchnum] of patch-here
      ]
      [if any? ( patches in-radius 2 with [not any? foragers-here] )
        [move-to one-of ( patches in-radius 2 with [not any? foragers-here] )]]
      if is-gap? != false and (count flockmates >= 1) [set energy (energy - (dispersal-costs / (count flockmates + 1)) )]
      if is-gap? != false and (count flockmates = 0) [set energy (energy - dispersal-costs)]
  ]
  ]
end

to eat
  ask foragers
  [ifelse eattype = "low"
    [ set  energy energy + ([resource] of patch-here * 0.5)
      ask patch-here [set resource resource / 2]]
    [ set  energy energy + ([resource] of patch-here * 0.99)
      ask patch-here [set resource resource - (0.99 * resource) ]]
  ]

end

to reproduce
 ask foragers
  [ let birthrate 0.0005 * energy
  if energy > costchild and random-float 1 < birthrate [
     let destination one-of neighbors with [not any? turtles-here]
     if destination != nobody [
        hatch 1 [
          move-to destination
          mutate
          set energy costchild ]
        set energy (energy - costchild)
       ]
      ]
      ]
end

to mutate
  if random-float 1 < Mutation-rate
  [
    let new-strategy one-of ["cooperator" "defector"]
    set strategy new-strategy

    ifelse strategy = "cooperator"
      [set eattype "low"]
      [set eattype "high"]

    update-color
  ]
end

to expend-energy
  ask foragers [set energy energy - Living-costs ]
end

to death
  ask foragers
  [if energy <= 0 [die]
  ]
end

to regrow
  ifelse resource >= 0.1
  [set resource precision (resource + ((growth-rate * resource) * (1 - (resource / carryingcap )))) 3]
  [set resource 0.1]
end

to recolor
  set pcolor scale-color brown resource 0 (carryingcap + 10)
end

to update-color
  if strategy = "cooperator" [set color green]
  if strategy = "defector" [set color red]
end

to calcassort
  foreach (foodpatchlist) [ x ->
    let foodpatch patches with [foodpatchnum = x]
    let lowfrgs count foragers with [eattype = "low" and mypatch = x]
    let frgs count foragers with [ mypatch = x]
    ask patches with [seedpatch? = true and seedpatchnum = x]
      [ set assortindex (lowfrgs / frgs) ]
    ]


end

to-report avenhigh
  report sum [energy] of foragers with [eattype = "high"] / count foragers with [eattype = "high"]
end

to-report avenlow
  report sum [energy] of foragers with [eattype = "low"] / count foragers with [eattype = "low"]
end

to-report gensim-pop
  report ( count patches with [seedpatch? = true] - 1) / (count foragers - 1)

end

to-report avassort
  report sum [assortindex] of patches with [seedpatch? = true] / count patches with [seedpatch? = true]
end]]></code>
  <widgets>
    <view x="293" wrappingAllowedX="false" y="10" frameRate="30.0" minPycor="0" height="564" showTickCounter="true" patchSize="5.0" fontSize="10" wrappingAllowedY="false" width="564" tickCounterLabel="Iterations" maxPycor="111" updateMode="0" maxPxcor="111" minPxcor="0"></view>
    <button x="15" y="10" height="40" disableUntilTicks="false" forever="false" kind="Observer" width="97" display="Setup">setup</button>
    <button x="15" y="101" height="40" disableUntilTicks="false" forever="true" kind="Observer" width="96" display="Start">go</button>
    <button x="15" y="55" height="40" disableUntilTicks="false" forever="false" kind="Observer" width="97" display="Once">go</button>
    <slider x="14" step="1" y="354" max="100" width="173" display="Percent-Sustainables" height="50" min="0" direction="Horizontal" default="90.0" variable="Percent-Sustainables"></slider>
    <slider x="15" step="1" y="284" max="count patches with [foodpatch? = true] / 2" width="172" display="Number-Agents" height="50" min="0" direction="Horizontal" default="80.0" variable="Number-Agents"></slider>
    <plot x="867" autoPlotX="true" yMax="10.0" autoPlotY="true" y="10" xMin="0.0" height="221" legend="true" xMax="10.0" yMin="0.0" width="385" display="Average Energy of Agents">
      <setup></setup>
      <update></update>
      <pen interval="1.0" mode="0" display="Sustainable" color="-10899396" legend="true">
        <setup></setup>
        <update>carefully [plot avenlow][plot 0]</update>
      </pen>
      <pen interval="1.0" mode="0" display="Greedy" color="-2674135" legend="true">
        <setup></setup>
        <update>carefully  [plot avenhigh] [plot 0]</update>
      </pen>
    </plot>
    <plot x="867" autoPlotX="true" yMax="100.0" autoPlotY="true" y="236" xMin="0.0" height="227" legend="true" xMax="10.0" yMin="0.0" width="383" display="Trait frequencies (global, %)">
      <setup></setup>
      <update></update>
      <pen interval="1.0" mode="0" display="Sustainable" color="-10899396" legend="true">
        <setup></setup>
        <update>carefully [plot ( count foragers with [eattype = "low"] / count foragers ) * 100][plot 0]</update>
      </pen>
      <pen interval="1.0" mode="0" display="Greedy" color="-2674135" legend="true">
        <setup></setup>
        <update>carefully [plot (count foragers with [eattype = "high"] / count foragers ) * 100] [plot 0]</update>
      </pen>
    </plot>
    <switch x="871" y="494" height="40" on="true" variable="Evolution?" width="112" display="Evolution?"></switch>
    <chooser x="13" y="464" height="60" variable="Agents" current="1" width="138" display="Agents">
      <choice type="string" value="People"></choice>
      <choice type="string" value="Bacteria"></choice>
      <choice type="string" value="Cells"></choice>
      <choice type="string" value="Cows"></choice>
    </chooser>
    <slider x="12" step="2" y="529" max="40" width="184" display="Distance-Resource-Areas" height="50" min="8" direction="Horizontal" default="20.0" variable="Distance-Resource-Areas"></slider>
    <slider x="11" step="1" y="584" max="20" width="184" display="Size-Resource-Areas" height="50" min="1" direction="Horizontal" default="4.0" variable="Size-Resource-Areas"></slider>
    <slider x="11" step="0.5" y="639" max="5" width="183" display="Living-costs" height="50" min="0" direction="Horizontal" default="1.0" variable="Living-costs"></slider>
    <note x="1266" y="14" backgroundDark="0" fontSize="11" width="168" markdown="false" height="126" textColorDark="-1" textColorLight="-16777216" backgroundLight="0">Resource carrying capacity: 10
Resource growth rate: 0.2

Resource consumption of sustainables: 
50% of resources of a patch

Resource consumption of greedy: 
99% of resources of a patch</note>
    <slider x="11" step="0.1" y="694" max="10" width="186" display="Mutation-rate" height="50" min="0" direction="Horizontal" default="0.0" variable="Mutation-rate" units="%"></slider>
    <plot x="1020" autoPlotX="true" yMax="100.0" autoPlotY="true" y="468" xMin="0.0" height="175" legend="false" xMax="10.0" yMin="0.0" width="230" display="Agent Population">
      <setup></setup>
      <update></update>
      <pen interval="1.0" mode="0" display="default" color="-16777216" legend="true">
        <setup></setup>
        <update>plot count foragers</update>
      </pen>
    </plot>
    <note x="872" y="543" backgroundDark="0" fontSize="11" width="129" markdown="false" height="42" textColorDark="-1" textColorLight="-16777216" backgroundLight="0">Agents reproduce with a probability of 
(0.0005 * Energy)</note>
    <slider x="13" step="1" y="409" max="200" width="172" display="group-dispersal-range" height="50" min="0" direction="Horizontal" default="70.0" variable="group-dispersal-range"></slider>
    <slider x="13" step="0.5" y="409" max="10" width="172" display="dispersal-costs" height="50" min="0" direction="Horizontal" default="8.0" variable="dispersal-costs"></slider>
    <monitor x="140" precision="17" y="219" height="60" fontSize="11" width="100" display="greedy">count foragers with [eattype = "high"]</monitor>
    <monitor x="15" precision="17" y="194" height="60" fontSize="11" width="100" display="total">count foragers</monitor>
    <slider x="11" step="10" y="749" max="200" width="172" display="group-dispersal-range" height="50" min="0" direction="Horizontal" default="70.0" variable="group-dispersal-range"></slider>
    <monitor x="142" precision="17" y="151" height="60" fontSize="11" width="100" display="cooperators">count foragers with [eattype = "low"]</monitor>
  </widgets>
  <info>## WHAT IS IT?

* This model examines the conditional cooperation of selfish agents, who typically act as defectors but temporarily cooperate when migration or dispersal is necessary. It is based on the first model described in this article, Ibrahim, A.M. The conditional defector strategies can violate the most crucial supporting mechanisms of cooperation. Sci Rep 12, 15157 (2022). https://doi.org/10.1038/s41598-022-18797-2

* K                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    