globals [num-survival attribute1 attribute2 x y]
turtles-own [genotype]

breed [gametes gamete]
breed [individuals individual]


to-report number-big-a
  report length (word 0 [genotype] of turtles) - length (remove "A" (word 0 [genotype] of turtles))      ;report total number of "A"
end

to-report number-small-a
report length (word 0 [genotype] of turtles) - length (remove "a" (word 0 [genotype] of turtles))      ;report total number of "a"
end

to-report freq-big-a
  report number-big-a / (number-big-a + number-small-a)   ;report allele frequency of "A"
end

to-report freq-small-a
  report number-small-a / (number-big-a + number-small-a)  ;report allele frequency of "a"
end

to-report fa2
  report count individuals with [genotype = "AA"] ;report numbe of the homozygous dominant
end

to-report f2a
  report count individuals with [genotype = "aa"]  ;report numbe of the homozygous recessive
end

to-report faa
  report (count individuals with [genotype = "Aa"] + count individuals with [genotype = "aA"])  ;report numbe of the heterzygous
end


to trait               ;define gamete trait
  ifelse genotype = "A" [set color 57][set color 26]
  set size 0.5
end

to big-a              ;assign "A" allele
  set genotype "A"
end

to sml-a               ;assign "A" allele
  set genotype "a"
end
; -----------------------------------------
to setup

  set-default-shape gametes "circle"
  set-default-shape individuals "beetle"

  ca

setup-patches
setup-gametes
fertilization
reset-ticks
output

end

to setup-gametes    ;generate gemetes based on population size and allele ratio, and randomly distribute the gametes
   create-gametes population-size * (A/a-ratio / 100) * 2 [

    big-a
    trait
    setxy random-xcor random-ycor
  ]

  create-gametes population-size * ((100 - A/a-ratio) / 100) * 2 [

    sml-a
    trait
    setxy random-xcor random-ycor
  ]
end


to setup-patches
  ask patches [set pcolor Environment-color]
end



;====================================
to go
  tick
  setup-patches
  ask turtles [move]
  process
 if number-big-a = 0 or number-small-a = 0 [stop]
 output
end

to move
 rt random 45 lt random 45 fd 1
end

to process
   if Conditions = "Condition 2" [
     gametogenesis
    fertilization
   ]

   if Conditions = "Condition 1" [
     gametogenesis-1
     fertilization
   ]
   if Conditions = "Condition 3" [
     gametogenesis
     fertilization
     survival
   ]

   if Conditions = "Condition 4" [
     gametogenesis-2
    fertilization
   ]
end

to fertilization
  ask gametes [let target one-of other gametes           ;one gamete randomly fuses with another gamete
    if target != nobody [
      hatch-individuals 1 [
        set genotype (word genotype [genotype] of target)   ;determine the genotype
        if genotype = "AA" [set color 21 + random-float 2]     ;determine the phynotype
        if genotype = "Aa" or genotype = "aA" [set color 23 + random-float 2]
        if genotype = "aa" [set color 25 + random-float 2]
        set size 3
      ]
      ask target [die]  ;the two gametes disappear after forming the zygote
      ]
     die
     ]
end

to gametogenesis                  ;Each individual produces two gametes. The homozygous produces the same kind of gametes. The heterzygous produces one "A" and one "a"
  ask individuals with [genotype = "AA"] [
    hatch-gametes 2 [ big-a trait setxy random-xcor random-ycor move ]
    die]

  ask individuals with [genotype = "aa"] [
   hatch-gametes 2 [ sml-a trait setxy random-xcor random-ycor move ]
    die]

  ask individuals with [genotype = "Aa"] [
    hatch-gametes 1 [ big-a trait setxy random-xcor random-ycor move]
    hatch-gametes 1 [ sml-a trait setxy random-xcor random-ycor move]
    die]

  ask individuals with [genotype = "aA"] [
    hatch-gametes 1 [ big-a trait setxy random-xcor random-ycor move]
    hatch-gametes 1 [ sml-a trait setxy random-xcor random-ycor move]
    die]
end

to gametogenesis-1       ;Each individual produces two gametes.
                         ;The homozygous produces the same kind of gametes.
                         ;The heterzygous produces gamete twice. Each time it has 50% chance to produce "A" or "a"one "A" and one "a"
  ask individuals with [genotype = "AA"] [
    hatch-gametes 2 [ big-a trait move ]
    die]

  ask individuals with [genotype = "aa"] [
   hatch-gametes 2 [ sml-a trait move ]
    die]

  ask individuals with [genotype = "Aa"] [
    hatch-gametes 1 [ ifelse random 2 = 0 [big-a][sml-a] trait move]
    hatch-gametes 1 [ ifelse random 2 = 0 [big-a][sml-a] trait move]

    die]

  ask individuals with [genotype = "aA"] [
    hatch-gametes 1 [ ifelse random 2 = 0 [big-a][sml-a] trait move]
    hatch-gametes 1 [ ifelse random 2 = 0 [big-a][sml-a] trait move]
    die]
end

to gametogenesis-2     ;Each individual produces two gametes.
                         ;The homozygous produces the same kind of gametes. A mutant gamete is produced at a chance of 1.
                         ;The heterzygous produces gamete twice. Each time it has 50% chance to produce "A" or "a"one "A" and one "a"

  ask individuals with [genotype = "AA"] [
    hatch-gametes 2 [ ifelse random 100 = 0 [sml-a][big-a] trait move ]
    die]

  ask individuals with [genotype = "aa"] [
   hatch-gametes 2 [ ifelse random 100 = 0 [big-a][sml-a] trait move ]
    die]

  ask individuals with [genotype = "Aa"] [
    hatch-gametes 1 [ big-a trait move]
    hatch-gametes 1 [ sml-a trait move]
    die]

  ask individuals with [genotype = "aA"] [
    hatch-gametes 1 [ big-a trait move]
    hatch-gametes 1 [ sml-a trait move]
    die]

end


to survival         ;differential survival
   ask individuals [if random-float 500 < abs (color - Environment-color) ^ 3 [die]]

  ;count sivivial rate and scale up the population
   if count individuals < population-size [
     set num-survival count individuals
    create-individuals round (population-size * (count individuals with [genotype = "AA"] / num-survival) - (num-survival * (count individuals with [genotype = "AA"] / num-survival)))
    [set genotype "AA" set color 21 + random-float 2 set size 4 setxy random-xcor random-ycor]
    create-individuals round (population-size * (count individuals with [genotype = "aa"] / num-survival) - (num-survival * (count individuals with [genotype = "aa"] / num-survival)))
    [set genotype "aa" set color 25 + random-float 2 set size 4 setxy random-xcor random-ycor]
    create-individuals round (population-size * (count individuals with [genotype = "Aa"] / num-survival) - (num-survival * (count individuals with [genotype = "Aa"] / num-survival)))
    [set genotype "Aa" set color 23 + random-float 2 set size 4 setxy random-xcor random-ycor]
    create-individuals round (population-size * (count individuals with [genotype = "aA"] / num-survival) - (num-survival * (count individuals with [genotype = "aA"] / num-survival)))
    [set genotype "aA" set color 23 + random-float 2 set size 4 setxy random-xcor random-ycor]
  ]
end



to output
  ifelse ticks < 10 [output-type word 0 ticks][output-type ticks]
  repeat 9 [output-type " "]
  output-write fa2
  repeat 3 [output-type " "]
  output-write faa
  repeat 3 [output-type " "]
  output-type f2a
  repeat 11 [output-type " "]
  output-type number-big-a
  repeat 10 [output-type " "]
  output-print number-small-a

  ;]
  end

to watch-a-beetle
  if mouse-inside? [
    if mouse-down? [
      set x mouse-xcor set y  mouse-ycor
      let picked-beetle one-of individuals with [distancexy x y < 1]
      if picked-beetle != nobody
        [watch picked-beetle
         set attribute1 [color] of picked-beetle
        set attribute2 [genotype] of picked-beetle]
  ]]

end
@#$#@#$#@
GRAPHICS-WINDOW
207
35
558
387
-1
-1
7.0
1
10
1
1
1
0
1
1
1
-24
24
-24
24
0
0
1
Generations
30.0

BUTTON
16
293
105
326
Set up/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
15
333
161
366
Run a generation
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
20
121
192
154
A/a-ratio
A/a-ratio
1
99
70.0
1
1
%
HORIZONTAL

PLOT
593
282
871
416
Genotype Frequencies
Generation
Frequency
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"AA" 1.0 0 -2674135 true "" "plot count individuals with [genotype = \"AA\"] / count turtles"
"Aa-" 1.0 0 -10899396 true "" "plot (count individuals with [genotype = \"Aa\"] + count individuals with [genotype = \"aA\"]) / count turtles"
"-aa" 1.0 0 -13345367 true "" "plot count individuals with [genotype = \"aa\"] / count turtles"

PLOT
593
418
871
554
Phenotype (coloration) Distribution
Coloration
Frequency
20.5
27.5
0.0
10.0
true
false
"" ""
PENS
"default" 0.1 1 -12087248 true "" "Histogram [color] of individuals"

MONITOR
875
147
995
188
Total # of Beetles
count Individuals
17
1
10

CHOOSER
20
36
184
81
Conditions
Conditions
"Condition 1" "Condition 2" "Condition 3" "Condition 4"
0

OUTPUT
194
412
571
556
11

TEXTBOX
199
396
553
426
Generation      AA       Aa       aa            Gamete \"A\"      Gamete \"a\"  
11
0.0
1

PLOT
593
146
871
280
Gamete Allele Frequencies
Generation
Frequency
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"Big-A" 1.0 0 -2674135 true "" "plot freq-big-a"
"Small-a" 1.0 0 -13345367 true "" "plot freq-small-a"

SLIDER
20
158
192
191
population-size
population-size
20
1000
200.0
20
1
NIL
HORIZONTAL

BUTTON
106
293
193
326
Run/pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
10
10
199
38
Step 1: Choose a condition
12
124.0
1

TEXTBOX
8
99
196
129
Step 2: Set up the parameters
12
124.0
1

TEXTBOX
8
249
198
294
Step 3: Run simulation \n(Press on \"setup\" and then \"run\")
12
124.0
1

TEXTBOX
208
10
526
28
Step 4: Examine the simulation and output data
12
124.0
1

MONITOR
875
190
995
231
Gametes carrying "A"
number-big-a
17
1
10

MONITOR
875
234
995
275
Gametes carrying "a"
number-small-a
17
1
10

TEXTBOX
611
555
656
573
Darker
10
0.0
0

TEXTBOX
834
556
882
574
Lighter
10
0.0
0

SLIDER
19
195
193
228
Environment-color
Environment-color
21
27
22.0
0.5
1
NIL
HORIZONTAL

BUTTON
691
10
811
43
Watch a beetle
watch-a-beetle\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
691
55
766
96
Color
attribute1
1
1
10

MONITOR
771
55
855
96
Genotype
attribute2
17
1
10

BUTTON
815
10
926
43
Stop watching
rp\nset attribute1 0\nset attribute2 0
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
577
22
690
40
BEETLE PROPERTIES:
11
125.0
1

TEXTBOX
602
57
698
75
Watched Beetle:
11
125.0
1

TEXTBOX
576
105
974
123
----------------------------------------------------------------
11
125.0
1

TEXTBOX
579
127
729
145
POPULATION PATTERNS:
11
125.0
1

@#$#@#$#@
## WHAT IS IT

This model simulates four conditions that intervene Hardy-Weinberg Equilibrium. Students may observe the model outcomes to infer these conditions. 

## CREDITS AND REFERENCES
This module is made by Dr. Lin Xiang at the University of Kentucky.If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2016). Hardy-Weinberg Equilibrium. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

beetle
true
0
Circle -6459832 true false 137 74 10
Circle -6459832 true false 153 74 10
Circle -7500403 true true 140 69 20
Polygon -7500403 true true 150 84 150 252 129 245 115 235 109 223 101 209 99 182 96 154 94 127 90 119 88 112 95 106 111 102 127 99 135 91 138 81
Polygon -7500403 true true 141 81 140 65 135 47 125 33 112 24 98 16 91 17 97 22 106 25 118 34 125 39 134 54 136 66 138 77 141 84
Polygon -7500403 true true 132 105 108 84 76 98 61 90 44 92 62 95 75 104 108 90 122 109
Polygon -7500403 true true 150 84 150 252 171 245 185 235 191 223 199 209 201 182 204 154 206 127 210 119 212 112 205 106 189 102 173 99 165 91 162 81
Polygon -7500403 true true 97 139 81 136 51 169 36 172 29 187 41 176 53 175 80 142 99 151
Polygon -7500403 true true 102 182 86 179 61 232 47 238 40 254 52 241 66 235 87 186 105 199
Polygon -7500403 true true 159 81 160 65 165 47 175 33 188 24 202 16 209 17 203 22 194 25 182 34 175 39 166 54 164 66 162 77 159 84
Polygon -7500403 true true 168 105 192 84 224 98 239 90 256 92 238 95 225 104 192 90 178 109
Polygon -7500403 true true 203 139 219 136 249 169 264 172 271 187 259 176 247 175 220 142 201 151
Polygon -7500403 true true 198 182 214 179 239 232 253 238 260 254 248 241 234 235 213 186 195 199

beetle 1
true
0
Rectangle -16777216 true false 132 86 166 230
Polygon -7500403 true true 181 90 191 96 199 109 204 122 209 140 211 168 209 201 201 227 190 240 178 246 168 248 153 249 151 240 151 225 151 210 151 195 151 180 151 165 151 150 151 120 151 105 166 90 151 90 151 60 181 75
Polygon -7500403 true true 120 90 110 96 102 109 97 122 92 140 90 168 92 201 100 227 111 240 123 246 133 248 148 249 150 240 150 225 150 210 150 195 150 180 150 165 150 150 150 120 150 105 135 90 150 90 150 60 120 75
Circle -7500403 true true 135 45 30
Circle -7500403 true true 151 54 24
Circle -7500403 true true 127 54 24
Circle -7500403 true true 133 63 34
Circle -7500403 true true 158 70 26
Circle -7500403 true true 131 222 40
Polygon -7500403 true true 135 55 123 55 114 57 108 64 108 61 109 43 113 39 113 46 113 53 114 54 128 52 137 53
Polygon -7500403 true true 165 55 177 55 186 57 192 64 192 61 191 43 187 39 187 46 187 53 186 54 172 52 163 53
Polygon -7500403 true true 125 102 95 87 95 63 91 38 96 23 102 17 98 27 93 40 99 47 103 56 100 84 132 97
Polygon -7500403 true true 175 102 205 87 205 63 209 38 204 23 198 17 202 27 207 40 201 47 197 56 200 84 168 97
Polygon -7500403 true true 104 115 90 121 62 122 59 117 30 98 26 90 29 81 33 81 29 89 33 97 61 115 64 113 89 117 106 110
Polygon -7500403 true true 196 115 210 121 238 122 241 117 270 98 274 90 271 81 267 81 271 89 267 97 239 115 236 113 211 117 194 110
Polygon -7500403 true true 91 163 78 169 66 229 57 244 57 255 59 262 63 263 59 254 61 244 71 231 80 242 76 230 81 176 93 168
Polygon -7500403 true true 209 163 222 169 234 229 243 244 243 255 241 262 237 263 241 254 239 244 229 231 220 242 224 230 219 176 207 168
Circle -7500403 true true 116 70 26

bird
true
0
Polygon -7500403 true true 154 72 150 62 147 72 139 77 135 86 129 98 117 98 109 95 104 89 99 78 90 74 74 77 56 85 40 97 30 112 0 150 42 135 74 126 87 138 109 148 130 154 134 163 135 165 105 209 135 224 152 228 165 224 195 209 165 165 168 163 172 153 193 148 213 138 227 128 259 135 300 149 271 113 261 99 249 86 230 78 210 74 203 78 196 92 185 95 171 97 166 85 162 76

bird 1
false
0
Circle -7500403 true true 20 90 50
Polygon -7500403 true true 57 92 6 119 28 121 31 131 35 153 45 174 64 192 93 200 122 198 148 192 174 165 189 144 199 126 256 83 299 60 291 60 286 58 200 105 187 111 167 112 126 113 80 116 74 112
Polygon -7500403 true true 149 190 136 218 131 230 148 230 158 235 147 233 127 233 111 237 127 230 136 209 139 191
Polygon -7500403 true true 118 191 104 211 82 213 104 215 124 218 109 212

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

dragonfly
true
0
Circle -7500403 true true 148 57 18
Circle -7500403 true true 137 57 18
Circle -7500403 true true 144 54 14
Circle -7500403 true true 140 71 22
Circle -7500403 true true 144 96 14
Polygon -7500403 true true 150 105 144 104 145 120 147 164 148 180 148 192 147 202 152 209 156 203 155 192 155 180 156 165 158 122 158 101 155 107 153 108
Polygon -7500403 true true 142 80 116 76 71 70 48 69 28 70 18 79 20 89 42 97 80 96 113 92 141 88
Polygon -7500403 true true 141 91 128 94 99 101 68 112 55 116 41 123 38 136 50 142 103 139 123 133 133 117 138 103
Circle -7500403 true true 141 83 20
Polygon -7500403 true true 158 80 184 76 229 70 252 69 272 70 282 79 280 89 258 97 220 96 187 92 159 88
Polygon -7500403 true true 159 91 172 94 201 101 232 112 245 116 259 123 262 136 250 142 197 139 177 133 167 117 162 103

dragonfly 1
true
0
Circle -7500403 true true 148 57 18
Circle -7500403 true true 137 57 18
Circle -7500403 true true 144 54 14
Circle -7500403 true true 140 71 22
Circle -7500403 true true 144 96 14
Polygon -7500403 true true 150 105 144 104 145 120 147 164 148 180 148 192 147 202 152 209 156 203 155 192 155 180 156 165 158 122 158 101 155 107 153 108
Polygon -7500403 true true 142 80 116 76 71 70 48 69 28 70 18 79 20 89 42 97 80 96 113 92 141 88
Polygon -7500403 true true 141 91 128 94 99 101 68 112 55 116 41 123 38 136 50 142 103 139 123 133 133 117 138 103
Circle -7500403 true true 141 83 20
Polygon -7500403 true true 158 80 184 76 229 70 252 69 272 70 282 79 280 89 258 97 220 96 187 92 159 88
Polygon -7500403 true true 159 91 172 94 201 101 232 112 245 116 259 123 262 136 250 142 197 139 177 133 167 117 162 103
Polygon -16777216 true false 210 75 225 75
Line -16777216 false 256 71 242 71
Line -16777216 false 44 71 58 71
Line -16777216 false 245 118 231 113
Line -16777216 false 55 118 69 113

dragonfly 2
false
0
Polygon -7500403 true true 187 62 201 62 221 68 221 82 207 108 175 139 140 159 102 176 100 171 132 129 148 105 169 74
Polygon -7500403 true true 99 171 102 181 126 168 159 159 230 142 245 138 259 137 262 132 255 130 241 132 226 137 212 141 196 145 176 150 151 156 126 163
Polygon -16777216 true false 182 54 200 51 213 60 212 80 203 106 171 137 136 157 102 174 96 169 128 127 144 103 165 72
Circle -7500403 true true 56 183 10
Circle -7500403 true true 57 191 10
Polygon -7500403 true true 66 197 77 198 87 194 101 190 106 181 103 169 94 165 83 178 73 188 64 190
Polygon -7500403 true true 182 52 200 49 213 58 212 78 203 104 171 135 136 155 102 172 96 167 128 125 144 101 165 70
Polygon -7500403 true true 76 190 74 203 57 209 55 215 51 219 55 208 67 203 71 199 72 192
Polygon -7500403 true true 74 193 78 197 101 199 114 215 124 219 114 219 108 213 101 203 76 201
Polygon -7500403 true true 72 191 78 202 68 211 66 216 62 218 66 210 72 202 75 198 71 193

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish 2
false
0
Polygon -1 true false 56 133 34 127 12 105 21 126 23 146 16 163 10 194 32 177 55 173
Polygon -7500403 true true 156 229 118 242 67 248 37 248 51 222 49 168
Polygon -7500403 true true 30 60 45 75 60 105 50 136 150 53 89 56
Polygon -7500403 true true 50 132 146 52 241 72 268 119 291 147 271 156 291 164 264 208 211 239 148 231 48 177
Circle -1 true false 237 116 30
Circle -16777216 true false 241 127 12
Polygon -1 true false 159 228 160 294 182 281 206 236
Polygon -7500403 true true 102 189 109 203
Polygon -1 true false 215 182 181 192 171 177 169 164 152 142 154 123 170 119 223 163
Line -16777216 false 240 77 162 71
Line -16777216 false 164 71 98 78
Line -16777216 false 96 79 62 105
Line -16777216 false 50 179 88 217
Line -16777216 false 88 217 149 230

fish 3
false
0
Polygon -16777216 true false 3 149 41 126 85 114 118 112 157 121 270 156 137 193 87 198 38 183 5 161 22 161 12 152
Polygon -7500403 true true -1 146 37 123 81 111 114 109 153 118 266 153 133 190 83 195 34 180 1 158 18 158 8 149
Polygon -7500403 true true 86 180 87 203 95 222 106 205 110 197 114 182
Polygon -7500403 true true 164 172 182 191 206 200 187 184 188 166
Polygon -7500403 true true 256 158 268 177 284 192 274 169 268 154
Polygon -7500403 true true 82 114 83 92 90 79 96 88 103 99 151 119
Polygon -7500403 true true 161 125 179 106 203 97 184 113 185 131
Polygon -7500403 true true 256 151 268 132 284 117 274 140 268 156
Circle -1 true false 24 137 12
Circle -7500403 true true 25 142 6

fish 4
false
0
Polygon -7500403 true true 24 58 38 60 49 63 64 70 77 81 92 102 101 119 111 131 122 135 134 134 139 129 125 124 116 116 122 104 131 96 144 90 150 83 157 70 166 65 167 54 178 46 183 40 190 40 205 53 222 76 229 97 233 110 234 122 249 128 260 134 275 142 285 157 291 160 293 167 299 176 293 183 280 196 271 202 260 210 250 212 244 218 238 223 231 229 218 235 201 239 190 241 170 239 152 231 139 222 128 209 120 193 120 179 123 170 123 161 122 157 118 157 115 162 115 170 113 177 110 187 102 202 95 216 84 226 73 234 60 243 47 245 40 240 41 226 47 217 47 207 47 198 48 191 50 188 52 185 60 182 72 173 84 169 90 165 93 158 89 157 79 162 70 166 59 166 50 167 41 172 33 178 18 182 8 176 5 164 14 143 10 133 12 119 2 101 7 83 19 76 32 72 29 68 22 67 11 72 15 65
Polygon -7500403 true true 214 224 220 236 221 247 220 259 214 270 204 281 197 278 199 269 194 262 199 257 195 252 201 246 209 240 212 235 210 225
Polygon -16777216 true false 196 225 202 240 202 246 201 254 198 261 190 273 179 280 165 284 159 279 159 274 165 270 163 264 168 257 168 249 172 245 185 245 193 243 196 233
Polygon -7500403 true true 195 225 201 240 201 246 200 254 197 261 189 273 178 280 164 284 158 279 158 274 164 270 162 264 167 257 167 249 171 245 184 245 192 243 195 233
Circle -1 false false 273 159 12
Circle -16777216 true false 278 164 6

fish 5
false
0
Polygon -7500403 true true 0 144 15 120 30 105 75 75 106 66 150 45 184 37 210 45 195 60 180 75 210 105 225 135 240 135 255 105 270 90 285 75 270 120 265 137 264 152 265 168 270 180 285 225 270 210 255 195 240 165 225 165 210 195 180 225 210 255 182 262 150 255 108 235 75 225 30 195 15 180
Circle -1 false false 14 131 18
Circle -16777216 true false 15 137 10

fish 6
false
0
Polygon -7500403 true true 5 151 62 147 77 146 90 144 100 136 116 128 126 117 135 108 145 100 153 96 149 102 145 110 145 118 150 124 163 132 182 136 205 143 227 146 242 148 257 149 272 149 275 137 283 126 295 119 286 132 281 147 282 159 288 170 296 185 283 173 276 165 272 156 243 160 204 169 177 177 148 179 123 178 105 172 93 165 81 161 70 158 85 154
Polygon -7500403 true true 180 166 185 177 192 182 198 184 207 182 199 178 196 171 195 162 185 160
Polygon -7500403 true true 225 154 220 149 227 144 233 142 244 141 234 148 231 155 230 157 221 159
Polygon -7500403 true true 229 154 224 159 231 164 237 166 248 167 238 160 235 153 234 151 225 149
Circle -1 true false 97 142 4

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf-1
true
0
Polygon -7500403 true true 153 3 164 5 157 33 155 60 154 99 151 98 152 60 154 22 156 9
Polygon -7500403 true true 152 96 139 81 116 64 89 54 64 55 50 58 42 56 49 66 52 84 66 97 93 108 116 106 137 102
Polygon -7500403 true true 153 99 166 84 189 67 216 57 241 58 255 61 263 59 256 69 253 87 239 100 212 111 188 112 167 107
Polygon -7500403 true true 153 100 193 120 238 135 269 149 284 161 284 179 275 200 277 211 265 208 249 214 233 219 218 215 208 198 202 184 194 166 178 141 165 125
Polygon -7500403 true true 151 97 109 113 64 128 33 142 18 154 18 172 27 193 25 204 37 201 53 207 69 212 84 208 94 191 100 177 108 159 124 134 137 118
Polygon -7500403 true true 152 96 138 126 120 169 109 199 101 219 94 238 94 251 97 260 106 276 129 282 142 284 148 288 152 299 156 285 166 279 180 276 201 266 207 249 206 230 195 201 170 150

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

moth
true
0
Polygon -16777216 true false 150 54 138 61 132 65 116 102 76 178 57 232 62 260 72 281 92 277 129 258 143 250 146 266 151 276 156 266 160 250 170 258 183 263 212 278 229 281 240 262 242 232 226 180 186 101 169 63 163 60
Polygon -7500403 true true 151 52 139 59 133 63 117 100 77 176 58 230 63 258 73 279 93 275 130 256 144 248 147 264 152 274 157 264 161 248 171 256 184 261 213 276 230 279 241 260 243 230 227 178 187 99 170 61 164 58
Circle -7500403 true true 141 35 18
Circle -7500403 true true 135 39 30
Polygon -7500403 true true 146 41 130 34 114 28 94 26 90 27 101 32 118 33 138 40
Polygon -7500403 true true 130 68 122 54 117 37 113 25 99 9 116 24 121 38 128 53 137 67
Polygon -7500403 true true 130 81 114 71 98 83 76 107 49 117 35 126 28 128 34 129 31 137 42 123 76 110 71 121 85 100 93 94 102 113 97 90 112 79 123 96
Polygon -7500403 true true 154 41 170 34 186 28 206 26 210 27 199 32 182 33 162 40
Polygon -7500403 true true 168 71 176 57 181 40 185 28 199 12 182 27 177 41 170 56 161 70
Polygon -7500403 true true 170 81 186 71 202 83 224 107 251 117 265 126 272 128 266 129 269 137 258 123 224 110 229 121 215 100 207 94 198 113 203 90 188 79 177 96

mouse side
false
0
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

shark
false
0
Polygon -7500403 true true 283 153 288 149 271 146 301 145 300 138 247 119 190 107 104 117 54 133 39 134 10 99 9 112 19 142 9 175 10 185 40 158 69 154 64 164 80 161 86 156 132 160 209 164
Polygon -7500403 true true 199 161 152 166 137 164 169 154
Polygon -7500403 true true 188 108 172 83 160 74 156 76 159 97 153 112
Circle -16777216 true false 256 129 12
Line -16777216 false 222 134 222 150
Line -16777216 false 217 134 217 150
Line -16777216 false 212 134 212 150
Polygon -7500403 true true 78 125 62 118 63 130
Polygon -7500403 true true 121 157 105 161 101 156 106 152

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

sperm
true
0
Polygon -7500403 true true 150 0 120 45 105 90 105 105 120 135 150 150 180 135 195 105 195 90 180 45 150 0
Polygon -7500403 true true 145 149 127 169 127 188 174 207 200 230 200 249 161 271 92 277 132 283 163 278 206 253 207 225 177 200 137 183 138 171 151 162 155 147

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wenzi 2
false
0
Circle -7500403 true true 191 170 20
Circle -7500403 true true 147 139 50
Polygon -7500403 true true 159 149 136 146 120 140 102 132 81 131 66 134 53 141 55 143 54 144 54 146 57 148 66 150 79 153 94 153 110 157 122 161 129 164 136 167 149 168 152 166
Polygon -7500403 true true 171 147 159 135 148 102 151 75 157 30 161 27 171 104 172 128
Polygon -7500403 true true 158 140 119 78 79 26 66 24 62 37 70 65 80 88 99 111 133 135 161 149
Polygon -7500403 true true 203 190 200 258 206 186
Line -7500403 true 176 186 223 142
Line -7500403 true 223 142 221 213
Line -7500403 true 221 214 266 242
Line -7500403 true 159 185 166 237
Line -7500403 true 166 238 188 259
Line -7500403 true 96 133 72 104
Line -7500403 true 93 152 54 182
Line -7500403 true 55 183 10 164
Line -7500403 true 72 106 21 179
Line -7500403 true 23 180 4 188

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
