globals [turt_size max_er_level k l m n e_global managers_num choice_opens_at choice_num problem_opens_at problem_num jia ika ee_man_per_tick choice_ee_up?]
breed [choices choice]
choices-own [num  open? ee  er decison_type]
breed [problems problem]
problems-own [num  solved? er  my_choice_num my_next_choice_num]
breed [managers manager]
managers-own [num  ee  my_choice_num my_next_choice_num]
;-----------------------------------------------------
;
; Choices and Problems activated randomly
;
;-----------------------------------------------------
to setup
  clear-all

  set_structure
  set turt_size 1
  set max_er_level 10
  set choice_num 0
  set problem_num 1
  set managers_num 1
  set ee_man_per_tick full_system_ee / model_size / model_size / 2
  open_managers ;; create model_size quantity of managers
;------------------------------------------------ choice_opens_at
  set choice_opens_at n-values model_size [ ?1 -> ?1 ]
  set choice_opens_at shuffle choice_opens_at
  set k position 0 choice_opens_at
  set choice_opens_at replace-item k choice_opens_at model_size
 ;  find 0 at list and replace it to model_size )))))))
  set choice_opens_at fput 0 choice_opens_at
 ;; show choice_opens_at ;; {4 Observer}

  open_choice   ;; create fake-choice (grey colored, #0) for just born problems attachment
  ask choices with [num = 0] [set open? false set shape "circle 2" set color gray]

;------------------------------------------------  problem_opens_at
  set problem_opens_at n-values (2 * model_size) [ ?1 -> ?1 ]
  set problem_opens_at shuffle problem_opens_at
  set k position 0 problem_opens_at
  set problem_opens_at replace-item k problem_opens_at (2 * model_size)
  set problem_opens_at fput 0 problem_opens_at ;; the value is no matter (0 or ...)
 ;; show problem_opens_at ;; {4 Observer}

  reset-ticks ;;
end
;--------------------------------------------------
to go

   if ticks < model_size  [set choice_num choice_num + 1 open_choice]
   if ticks < model_size  [open_problem]

   problems_seek_best_choice
   managers_seek_best_choice
   ask problems with [not solved?] [problem_move num my_next_choice_num] ; and migrate
   ask managers [manager_move num my_next_choice_num] ; and migrate

   energy_changes ;; transfer ee from manager 2 choice
   decisions?
   if (sum [ee] of managers = 0) [stop]

   tick

end
;------------------------------------------------
to open_choice
  create-ordered-choices 1   [
    set color yellow    set size turt_size + 4    set shape "circle"
    set num (item choice_num choice_opens_at)   set open? true    set label num set decison_type "Oversight"
    set ee 0 set er 0
    set xcor 0 set ycor 5 * turt_size * num
    ]
end
;---------------------------------------------------
to open_managers ;; creates model_size instance of managers
   create-ordered-managers model_size
    [
    set color white    set size turt_size + 2     set shape "person";;"turtle"
    set num managers_num set managers_num managers_num + 1
    set label num
    set ee full_system_ee / model_size   ;; manager's full energy  volume
    set my_choice_num 0    ;; at activation managers are attached 2 chiose # 0 (fake choise)
    set xcor (3) * turt_size * (num + 1) set ycor 0
    ]
   if (managers_num  > model_size) [set managers_num  model_size]
end
;-------------------------------------------------
to open_problem
   create-ordered-problems 2   [
    set color blue set size turt_size + 2 set shape "face sad"
    set num (item problem_num problem_opens_at) set problem_num problem_num + 1
    set label num set solved? false
    set er full_system_ee / model_size / 2 * load / max_er_level
    set my_choice_num 0 ;; at activation problems are attached 2 chiose # 0 (fake choise)
    set xcor (- 3) * turt_size * (num + 1) set ycor 0
    ]
   if (problem_num > 2 * model_size) [set problem_num model_size * 2]
end
;--------------------------------------------------
to problems_seek_best_choice
   ask problems with [not solved?]
   [
     set l full_system_ee + 1 ;; more then max energy valuue 4 the model_size
     set k my_choice_num set m k
     set n num ;; 2
     set e_global er
     ask choices with [open?]
     [
      let j num
      if (item j (item n jia) = 1) ;;n-th problem has access to j-th choice
      [
       ifelse (k = num) or (k = 0)
       [
         let eer er - ee
         ;; show (word "er " eer " l " l "if 1") ;; {4 Observer}
         if ( eer < l) [set l eer set m num ]
       ] ;; the problem attaced to the choice or to choice # 0
       [
         let eer e_global + er - ee
         ;; show (word "eer " eer " l " l "if 2") ;; {4 Observer}
         if (eer < l) [set l  eer set m num ]
       ; old  if (e_global + er - ee + 0.0001 < l) [set l  e_global + er - ee set m num ]
       ] ;;  the problem not attaced to the choice
      ]
     ]
  ;;   show (word "er-ee " l " # " m) ;; {4 Observer}
     set my_next_choice_num m
   ]
end
;---------------------------------------------------
to managers_seek_best_choice
  ask managers ;with []
   [
     set l full_system_ee + 1 ;; more then max energy value 4 the model size
     set k my_choice_num set m k
     set n num

     ask choices with [open?]
    [ ;; 2
    let j num ;; 2
    if (item j (item n ika) = 1) ;;n-th manager has access to j-th choice
           [if (er - ee < l) [set l er - ee set m num ] ] ;First naive try
    ] ;; 2
     set my_next_choice_num m
   ]
end
;---------------------------------------------------
to problem_move [i j] ;; problem i moves to choice j
  ask choices with [num = j and open?]
  [
      ask  problems with [num = i and not solved?]
      [
        let llocal my_choice_num
        let elocal er
        set my_choice_num  j
        ask choices with [num = llocal] [set er er - elocal]  ;; old choise ER decrease
        ask choices with [num = j] [
                                   set er er + elocal   ;; new choce ER increase,
                                   if (decison_type = "Oversight") [set decison_type "Flight"]
                                   ];; decision type correct to "Flight" because now the choice has a problem
        set xcor (- 3) * turt_size * (num + 1) set ycor 5 * turt_size * j
      ]
  ]
end
;----------------------------------------------------
to manager_move [i j] ;; manager i moves to choice j
  ask choices with [num = j and open?]
  [
      ask  managers with [num = i]
      [
        set my_choice_num  j
        set xcor (3) * turt_size * (num + 1) set ycor 5 * turt_size * j
      ]
  ]
end
;--------------------------------------
to energy_changes ;; choices & managers
    ask managers
    [
     set choice_ee_up? false
     let llocal my_choice_num
     ifelse (ee - ee_man_per_tick >= 0)
       [ask choices with [num = llocal][set ee ee + ee_man_per_tick set choice_ee_up? true]]
       [set ee 0]

     if (choice_ee_up?) [set ee ee - ee_man_per_tick]
    ;; show ee ;; {4 Observer}
    ]
end
;---------------------------------------------------
to decisions?
   ask choices with [open?]
   [
  ;; show (word "er " er " ee " ee) ;; {4 Observer}
   if (er <= ee)
     [
       if (er > 0.0000001) ; I mean "er > 0", but calculation errorrrs...
          [
            set decison_type "Resolution"
          ]
       set open? false set shape "circle 2" set label decison_type
       set l num
       ask problems with [my_choice_num = l] [set solved? true set color pink set shape "face happy"]
     ]
   ]
end
;-----------------------------------------------
to set_structure
    ; Specialized access structure (problems 2 choices)
    ; jia original CMO(GCM) name 4 access structure array - problems * choices
    ; ika - decision structure - choices * managers
    ; ... (item l (item k jia)) ;k is block's (problem's) number,
    ;l - number in block (sublist of choices), value: 1 - access exist ,0 - no

; Unsegmented access structure (problems 2 choices)
let Unsegmented_problems_choices [[] [0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1]]
; Hierarchical access structure (problems 2 choices)
let Hierarchocal_problems_choices [[] [0 1 1 1 1 1 1 1 1 1 1] [0 1 1 1 1 1 1 1 1 1 1] [0 0 1 1 1 1 1 1 1 0 1][0 0 1 1 1 1 1 1 1 1 1]
    [0 0 0 1 1 1 1 1 1 1 1][0 0 0 1 1 1 1 1 1 1 1][0 0 0 0 1 1 1 1 1 1 1] [0 0 0 0 1 1 1 1 1 1 1]
    [0 0 0 0 0 1 1 1 1 1 1][0 0 0 0 0 1 1 1 1 1 1][0 0 0 0 0 0 1 1 1 1 1] [0 0 0 0 0 0 1 1 1 1 1]
    [0 0 0 0 0 0 0 1 1 1 1][0 0 0 0 0 0 0 1 1 1 1][0 0 0 0 0 0 0 0 1 1 1] [0 0 0 0 0 0 0 0 1 1 1]
    [0 0 0 0 0 0 0 0 0 1 1][0 0 0 0 0 0 0 0 0 1 1][0 0 0 0 0 0 0 0 0 0 1] [0 0 0 0 0 0 0 0 0 0 1]]
; Specialized access structure (problems 2 choices)
let Specialized_problems_choices [[] [0 1 0 0 0 0 0 0 0 0 0] [0 1 0 0 0 0 0 0 0 0 0] [0 0 1 0 0 0 0 0 0 0 0][0 0 1 0 0 0 0 0 0 0 0]
   [0 0 0 1 0 0 0 0 0 0 0][0 0 0 1 0 0 0 0 0 0 0][0 0 0 0 1 0 0 0 0 0 0] [0 0 0 0 1 0 0 0 0 0 0]
   [0 0 0 0 0 1 0 0 0 0 0][0 0 0 0 0 1 0 0 0 0 0][0 0 0 0 0 0 1 0 0 0 0] [0 0 0 0 0 0 1 0 0 0 0]
   [0 0 0 0 0 0 0 1 0 0 0][0 0 0 0 0 0 0 1 0 0 0][0 0 0 0 0 0 0 0 1 0 0] [0 0 0 0 0 0 0 0 1 0 0]
   [0 0 0 0 0 0 0 0 0 1 0][0 0 0 0 0 0 0 0 0 1 0][0 0 0 0 0 0 0 0 0 0 1] [0 0 0 0 0 0 0 0 0 0 1]]

  if (problems_choices ="Unsegmented")
  [set jia Unsegmented_problems_choices]
  if (problems_choices ="Hierarchocal")
  [set jia Hierarchocal_problems_choices]
  if (problems_choices ="Specialized")
  [set jia Specialized_problems_choices]

; Unsegmented decision structure (managerss 2 choices)
let Unsegmented_managers_choices [[] [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1]
    [0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1][0 1 1 1 1 1 1 1 1 1 1]]
; Hierarchical decision structure (managerss 2 choices)
let Hierarchocal_managers_choices [[] [0 1 1 1 1 1 1 1 1 1 1][0 0 1 1 1 1 1 1 1 1 1][0 0 0 1 1 1 1 1 1 1 1]
    [0 0 0 0 1 1 1 1 1 1 1][0 0 0 0 0 1 1 1 1 1 1][0 0 0 0 0 0 1 1 1 1 1][0 0 0 0 0 0 0 1 1 1 1]
    [0 0 0 0 0 0 0 0 1 1 1][0 0 0 0 0 0 0 0 0 1 1][0 0 0 0 0 0 0 0 0 0 1]]
;Specialized decision structure (managers 2 choices)
let Specialized_managers_choices [[] [0 1 0 0 0 0 0 0 0 0 0][0 0 1 0 0 0 0 0 0 0 0] [0 0 0 1 0 0 0 0 0 0 0]
   [0 0 0 0 1 0 0 0 0 0 0][0 0 0 0 0 1 0 0 0 0 0] [0 0 0 0 0 0 1 0 0 0 0][0 0 0 0 0 0 0 1 0 0 0]
   [0 0 0 0 0 0 0 0 1 0 0][0 0 0 0 0 0 0 0 0 1 0] [0 0 0 0 0 0 0 0 0 0 1]]

  if (managers_choices ="Unsegmented")
  [set ika Unsegmented_managers_choices]
  if (managers_choices ="Hierarchocal")
  [set ika Hierarchocal_managers_choices]
  if (managers_choices ="Specialized")
  [set ika Specialized_managers_choices]

end
@#$#@#$#@
GRAPHICS-WINDOW
246
8
891
391
-1
-1
6.133
1
12
1
1
1
0
1
1
1
-65
38
-5
55
1
1
1
ticks
30.0

BUTTON
14
44
82
77
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
166
44
234
77
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
84
44
165
77
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
47
8
198
41
model_size
model_size
1
10
10.0
1
1
NIL
HORIZONTAL

PLOT
17
287
237
408
EE wasted
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -15390905 true "" "plot sum [ee] of choices with [not open? and (decison_type = \"Flight\")]"
"pen-1" 1.0 0 -13290229 true "" "plot sum [ee] of choices with [not open? and (decison_type = \"Oversigth\")]"

SLIDER
4
80
128
113
full_system_ee
full_system_ee
0
100
10.0
1
1
NIL
HORIZONTAL

SLIDER
132
80
243
113
load
load
1
max_er_level
5.0
1
1
NIL
HORIZONTAL

PLOT
16
164
235
285
Total current ER
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -8053223 true "" "plot sum [er] of problems with [not solved?]"

CHOOSER
3
116
127
161
problems_choices
problems_choices
"Unsegmented" "Hierarchocal" "Specialized"
0

CHOOSER
131
115
246
160
managers_choices
managers_choices
"Unsegmented" "Hierarchocal" "Specialized"
0

@#$#@#$#@
## WHAT IS IT?

It is reconstruction of the original FORTRAN code of the classical M. Cohen, J. March, and J. Olsen "garbage can model" (GCM or CMO) of collective decision making.


## HOW IT WORKS
The concept of GCM is decision making, which resolve Problems. Problems have Energy Required (ER) for their decision, Managers (decision makers) have Effective Energy (EE) for the decisions generation. The place of decision making is the Choice Opportunities (Choices) - abstraction of commitees, consul boards and so on.

The Choices and Problems open randomly. The Problems activated by two items and Choices by one item per step of modellig (tick) in first halfe of modelling time. All Managers are ready for action from first modelling step.

Problems and Managers access to Choices in according with system structrure. There is three types of Problems access to Choices and three types of Managers access to Choices.

Unsegmented access type is full access for all Problems (Managers) to all Choices. Hierarchocal access type is access for first and second Problems (first Manager) to Choice number one, access for third and fourth Problems (second Manager) to Choices number one and number two and so on. Spezialized access type is access for first and second Problems (first Manager) only to Choice number one, access third and fourth Problems (second Manager) only to Choices number two and so on.

On each step of modelling Problems and Managers cheks the accesabe (in accordind with system structure) Choices for minimal level of (ER - EE), i.e. Choice nearest to dicision, and migrate to it. Then, all opened Choices cheks decision rule.

If ER <= EE decision with type "Resolution" carried out, the Choice and attached to it Problems closed. If no one Problem attached to open Choice at the step of modelling, Choice will be closed. There is decision "Oversight" (no problems for the committee).
If it was Problems in the Choice in past, but now Problems leave the Choice (migrates to other Choices), Choice closes. There is decision "Flight". EE of Managers, accumulated in the Choice, wasted.

The main diference between Problems and Managers is: Problems transfers their ER from Choice to Choice in the process of migration, but Managers get their EE by quantums (quantum volume is equal FULL_SYSTEM_EE / MODEL_SIZE / MODEL_SIZE / 2) and leave EE in Choices in the process of migration.

The critical parameter for effective work of decision making system is ratio between total EE of system (nominal total EE value is exogenuos parameter, controlled by FULL_SYSTEM_EE slider) and total Energy Required (ER) of Problems. The LOAD slider controls the ratio.

## HOW TO USE IT

The MODEL_SIZE slider controls how many Choices will be created. It's define size of model, so (following the original GCM) number of decision makers (Managers) is equal to MODEL_SIZE, number of Problems is equal to 2 * MODEL_SIZE and time of decision making process continue, i.e. total modeling time, is equal to 2 * MODEL_SIZE.

The LOAD slider controls level of total Energy Required (ER) of problems as part of total Effective Energy (EE) of Managers (value 10 fit to 100% Load, ER = EE).

The FULL_SYSTEM_EE slider set (only) nominal numeric level of EE.

The SETUP button set the system structure in accordind with "PROBLEMS_CHOICES" and "MANAGERS_CHOICES" settings. To advance the model one step at a time, use the GO ONCE button. The GO button keeps the model running until Effective energy (EE) of Managers more then 0 (time period equal to 2 * MODEL_SIZE).

The numbers in the view show the numbers of opened Choices and, after Choise closing, text show the type of Decision. Choices, remaining open at the end of modelling, are shown as full yellow circles.

The upper plot show Total current ER of all unsolved Problems. The lower plot show Effective energy wasted in the Choices, which was closed without Problems resolving. The Green line show EE wasted in "Oversight" decision type and the Blue line - in "Flight".

## THINGS TO NOTICE

For the MODEL_SIZE equal 1 both Problems will be resolved for any LOAD level.

## THINGS TO TRY

Try varying LOAD for fixed MODEL_SIZE and structure. How many problems will be resolved and Choices closed?

Try varying the sistem structure (by "PROBLEMS_CHOICES" and "MANAGERS_CHOICES" settings). What types of Decision types will appear?

## EXTENDING THE MODEL

Presented model literally reproduces the original logic of GCM (with one exception: the equal effective energy distribution between managers assumed). There is not any modifications unlike to, in particular, Guido Fioretti modification where decisions are independent NetLogo objects, rather than a product produced by the decision rule checking in the Choices.

You can, by analogy with Guido Fioretti modification, change the rule of managers EE storage, allowing it to increase in the event of the closure Choice by decision type "Resolution" (managers become more effective in the process of decision making).

It is also interesting to investigate the decision-making process in a dynamically changing structure.


## NETLOGO FEATURES

The world topology is a "torus" with -65,30 xcor and -5,55 ycor.

The structure of Problem's and Manager's access to Choices is implemented as two-level lists.

You can take off ";;" at the lines marked by "{4 Obswerver}" and look at some data values in Observer window.

## RELATED MODELS

The Garbage Can Model of Organizational Choice
by Guido Fioretti, posted Jun 22, 2013 at openabm.org
https://www.openabm.org/model/3840/version/1/view

Garbage can model Excel reconstruction
by Ivan Smarzhevskiy, posted Aug 19, 2014  at openabm.org
https://www.openabm.org/model/4310/version/3/view

## CREDITS AND REFERENCES

This model is based on the work of the
Cohen, M., March, J. & Olsen, J., 1972. A Garbage Can Model of Organizational Choice. Administrative Science Quarterly, Volume 17, pp. 1-25.
See also:
Fioretti, G. & Lomi, A., 2008. An Agent-Based Representation of the Garbage Can Model of Organizational Choice. Journal of Artificial Societies and Social Simulation <http://jasss.soc.surrey.ac.uk/11/1/1.html>, 11(11).
Fioretti, G. & Lomi, A., 2010. Passing the Buck in the Garbage Can Model of Organizational Choice. G. Fioretti and A. Lomi: Passing the Buck in tComputational and Mathematical Organization Theory, Issue 16 (2), pp. 113-143.
Smarzhevskiy, I., 2014. Garbage Can Model: Reconstruction and Logical Analysis : http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2490388.
Smarzhevskiy, I., 2014 Four Border Structures in GCM (Small Addition to the 'Garbage Can Model: Reconstruction and Logical Analysis'):
http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2519433

## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the model itself:

Smarzhevskiy, I., 2014. Garbage Can Model: Reconstruction and Logical Analysis : http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2490388.
Smarzhevskiy, I., 2014 Four Border Structures in GCM (Small Addition to the 'Garbage Can Model: Reconstruction and Logical Analysis'):
http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2519433

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 1997 Uri Wilensky.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.


<!-- 2015 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
setup
repeat 20 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
