breed [leaves a-leaf]
breed [pumpkins pumpkin]
breed [persons person]

globals [x y   ;mouse position
         z  zs zl    ;parent pumpkin size    smallest size     largest size
         x1 y1
         ]
pumpkins-own [weight]


to setup
ca
  setup-patches

  create-leaves 15 + random 10
   [set color green + random-float 1
     set size 0.3 + random-float 0.4
     set shape "leaf-2"
      set-leaves]

  create-pumpkins 25 + random 7
        [set size (0.3 + random-float 0.3)      ;set initial pumpkin size based on water and fertilizer
         set weight (200 * (size) ^ 2)          ;set weight based on size
         set label round weight                 ;round the weight
         set heading -45 + random 90
         set color 25
         set shape "pumpkin-4"
        place-pumpkins]

  output-print "Welcome! The pumpkin contest begins now! Your goal is to"
  output-print "grow a pumpkin that weighs at least 500 pounds."
  output-print " "
  output-print "First pick a pumpkin from the patch below,and then plant it. You may"
  output-print "also adjust the amount of water and fertilizer for the pumpkins."

  reset-ticks

end


to setup-patches
  ask patches [set pcolor 51.5 + random-float 1]
end

to set-leaves
  setxy random-xcor random-ycor
end

to place-pumpkins
  setxy random 6 random 7
  if any? other pumpkins-here [place-pumpkins]
  if xcor = max-pxcor and ycor = max-pycor [place-pumpkins]     ; leave this patch blank
  if xcor = max-pxcor and ycor = max-pycor - 1 [place-pumpkins] ; leave this patch blank
  if xcor = max-pxcor and ycor = max-pycor - 2 [place-pumpkins] ; leave this patch blank
end

to pick-pumpkin

 clear-output
 ifelse any? pumpkins-on patches with [pxcor = max-pxcor and pycor = max-pycor]
  [user-message ("You may plant the pumpkin now") stop]
  [if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask pumpkins with [xcor = x and ycor = y] [setxy max-pxcor max-pycor set heading -30 + random 60 ]]]  ;use mouse to pick a pumpkin and put it to the top-right corner

  let N count pumpkins-on patches with [pxcor = max-pxcor and pycor = max-pycor ] ; if a pumpkin is picked
  if N > 0 [
    ask pumpkins with [xcor < max-pxcor] [die]  ;remove the rest of the pumpkins
    ask pumpkins with [ycor < max-pycor] [die]
    if count persons > 0 [ask persons [die]]    ;double check to ensure no person
    ask leaves [die]

   create-leaves 20                             ; recreate leaves
   [set color green + random-float 1
     set size 0.2 + random-float 0.4
     set shape "leaf-1"
     setxy (random-float max-pxcor) (random-float max-pycor)]

    create-persons 1                            ; recreate a person(for fun)
  [set shape "farmer"
    set size 0.6
    setxy 4.5 5.5]

  output-print (word "Good!" "You just pick a " round (min [weight] of pumpkins with [pxcor = max-pxcor and pycor = max-pycor ]) " pound pumpkin.")
  output-print " "
  output-print ("Now you may plant its seeds.")

  stop
  ]]



end

to plant

clear-output                                            ; clear previous results

  ifelse count pumpkins > 1                                 ;check if pumpkin has been picked
  [user-message ("Please pick your pumpkin.") stop]         ; if not, ask user to pick a pumpkin
  [ask leaves [die] ask persons [die]                       ; if yes, clear leaves and person agents



 ask pumpkins with [xcor = max-pxcor and ycor = max-pycor] [set z size die]  ;obtain the parent pumpkin size

    create-pumpkins 22 + random 9       ;plan seeds
    [ set color 29
      set shape "p-seed"
      set size 0.15
      set heading -45 + random 90
    place-pumpkins
    ]

wait 0.3
 ask pumpkins [                 ; germination
 set shape "p-sprouts"
 set color green
 set size 0.6
 set heading 0]

wait 0.3

 if water > 3 or fertilizer > 3 [ask pumpkins [set color 37 wait 0.1 die]        ;if too much water or fertilier, sprouts die.

  output-print "Oh no! All pumpkins die."
  output-print " "
  output-print "Did you give too much water or fertilizer?"
  output-print " "
  output-print "Let's start over."]

 create-leaves 15 + random 10           ;grow leaves
    [set color green + random-float 1
     set size 0.4 + random-float 0.4
     set shape "leaf-2"
        set-leaves]

if count pumpkins > 0                         ;if sprouts survive
    [ask pumpkins [                           ;grow pumpkin
      set shape "pumpkin-4"
      set color 25
      ifelse random 2 = 0 [set size z + random-float (0.01 * fertilizer) + water * 0.005][set size z - random-float 0.04]   ;determine the size range
      if size < 0.1 [set size 0.1]
      set weight (200 * (size) ^ 2)
      set label round weight
  set heading -45 + random 90]

      do-plot]]  ;re-plot the pumpkin weight variation

  tick

if count pumpkins > 0
  [output-print (word "You have grown the pumpkins for " ticks " years.")
   output-print " "
   output-print (word "The LARGEST pumpkin in this patch weighs " round (max [weight] of pumpkins) " pounds.")
   output-print (word "The SMALLEST pumpkin in this patch weighs " round (min [weight] of pumpkins) " pounds.")]

end

to big-pumpkin
ask one-of pumpkins with-max [size]
  [set shape "pumpkin-face" ]
end

to small-pumpkin
ask one-of pumpkins with-min [size]
  [set shape "pumpkin-face" ]
end


to do-plot
  if count pumpkins > 0
 [ set-current-plot "Variation in Pumpkin Weight"
   set-plot-x-range (round (min [weight] of pumpkins) - 1) (round (max [weight] of pumpkins) + 1)
   set-plot-y-range 0 (count pumpkins / 2)
    histogram [weight] of pumpkins]

end


;-------------

to plant-without-selection

  if leaves != nobody [ask leaves [die]]
  if persons != nobody [ask persons [die]]

  clear-output                                            ; clear previous results

  ask one-of pumpkins with-min [size] [set zs size]       ;find the smallest size
  ask one-of pumpkins with-max [size] [set zl size]       ;find the largest size
  ask pumpkins [die]


  create-pumpkins 22 + random 9       ;plan seeds
    [ set color 29
      set shape "p-seed"
      set size 0.15
      set heading -45 + random 90
    place-pumpkins
    ]

wait 0.3
 ask pumpkins [                 ; germination
 set shape "p-sprouts"
 set color green
 set size 0.6
 set heading 0]

wait 0.3

 if water > 3 or fertilizer > 3 [ask pumpkins [set color 37 wait 0.1 die]        ;if too much water or fertilier, sprouts die.

  output-print "Oh no! All pumpkins die."
  output-print " "
  output-print "Did you give too much water or fertilizer?"
  output-print " "
  output-print "Let's start over."]

 create-leaves 20 + random 10           ;grow leaves
    [set color green + random-float 1
     set size 0.4 + random-float 0.4
     set shape "leaf-2"
        set-leaves]

if count pumpkins > 0                         ;if sprouts survive
    [ask pumpkins [                           ;grow pumpkin
      set shape "pumpkin-4"
      set color 25
        ifelse random 100 < 5 [ifelse random 2 = 0 [set size zs - random-float 0.04] [set size zl + random-float 0.04]]   ; With a 5% chance, punmpkins are smaller or larger than the parent generation.
                               [set size zs + random-float (zl - zs)]         ;With a 95% chance, , punmpkin size fall within the range of parent size
      if size < 0.1 [set size 0.1]
      set weight (200 * (size) ^ 2)
      set label round weight
        set heading -45 + random 90]]



  do-plot  ;re-plot the pumpkin weight variation

  tick

if count pumpkins > 0
  [output-print (word "You have grown the pumpkins for " ticks " years.")
   output-print " "
   output-print (word "The LARGEST pumpkin in this patch weighs " round (max [weight] of pumpkins) " pounds.")
   output-print (word "The SMALLEST pumpkin in this patch weighs " round (min [weight] of pumpkins) " pounds.")]

end
@#$#@#$#@
GRAPHICS-WINDOW
9
95
449
608
-1
-1
72.0
1
10
1
1
1
0
1
1
1
0
5
0
6
0
0
0
ticks
5.0

BUTTON
457
10
603
49
Find a pumpkin patch!
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
456
93
663
133
Press and then Pick a pumpkin
pick-pumpkin
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
665
93
824
133
Plant the pumpkin
plant
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
456
267
693
416
Average Pumpkin Weight
Year
Weight (lb)
0.0
2.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -5825686 true "plotxy ticks mean [weight] of pumpkins" "if count pumpkins > 0 [plotxy ticks mean [weight] of pumpkins]"

BUTTON
517
147
663
187
The LARGEST pumpkin
big-pumpkin
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
665
147
824
187
The SMALLEST pumpkin
small-pumpkin
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
455
162
539
181
SHOW ME:
12
125.0
1

PLOT
456
419
694
606
Variation in Pumpkin Weight
Weight (lb)
# of Pumpkins
0.0
10.0
0.0
6.0
true
false
"" ""
PENS
"default" 1.0 1 -5825686 true "if count pumpkins > 0 [set-plot-x-range (round (min [weight] of pumpkins) - 1) (round (max [weight] of pumpkins) + 1)\nset-plot-y-range 0 6\nhistogram [weight] of pumpkins]" "if count pumpkins > 0 [set-plot-x-range (round (min [weight] of pumpkins) - 1) (round (max [weight] of pumpkins) + 1)\nset-plot-y-range 0 6\nhistogram [weight] of pumpkins]"

MONITOR
697
321
835
366
Smallest Pumpkin (lb)
min [weight] of pumpkins
0
1
11

MONITOR
697
371
835
416
Largest Pumpkin (lb)
max [weight] of pumpkins
0
1
11

TEXTBOX
456
244
842
262
----*----*----*----*----*----*----*----*----*----*----
12
125.0
1

MONITOR
697
419
755
472
Years
ticks
0
1
13

OUTPUT
9
10
450
93
11

SLIDER
456
201
639
234
Water
Water
1
4
3.0
1
1
NIL
HORIZONTAL

SLIDER
643
200
824
233
Fertilizer
Fertilizer
1
4
3.0
1
1
NIL
HORIZONTAL

TEXTBOX
456
76
559
94
DO SELECTION:
12
125.0
1

MONITOR
697
267
835
316
Average Weight (lb)
mean [weight] of pumpkins
0
1
12

BUTTON
605
10
824
49
Plant pumpkins without selection
plant-without-selection
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

@#$#@#$#@
## WHAT IS IT?
Have fun with planting pumpkins!!!! This model is created for k-5 students to understand the following core ideas in NGSS and conduct 3D learning.

3-LS3-1.	Analyze and interpret data to provide evidence that plants and animals have traits inherited from parents and that variation of these traits exists in a group of similar organisms.

3-LS3-2.	Use evidence to support the explanation that traits can be influenced by the environment.

NGSS standards: https://www.nextgenscience.org/dci-arrangement/3-ls3-heredity-inheritance-and-variation-traits



## HOW TO USE THE SIMULATION

1. Click on "Find a pumpkin patch!" to set up the simulation. You will get a patch in which pumpkins vary in size and weight.

2. To choose a pumpkin, click on the "Press and then pick a pumpkin" button, then you should be able to choose a pumpkin using the mouse. The pumpkin weight is labeled by the number next to it.

3. Once choosing your pumpkin, click on "Plant the pumpkin" to plant the pumpkin.

4. Use the button "The BIGGEST pumpkin" or "The SMALLEST pumpkin" to help you find the biggest or smallest pumpkin in the patch. It will smile at you ;).

5. Adjust the "water" and " Fertilizer" slides to water and fertilize pumpkins at a certain level. 

6. Click on "Plant pumpkins without selection" to plant pumpkin based on the average size from the parent generation with a 5% chance of increasing or decreasing the size. 

## KEEP IN MIND

1. In this simulation, pumpkins always vary in size and weight, which reveals the concept of variation. 

2. The pumpkin size is inheritable. Namely, bigger pumpkins produce big pumpkins on average, so do the smaller pumpkins.

3. The smallest pumpkin weight is defined as 1 pound so that you don't get a pumpkin that is smaller than 1. This is to avoid getting a negative size over time. 

4. The large end of the pumpkin weight is defined as 500 pounds, but you can keep going up. The world record is over 2000 pounds !!!

5. Insufficient water or fertilizer will limit pumpkin growth, so it will take much longer to get large pumpkins. But too much water and fertilizer will kill the pumpkins.

6. You may observe the changes in pumpkin size when no selection acts on the population. 



## CREDITS AND REFERENCES

This model is made by Dr. Lin Xiang at Weber State University. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2018). Pumpkin Contest. Zoology Department, Weber State University, Ogden, UT.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

farmer
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 60 195 90 210 114 154 120 195 180 195 187 157 210 210 240 195 195 90 165 90 150 105 150 150 135 90 105 90
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -13345367 true false 120 90 120 180 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 180 90 172 89 165 135 135 135 127 90
Polygon -6459832 true false 116 4 113 21 71 33 71 40 109 48 117 34 144 27 180 26 188 36 224 23 222 14 178 16 167 0
Line -16777216 false 225 90 270 90
Line -16777216 false 225 15 225 90
Line -16777216 false 270 15 270 90
Line -16777216 false 247 15 247 90
Rectangle -6459832 true false 240 90 255 300
Polygon -16777216 true false 141 65 148 70 154 70 161 62 154 65 148 65 141 64
Polygon -16777216 true false 168 45 165 42 160 41 158 43 158 45
Polygon -16777216 true false 132 45 135 42 140 41 142 43 142 45

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf-1
true
0
Polygon -7500403 true true 153 219 138 237 115 254 69 250 36 235 44 204 45 185 34 168 18 143 15 107 28 107 49 94 68 90 78 92 89 96 97 81 101 61 113 46 137 32 152 18 177 33 198 54 206 70 209 85 210 97 225 91 235 92 253 96 276 114 288 114 281 139 270 161 254 182 260 198 265 243 225 262 183 255 166 239
Polygon -14835848 true false 154 22 163 43 168 76 169 99 166 116 158 139 153 157 151 193 154 213 153 219 149 195 151 161 155 139 162 113 164 84 162 57 158 35
Polygon -14835848 true false 153 211 142 199 124 201 102 217 92 229 76 236 43 234 73 234 89 227 102 213 115 202 125 198 137 196 144 196
Polygon -14835848 true false 153 215 164 203 182 205 204 221 214 233 230 240 263 242 233 238 217 231 204 217 191 206 181 202 169 200 162 200
Polygon -14835848 true false 153 214 132 172 110 151 75 143 48 140 30 125 20 113 41 129 59 138 86 141 108 146 124 156 138 173 144 185
Polygon -14835848 true false 154 215 172 178 194 157 229 149 256 146 274 131 284 119 263 135 245 144 218 147 196 152 180 162 166 179 160 191
Polygon -7500403 true true 108 279 128 286 158 288 181 290 186 284 150 282 135 280 150 265 157 242 155 217 152 217 148 221 152 240 145 262 131 275 127 277 105 267 102 272 99 276

leaf-2
true
0
Polygon -7500403 true true 110 279 130 286 160 288 183 290 188 284 152 282 137 280 152 265 159 242 157 217 154 217 150 221 154 240 147 262 133 275 129 277 107 267 104 272 101 276
Polygon -7500403 true true 154 230 140 235 117 252 71 248 38 233 46 202 47 183 36 166 20 141 17 105 30 105 47 92 66 88 80 90 92 88 99 79 103 59 115 44 139 30 154 16 179 31 200 52 208 68 210 79 217 88 227 89 237 90 255 94 278 112 290 112 283 137 272 159 259 180 264 197 267 241 227 260 185 253 168 237
Polygon -14835848 true false 154 22 163 43 168 76 169 99 166 116 158 139 153 157 156 196 155 228 154 232 149 195 151 161 155 139 162 113 164 84 162 57 158 35
Polygon -14835848 true false 153 211 142 199 124 201 102 217 92 229 76 236 43 234 73 234 89 227 102 213 115 202 125 198 137 196 144 196
Polygon -14835848 true false 153 228 164 203 182 205 204 221 214 233 230 240 263 242 233 238 217 231 204 217 191 206 181 202 169 200 162 200
Polygon -14835848 true false 153 214 132 172 110 151 75 143 48 140 30 125 20 113 41 129 59 138 86 141 108 146 124 156 138 173 144 185
Polygon -14835848 true false 154 229 172 178 194 157 229 149 256 146 274 131 284 119 263 135 245 144 218 147 196 152 180 162 166 179 160 191

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

p-seed
true
0
Circle -7500403 true true 115 134 76
Polygon -7500403 true true 114 170 119 142 128 121 142 104 148 93 152 93 160 104 173 120 186 142 192 168 178 189 140 196

p-sprouts
true
0
Polygon -7500403 true true 150 149 144 135 134 125 114 116 86 115 72 124 65 136 65 148 71 152 88 154 108 153 126 150 140 149 150 154
Polygon -7500403 true true 150 149 156 135 166 125 186 116 214 115 228 124 235 136 235 148 229 152 212 154 192 153 174 150 160 149 150 154
Polygon -7500403 true true 150 127 150 136 148 151 150 162 148 182 154 181 154 159 153 151
Polygon -6459832 true false 129 186 145 183 150 180 158 182 169 184 177 187 159 185 154 184 149 184 136 187 126 187

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person farmer
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 60 195 90 210 114 154 120 195 180 195 187 157 210 210 240 195 195 90 165 90 150 105 150 150 135 90 105 90
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -13345367 true false 120 90 120 180 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 180 90 172 89 165 135 135 135 127 90
Polygon -6459832 true false 116 4 113 21 71 33 71 40 109 48 117 34 144 27 180 26 188 36 224 23 222 14 178 16 167 0
Line -16777216 false 225 90 270 90
Line -16777216 false 225 15 225 90
Line -16777216 false 270 15 270 90
Line -16777216 false 247 15 247 90
Rectangle -6459832 true false 240 90 255 300

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

pumpkin
false
0
Polygon -7500403 false true 148 30 107 33 74 44 33 58 15 105 0 150 30 240 105 285 135 285 150 270 165 285 195 285 255 255 300 150 268 62 225 43 196 36
Polygon -7500403 true true 33 58 0 150 30 240 105 285 135 285 150 270 165 285 195 285 255 255 300 150 268 62 226 43 194 36 148 32 105 35
Polygon -16777216 false false 108 40 75 57 42 101 32 177 79 253 124 285 133 285 147 268 122 222 103 176 107 131 122 86 140 52 154 42 193 66 204 101 216 158 212 209 188 256 164 278 163 283 196 285 234 255 257 199 268 137 251 84 229 52 191 41 163 38 151 41
Polygon -6459832 true false 133 50 171 50 167 32 155 15 146 2 117 10 126 23 130 33
Polygon -16777216 false false 117 10 127 26 129 35 132 49 170 49 168 32 154 14 145 1

pumpkin-1
true
0
Circle -7500403 true true 39 113 120
Circle -7500403 true true 130 107 128
Circle -7500403 true true 74 102 148
Circle -7500403 true true 159 98 104
Circle -7500403 true true 32 100 106
Circle -7500403 true true 68 97 84
Circle -7500403 true true 104 97 84
Circle -7500403 true true 137 99 84
Polygon -6459832 true false 108 122 117 117 126 123 129 132 131 132 131 121 141 117 149 119 160 125 162 125 157 116 168 113 179 115 178 114 162 109 157 102 157 91 164 81 171 74 168 65 155 59 144 59 149 65 149 72 145 82 143 91 139 103 135 107 127 108 115 106 113 106 123 111 118 113 108 118
Polygon -6459832 true false 167 129 182 146 193 172 192 205 184 223 190 204 189 173 180 151 169 137
Polygon -6459832 true false 185 119 211 127 225 138 239 154 250 177 236 152 215 132
Polygon -6459832 true false 127 137 120 146 112 172 107 201 110 220 110 192 118 158
Polygon -6459832 true false 103 125 84 132 70 143 59 156 52 172 52 174 63 153 84 135

pumpkin-2
true
0
Polygon -7500403 true true 87 104 68 111 50 134 32 172 30 213 42 241 64 261 88 272 109 269 130 274 154 271 182 274 203 268 228 263 239 255 257 239 269 210 265 169 241 127 221 106 198 100 181 103 162 98 142 103 123 100 106 106
Polygon -6459832 true false 106 108 83 128 68 172 63 199 67 236 77 253 88 270 69 250 60 228 58 191 67 154 77 128 90 116
Polygon -6459832 true false 138 105 119 116 99 142 89 167 89 193 89 219 94 244 105 261 114 268 96 241 93 209 94 186 94 170 101 147 116 126 126 115
Polygon -6459832 true false 147 107 162 127 170 149 175 170 174 206 162 245 144 271 165 247 178 208 179 165 167 127 156 115
Polygon -6459832 true false 185 107 206 126 225 175 225 211 209 253 189 271 205 253 222 208 221 174 205 132
Polygon -6459832 true false 201 104 231 127 247 155 256 179 257 210 244 239 229 258 244 234 255 207 253 177 236 142 220 122
Polygon -10899396 true false 98 106 110 100 122 100 129 95 132 81 132 74 128 65 122 59 128 54 139 51 156 49 150 59 150 66 152 77 151 84 150 89 150 92 164 95 175 95 184 99 189 103 176 108 160 103 145 104 139 107 126 105 119 104 110 107

pumpkin-3
true
0
Polygon -7500403 true true 72 122 85 116 95 115 104 117 114 123 123 124 130 125 139 125 148 123 154 122 161 114 169 111 173 111 180 111 188 111 195 113 205 115 215 120 208 122 198 125 196 130 181 133 175 142 168 147 158 148 141 142 122 144 106 145 98 139 89 133 83 123
Polygon -16777216 true false 190 132 191 122 211 116 226 121 235 134 237 163 234 182 225 198 207 210 212 168 206 145 198 138
Polygon -7500403 true true 192 134 193 124 213 118 228 123 237 136 239 165 236 184 227 200 209 212 214 170 208 147 200 140
Polygon -14835848 true false 124 90 135 86 146 85 152 90 147 93 145 104 145 110 146 114 148 125 160 130 173 136 191 147 164 142 154 141 145 144 133 155 133 146 124 144 103 156 109 145 106 140 88 142 110 137 122 130 129 125 129 115 125 101
Polygon -7500403 true true 85 134 80 121 63 120 49 123 40 136 38 165 41 184 50 200 60 210 66 171 69 147 77 140
Polygon -16777216 true false 173 141 178 131 191 129 204 133 216 147 218 158 222 176 220 195 214 204 209 214 203 224 197 231 194 233 191 232 187 228 185 221 188 201 182 183 181 163 179 149
Polygon -7500403 true true 171 144 176 134 189 132 202 136 214 150 217 160 221 180 222 194 220 204 215 215 210 226 204 232 197 236 190 237 186 232 183 224 186 204 180 186 179 166 177 152
Polygon -16777216 true false 109 141 104 131 91 129 76 131 64 141 57 156 53 173 54 190 59 203 64 214 70 223 76 229 83 233 90 234 94 229 97 221 94 201 100 183 101 163 103 149
Polygon -7500403 true true 110 144 105 134 92 132 77 134 65 144 58 159 54 176 55 193 60 206 65 217 71 226 77 232 84 236 95 239 99 234 103 226 95 204 101 186 102 166 104 152
Polygon -16777216 true false 133 141 126 136 117 135 110 135 104 137 100 143 96 147 91 160 87 174 87 186 87 197 88 209 92 223 95 231 101 240 107 248 114 252 124 253 134 245 134 236 132 225 131 200 129 176 132 156 136 148
Polygon -7500403 true true 135 143 128 138 119 137 112 137 106 139 102 145 98 149 93 162 89 176 89 188 89 199 90 211 93 226 97 237 103 245 109 253 116 256 126 255 136 247 136 238 134 227 133 202 131 178 134 158 138 150
Polygon -16777216 true false 154 143 157 136 164 132 172 132 182 133 193 140 202 155 205 175 205 195 203 208 200 222 194 235 186 243 177 248 167 248 149 234
Polygon -7500403 true true 153 147 156 140 163 136 171 136 181 137 192 144 201 159 204 179 204 199 204 213 199 226 193 239 185 247 176 252 166 252 148 238
Polygon -16777216 true false 130 137 119 150 115 163 112 183 112 206 115 221 121 240 132 253 147 255 163 249 173 227 177 205 176 179 168 154 159 139 143 133
Polygon -7500403 true true 131 140 120 153 116 166 113 186 113 209 116 224 122 243 133 256 148 257 162 250 172 230 175 207 173 183 167 159 158 142 144 136

pumpkin-4
true
0
Polygon -16777216 true false 90 108 71 115 53 138 35 176 33 217 45 245 67 265 91 276 112 273 133 278 157 275 185 278 206 272 231 267 242 259 260 243 272 214 268 173 244 131 224 110 201 104 184 107 165 102 145 107 126 104 109 110
Polygon -7500403 true true 87 104 68 111 50 134 32 172 30 213 42 241 64 261 88 272 109 269 130 274 154 271 182 274 203 268 228 263 239 255 257 239 269 210 265 169 241 127 221 106 198 100 181 103 162 98 142 103 123 100 106 106
Polygon -6459832 true false 106 108 83 128 68 172 63 199 67 236 77 253 88 270 69 250 60 228 58 191 67 154 77 128 90 116
Polygon -6459832 true false 138 105 119 116 99 142 89 167 89 193 89 219 94 244 105 261 114 268 96 241 93 209 94 186 94 170 101 147 116 126 126 115
Polygon -6459832 true false 147 107 162 127 170 149 175 170 174 206 162 245 144 271 165 247 178 208 179 165 167 127 156 115
Polygon -6459832 true false 185 107 206 126 225 175 225 211 209 253 189 271 205 253 222 208 221 174 205 132
Polygon -6459832 true false 201 104 231 127 247 155 256 179 257 210 244 239 229 258 244 234 255 207 253 177 236 142 220 122
Polygon -10899396 true false 98 106 110 100 122 100 129 95 132 81 132 74 128 65 122 59 128 54 139 51 156 49 150 59 150 66 152 77 151 84 150 89 150 92 164 95 175 95 184 99 189 103 176 108 160 103 145 104 139 107 126 105 119 104 110 107

pumpkin-face
true
0
Polygon -16777216 true false 90 108 71 115 53 138 35 176 33 217 45 245 67 265 91 276 112 273 133 278 157 275 185 278 206 272 231 267 242 259 260 243 272 214 268 173 244 131 224 110 201 104 184 107 165 102 145 107 126 104 109 110
Polygon -7500403 true true 87 104 68 111 50 134 32 172 30 213 42 241 64 261 88 272 109 269 130 274 154 271 182 274 203 268 228 263 239 255 257 239 269 210 265 169 241 127 221 106 198 100 181 103 162 98 142 103 123 100 106 106
Polygon -6459832 true false 106 108 83 128 68 172 63 199 67 236 77 253 88 270 69 250 60 228 58 191 67 154 77 128 90 116
Polygon -6459832 true false 138 105 119 116 99 142 89 167 89 193 89 219 94 244 105 261 114 268 96 241 93 209 94 186 94 170 101 147 116 126 126 115
Polygon -6459832 true false 147 107 162 127 170 149 175 170 174 206 162 245 144 271 165 247 178 208 179 165 167 127 156 115
Polygon -6459832 true false 185 107 206 126 225 175 225 211 209 253 189 271 205 253 222 208 221 174 205 132
Polygon -6459832 true false 201 104 231 127 247 155 256 179 257 210 244 239 229 258 244 234 255 207 253 177 236 142 220 122
Polygon -10899396 true false 98 106 110 100 122 100 129 95 132 81 132 74 128 65 122 59 128 54 139 51 156 49 150 59 150 66 152 77 151 84 150 89 150 92 164 95 175 95 184 99 189 103 176 108 160 103 145 104 139 107 126 105 119 104 110 107
Circle -16777216 true false 90 60 0
Polygon -16777216 true false 195 150 210 180 180 180 195 150
Polygon -16777216 true false 105 150 90 180 120 180 105 150
Polygon -16777216 true false 105 210 195 210 180 240 120 240 105 210
Polygon -955883 true false 162 210 170 225 178 210
Polygon -955883 true false 142 240 150 225 158 240
Polygon -955883 true false 138 210 130 225 122 210

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
