globals [ dI dZ Kd KB i rbound ]
patches-own [ x y ]
turtles-own [age bound partner]
breed [ rna ]
breed [ inducer ]
breed [ repressor ]
breed [ beta ]


to setup
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
; setup variables
set rbound false ; set the bound state of the operon to false
set dI 10 ; rate of repressor
set dZ 15 ; rate of beta-galactosidase
set Kd 4 ; dissociation coefficient
set KB 100 ; binding coefficient
; create a few repressor molecules to shut lacZ off fast
if ( lacI-gene = true ) [
crt 5 [
        set breed repressor
        set shape "repressor"
        set color red
        set partner nobody
        set age random 25
        set heading random 360
        fd random 50
      ]]

      ; create binding sites  
      ; red - lacI
      ask patches with [(pxcor = -10) and (pycor = 0)] [ set pcolor red set plabel "I" ]
      ; create "gene"
      ask patches with [(pxcor > -10) and (pxcor <= 0) and (pycor = 0)] [ set pcolor white ]

      ; blue - lacZ
      ask patches with [(pxcor = 1) and (pycor = 0)] [ set pcolor blue set plabel "Z" ]
      ; create "gene"
      ask patches with [(pxcor > 1) and (pxcor <= 16) and (pycor = 0)] [ set pcolor white ]
      
      ; create ribosomes
      ask patches with [ ((pxcor < -12) or (pxcor > 13)) or ((pycor < -3) or (pycor > 5))] [ if random 10 = 1 [set pcolor cyan] ]
  plot-history
  plot-levels               
end


to go 
; add inducers
if (add-inducer = true) [
  crt inducers-to-add [
  set breed inducer
    set shape "inducer" 
    set partner nobody
    set color black ;;so people don't see what's happening
    set heading 320 
    fd 10 ;; this just moves them up to near gene 1 before they start to diffuse
    set heading random 360 ;; this sets them up to diffuse in all directions
    fd random 5 ;; this makes them not all appear at the same point, or in an obvious circle
    set color green]] ;; this make them visible

; do gene transcription
  ask patches [
    if (plabel = "I")[
     if (lacI-gene = true and random 100 < dI ) [
       sprout 1 [
        set breed rna
        set shape "rna"
        set color red
        set partner nobody
        set age random 30
        set heading random 360
        fd 2
      ]
    ]
  ]
  if (plabel = "Z" and rbound = false) [
    if lacZ-gene = true and random 100 < dZ [
      sprout 1 [
        set breed rna
        set partner nobody
        set shape "rna"
        set color blue
        set bound false
        set age random 30
        set heading random 360
        fd 2
      ]
    ]
  ]
]
; this was a bit tricky to get the order of events right
ask repressor [
    without-interruption [bind-site]
    form-complex]
ask turtles 
    [wander ;; both rnas and proteins check to see if they bind and otherwise move around
     grow-old] ;; both also are recycled by the cell machinery after a while.
ask repressor [dissociate]
ask beta [eat-inducer cleave]
plot-history
plot-levels
 end
 
; bind repressor to lacZ operon
to bind-site
  if (rbound = false and partner = nobody)
  [if (random 100 < Kb and breed = repressor) [
    set bound true 
    set rbound true 
    setxy 1 0  
    set heading 180]]
end

; unbind repressor from lacZ operon
to unbind-site
  if ((random 100 < Kd) or (partner != nobody)) [
    set rbound false 
    set bound false  
    setxy random world-width random world-height
]
end

; have RNAs, proteins, and inducers move around the environment
to wander
  if (pcolor = cyan and shape = "rna") [  ;; this is the ribosome translating
     hatch 1 [
     set shape "repressor"
     ifelse (color = blue) [set breed beta set shape "repressor" ] [set breed repressor set shape "repressor" ]
     set bound false
     set age 0
     set heading random 360
   ]
] 
  ifelse (bound = true) [without-interruption [unbind-site]] [rt random 90 - random 90 fd 1 ]
end

to grow-old ;; cells break down rnas and proteins after a while.  
   set age age + 1
   if (age > (40 + random 100))  [if not (bound = true or breed = inducer) [die]]
end


to plot-history ;; this creates the line graph
  set-current-plot "Betagalactosidase Levels"
    set-current-plot-pen "B"
  plot ( count turtles with [color = blue and shape = "repressor" ] + count turtles with [shape = "b-complex"]  )
end

to plot-levels ;; this creates creates the bar graph 
    set-current-plot "Protein and Complex Concentrations"
    clear-plot
    set-current-plot-pen "R"
    plot-pen-down
    plotxy 1 count turtles with [color = red and shape = "repressor"] 
    set-current-plot-pen "R+I"
    plot-pen-down
    plotxy 2 count turtles with [color = red and shape = "r-complex"] 
    set-current-plot-pen "B"
    plot-pen-down
    plotxy 3 count turtles with [color = blue and shape = "repressor"] 
    set-current-plot-pen "B+I"
    plot-pen-down
    plotxy 4 count turtles with [shape = "b-complex"] 
end

to form-complex  ; based on function from Enzyme Kinetics
  if partner != nobody [ stop ]
  set partner one-of (inducer with [partner = nobody])
  if partner = nobody [ stop ]
  if [partner] of partner != nobody [ set partner nobody stop ] ; in case two enzymes grab the same partner
  ifelse ((([breed] of partner) = inducer) and (random 50 < Kb))
    [ ask partner [set partner myself ]
      setshape
      ask partner [ setshape ] ]
    [ set partner nobody ]
end 

to eat-inducer  ; based on function from Enzyme Kinetics
  if partner != nobody [ stop ]
  set partner one-of (inducer with [partner = nobody])
  if partner = nobody [ stop ]
  if [partner] of partner != nobody [ set partner nobody stop ] ; in case two enzymes grab the same partner
  ifelse (random 100 < Kb)
    [ ask partner [set partner myself ]
      setshape
      ask partner [ setshape ] ]
    [ set partner nobody ]
end 

to cleave ; based on function from Enzyme Kinetics
if partner != nobody [
if random 3 < 1 [
ask partner [ die ] 
      set partner nobody
      setshape]]
end

;; enzyme procedure that controls the rate at which complexed turtles break apart
to dissociate ; based on function from Enzyme Kinetics
  let old-partner 0
   
  if partner != nobody
    [ if (random 100 < Kd)
      [ ask partner [set partner nobody ]
        set old-partner partner
        set partner nobody
        setshape
        ask old-partner [ setshape ] ] ]
end

to setshape ; based on function from Enzyme Kinetics
  ifelse breed = repressor
    [ set color red
      ifelse partner = nobody
        [ set shape "repressor" ]
        [ if ([breed] of (partner) = inducer)
            [ set shape "r-complex" ]
             ] ]
    [ ifelse breed = beta
    [ set color blue
      ifelse partner = nobody
        [ set shape "repressor" ]
        [ if ([breed] of (partner) = inducer)
            [ set shape "b-complex" ]
             ] ]
    [ if breed = inducer
        [ set color green
          set shape "inducer"
          set hidden? (partner != nobody) ]
 ] 
 ] 
end


; This model was created as part of the 2004 BioQUEST Curriculum Consortium
; Summer Workshop.  
;
; Copyright 2004 by Steven Brewer, Pat Ehrman, and Allen Koop.  All rights reserved.
; This model was inspired by many of the sample Netlogo models and parts 
; were based on functions from the Enzyme Kinetics model.  (Wilensky, U. (2001).  
; NetLogo Enzyme Kinetics model. http://ccl.northwestern.edu/netlogo/models/EnzymeKinetics. 
; Center for Connected Learning and Computer-Based Modeling, Northwestern University, 
; Evanston, IL.) 
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from the authors.
; Contact the authors for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Brewer, S.D., Ehrman, P., and Koop, A. (2004).  A Netlogo Model of lac operon 
; Gene Expression.  http://bcrc.bio.umass.edu/netlogo/models/GeneExpression
; Biology Computer Resource Center
;
; In other publications, please use:
; Copyright 2004 by Steven Brewer, Pat Ehrman, and Allen Koop.  All rights reserved.  See
; http://bcrc.bio.umass.edu/netlogo/models/GeneExpression
; for terms of use.
@#$#@#$#@
GRAPHICS-WINDOW
321
10
776
245
18
8
12.03
1
10
1
1
1
0
1
1
1
-18
18
-8
8
0
0
1
ticks
30.0

BUTTON
4
10
70
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
74
10
137
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
4
120
309
294
Betagalactosidase Levels
NIL
NIL
0.0
100.0
0.0
30.0
true
true
"" ""
PENS
"B" 1.0 0 -16776961 true "" ""

PLOT
5
299
310
449
Protein and Complex Concentrations
NIL
NIL
0.0
6.0
0.0
30.0
false
true
"" ""
PENS
"R" 1.0 1 -65536 true "" ""
"R+I" 1.0 1 -11352576 true "" ""
"B" 1.0 1 -16776961 true "" ""
"B+I" 1.0 1 -65281 true "" ""

BUTTON
5
452
125
485
NIL
clear-all-plots
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
174
47
312
92
inducers-to-add
inducers-to-add
1 2 3 4 5
0

SWITCH
174
10
312
43
add-inducer
add-inducer
1
1
-1000

SWITCH
4
46
159
79
lacI-gene
lacI-gene
0
1
-1000

SWITCH
4
84
160
117
lacZ-gene
lacZ-gene
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This is a model of the regulation of gene expression based on the lac operon: a bacterial gene that produces an enzyme that breaks down lactose, a complex sugar, into simpler sugars: glucose and galactose.  This gene is only transcribed when lactose is in the environment.  This system was one of the first models of gene expression described.

## HOW IT WORKS

In this system, there are two genes: the lacI gene produces a repressor molecule which in turn binds to the operon of the lacZ gene which codes for beta-galactosidase, an enzyme.  As long as the repressor is bound to the operon, the beta-galactosidase gene is turned off. 

When a gene is active, RNAs (represented by circles) are produced and diffuse to ribosomes  (represented by squares) where they are translated into proteins.  When an inducer is added the system, it binds to the repressor molecules and prevents them from binding to the lacZ operon.  This causes the lacZ gene to begin transcribing RNAs which are translated into beta-galactosidase.  The beta-galactosidase molecules bind to and cleave the inducer molecules.  When inducer molecules are no longer available, the repressor molecules bind to the operon again, shutting the system off.

This implementation of the model makes a variety of assumptions.  First, the model assumes that proteins are degraded by the cell over time.  The number of proteins at any one time are the result of a balance between new proteins being added and old ones being removed through degradation.  

In real systems, the coding region for lacZ is followed by lacY and lacA, which code for other proteins and are transcribed at the same time as lacZ.  These other proteins do not contribute directly to the regulatory control of lacZ and have not been included in the model for simplicity.

## HOW TO USE IT

Click "setup" to create the genes and ribosomes.  

Click "go" to start the model.

Switches allow the user to add inducer and select the number of molecules to add per unit time.

Other switches allow turning off (or "knocking out") the lacI and lacZ genes.

Two plots: one showing the current concentration of beta-galactosidase and the other showing levels of repressor, beta-galactosidase, and their complexes with inducer molecules.

## THINGS TO NOTICE

There are a few repressor molecules when the model first turns on (as long as the lacI gene hasn't been turned off).  Note that very quickly after the model starts, one of the repressors has bound to the lacZ operon.

Every now and then, you'll see the lacZ gene produce RNA even when the repressors are available.  What hypotheses can you propose for why this might happen?

## THINGS TO TRY

Predict at which level you believe the lacZ gene will begin operating and then try adding various levels of inducer.  What differences do you notice between different levels?

Predict the behavior of the system when you turn off each of the genes and then test your predictions.

When the lacZ gene switches on, it produces a distinctive curve in the levels of concentration of beta-galactosidase.  What is happening at each stage of the curve?  What happens when the gene switches off.

## EXTENDING THE MODEL

To simplify this model, a number of factors have been de-paramaterized, including the rates of each gene (dI and dZ) and the coefficients of binding and dissociation (KB and Kd).  By adding sliders, you could extend this model and explore the behavior of the system with different values.

## CREDITS AND REFERENCES

This model was created as part of the 2004 BioQUEST Curriculum Consortium  
Summer Workshop.  

Copyright 2004 by Steven Brewer, Pat Ehrman, and Allen Koop.  All rights reserved.

This model was inspired by many of the sample Netlogo models and parts were based on functions from the Enzyme Kinetics model.  (Wilensky, U. (2001).  NetLogo Enzyme Kinetics model. http://ccl.northwestern.edu/netlogo/models/EnzymeKinetics. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.)    
Permission to use, modify or redistribute this model is hereby granted,  
provided that both of the following requirements are followed:  
a) this copyright notice is included.  
b) this model will not be redistributed for profit without permission
   from the authors.  
Contact the authors for appropriate licenses for redistribution for  
profit.

To refer to this model in academic publications, please use:  
Brewer, S.D. Ehrman, P., and Koop, A. (2004).  A Netlogo Model of lac operon Gene Expression.  http://bcrc.bio.umass.edu/netlogo/models/LacOperon  
Biology Computer Resource Center

In other publications, please use:  
Copyright 2004 by Steven Brewer, Pat Ehrman, and Allen Koop.  All rights reserved.  See  
http://bcrc.bio.umass.edu/netlogo/models/LacOperon  
for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

b-complex
true
0
Polygon -10899396 true false 79 46 198 148 78 254
Polygon -13345367 true false 77 48 197 149 77 255 257 254 256 49

box
true
0
Polygon -7500403 true true 45 255 255 255 255 45 45 45

circle
false
0
Circle -7500403 true true 35 35 230

inducer
true
0
Polygon -10899396 true false 76 47 197 151 75 256

r-complex
true
0
Polygon -2674135 true false 76 47 197 150 76 254 257 255 257 47
Polygon -10899396 true false 79 46 198 148 78 254

repressor
true
0
Polygon -7500403 true true 76 47 197 150 76 254 257 255 257 47

rna
true
0
Rectangle -7500403 true true 7 126 294 170

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
