globals [carbon] ;; keeps track of how much pollution there is

breed [polluters polluter]
breed [nonpolluters nonpolluter]

turtles-own [
  old-attitude
  new-attitude
  ]

to setup
  clear-all
  set-default-shape turtles "circle" ;; the way "set" commands work: the first argument is the object that will be turned into (or given the property of) whatever the second argument is
  ask patches [;; every patch will either have a polluter or a nonpolluter placed on them. The probability of one over the other is set by the ratio
    ifelse random-float 100 < polluter-to-nonpolluter-ratio [
      sprout-polluters 1 [ ;; "sprout-<breed>" just means that an agent of type <breed> is created 
        set color red - 2
        set new-attitude (random init-pol-attitude + 1)] ;; the initial attitude is set to be between (inclusive) 1 and the ini-pol-attitude
    ]
    [
      sprout-nonpolluters 1 [ ;; this works the same as above, except for nonpolluters now
       set color yellow - 2
       set new-attitude (random init-npol-attitude + 1)
      ]
    ]
  ]
  ask turtles [ set old-attitude new-attitude ] ;; in order to do synchronous updating, we need to delay when agents update their attitudes, so we separate attitudes into new and old
  set carbon initial-pollution-level
  reset-ticks
end

to go
  if carbon > (delay-armageddon * armageddon) [ stop ] ;; sometimes we want to see whether carbon could have been pulled back after the armageddon value is reach. We can introduce this by delaying when the simulation stops.
  ask polluters [
    if random-float 100 < prob-local-com [;;every polluter has some probablity of communicating with their local (8) neighbors
      let npol-list nonpolluters-on neighbors
      let pol-list polluters-on neighbors
      ifelse random-float 100 < (100 * ((carbon-sensitivity * carbon) / armageddon)) [ ;; the higher carbon is, the more likely polluters listen to nonpolluters
        if count turtle-set npol-list with [old-attitude > npol-behave-thresh] > pol-neighbor-stubbornness [ ;;number of nonpolluters behaving greater than polluter's stubbornness?
          set new-attitude new-attitude - 1
        ]
      ][
        if count turtle-set pol-list with [old-attitude > pol-behave-thresh] > pol-echochamber-thresh [
          entrench-pol-attitude ;; the code for this command is towards the end. It basically entrenches an attitude as long as it hasn't reach the maximum allowed level
        ]
      ]
    ]
  ]
  ask nonpolluters [ ;; this code should be the same as above, but with relevant changes for nonpolluters.
    if random-float 100 < prob-local-com [
      let pol-list polluters-on neighbors
      let npol-list nonpolluters-on neighbors
      ifelse random-float 100 < (100 * ((carbon-sensitivity * carbon) / armageddon))[ ;; the higher carbon is, the less likely nonpolluters listen to polluters
        if count turtle-set npol-list with [old-attitude > npol-behave-thresh] > npol-echochamber-thresh [
          entrench-npol-attitude
        ] 
      ][
        if count turtle-set pol-list with [old-attitude > pol-behave-thresh] > npol-neighbor-stubbornness [;; number of polluters behaving greater than nonpolluter's stubbornnes?
          set new-attitude new-attitude - 1
        ]
      ]
    ]
  ]
  ask turtles [
    if random-float 100 < prob-non-local-com [;; every agent (or "turtle") has a probability of communicating non-locally
      let tlist []
      while [count turtle-set tlist < 8] [;;after a turtle has been selected, a random set of 8 other turtles are picked
        set tlist fput one-of turtles tlist ;; pick a random turtle until you have a list containing n turtles
      ] 
      let nlist turtle-set tlist ;; turns the list of turtles into an agent set (this tells netlogo to treat the objects in the list as agents)
      if is-polluter? self [;; if the "center" agent that's about to interact with the 8 non-local "neighbors" is a polluter, then ...
        ifelse random-float 100 < (100 * ((carbon-sensitivity * carbon) / armageddon))[
          if count turtle-set nlist with [old-attitude > npol-behave-thresh and breed = nonpolluters] > pol-neighbor-stubbornness [
            set new-attitude new-attitude - 1
          ]
        ];;if the "center" agent isn't a polluter, then they have to be a nonpolluter, that's why the "ifelse" command was used
        [ 
          if count turtle-set nlist with [old-attitude > pol-behave-thresh and breed = polluters] > pol-echochamber-thresh [
            entrench-pol-attitude
          ]
        ] 
      ]
      if is-nonpolluter? self [
        ifelse random-float 100 < (100 * ( (carbon-sensitivity * carbon) / armageddon))[
          if count turtle-set nlist with [old-attitude > npol-behave-thresh and breed = nonpolluters] > npol-echochamber-thresh [
            entrench-npol-attitude
          ]
        ]
        [ 
          if count turtle-set nlist with [old-attitude > pol-behave-thresh and breed = polluters] > npol-neighbor-stubbornness [
            set new-attitude new-attitude - 1
          ]
        ]
      ]
    ]
  ]
  ask polluters with [new-attitude <= 0] [ ;; this turns polluters with a new-attitude of 0 into a nonpolluter with an attitude of 1
    set breed nonpolluters
    set color yellow - 2
    set new-attitude 1
  ]
  ask nonpolluters with [new-attitude <= 0] [ ;; this turns nonpolluters with a new-attitude of 0 into a polluter with an attitude of 1
   set breed polluters
   set color red - 2
   set new-attitude 1
    
  ]
  ask turtles [ 
    set old-attitude new-attitude ;; all the agents now synchronically update
    if is-polluter? self [ ;; for those polluters with an attitude at or above the behaviour threshold, they become "bright", else they are "dimmed"
      ifelse old-attitude >= pol-behave-thresh [ set color red] [set color red - 2]
    ]
    if is-nonpolluter? self [
      ifelse old-attitude >= npol-behave-thresh [ set color yellow] [set color yellow - 2]
    ]
   ]
  calculate-carbon ;;the code for updating carbon is below
  tick ;; this keeps track of how much time has gone by. It adds a "tick" once we reach the code here. It effectively counts every synchronis update
end



to entrench-pol-attitude
  if new-attitude < pol-max-entrench [ set new-attitude new-attitude + 1 ]
end

to entrench-npol-attitude
  if new-attitude < npol-max-entrench [ set new-attitude new-attitude + 1 ]
end

to calculate-carbon
  ask turtles [ ;;carbon is updated by adding to past carbon the amount that each agent contributes to carbon. Note that some nonpolluters can still contribute carbon if the max-carbon-offset parameter is lower than max-carbon-contribution
    let x [new-attitude] of self
    if is-nonpolluter? self [ set x (0 - x) ]
    let y ((((max-carbon-contribution - max-carbon-offset) / (pol-max-entrench + npol-max-entrench)) * (x + npol-max-entrench)) + max-carbon-offset )
    set carbon carbon + y
  ]
  if carbon <= 0 [ set carbon 0 ]
end












@#$#@#$#@
GRAPHICS-WINDOW
413
10
775
393
16
16
10.67
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
311
164
377
197
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
312
221
375
254
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
23
67
207
100
initial-pollution-level
initial-pollution-level
0
10000
5500
10
1
NIL
HORIZONTAL

PLOT
19
403
777
662
Pollution
time
carbon
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot carbon"

SLIDER
23
112
195
145
armageddon
armageddon
0
1000000
200000
500
1
NIL
HORIZONTAL

SLIDER
22
20
258
53
polluter-to-nonpolluter-ratio
polluter-to-nonpolluter-ratio
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
826
41
998
74
init-pol-attitude
init-pol-attitude
0
10
3
1
1
NIL
HORIZONTAL

SLIDER
825
88
997
121
init-npol-attitude
init-npol-attitude
0
10
3
1
1
NIL
HORIZONTAL

SLIDER
821
228
1042
261
pol-neighbor-stubbornness
pol-neighbor-stubbornness
0
8
2
1
1
NIL
HORIZONTAL

SLIDER
823
276
1044
309
npol-neighbor-stubbornness
npol-neighbor-stubbornness
0
8
2
1
1
NIL
HORIZONTAL

SLIDER
824
134
996
167
pol-max-entrench
pol-max-entrench
0
10
6
1
1
NIL
HORIZONTAL

SLIDER
823
182
995
215
npol-max-entrench
npol-max-entrench
0
10
6
1
1
NIL
HORIZONTAL

SLIDER
825
324
997
357
pol-behave-thresh
pol-behave-thresh
0
pol-max-entrench
2
1
1
NIL
HORIZONTAL

SLIDER
826
372
998
405
npol-behave-thresh
npol-behave-thresh
0
npol-max-entrench
2
1
1
NIL
HORIZONTAL

SLIDER
826
426
1037
459
pol-echochamber-thresh
pol-echochamber-thresh
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
825
476
1036
509
npol-echochamber-thresh
npol-echochamber-thresh
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
20
298
204
331
prob-non-local-com
prob-non-local-com
0
100
15
1
1
NIL
HORIZONTAL

SLIDER
21
348
193
381
prob-local-com
prob-local-com
0
100
85
1
1
NIL
HORIZONTAL

SLIDER
20
209
235
242
max-carbon-contribution
max-carbon-contribution
0
20
6
1
1
NIL
HORIZONTAL

SLIDER
18
253
229
286
max-carbon-offset
max-carbon-offset
-10
0
-3
1
1
NIL
HORIZONTAL

SLIDER
229
352
401
385
carbon-sensitivity
carbon-sensitivity
.25
10
9.5
.25
1
NIL
HORIZONTAL

SLIDER
24
162
196
195
delay-armageddon
delay-armageddon
1
10
4
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -7500403 true true 135 285 195 285 270 90 30 90 105 285
Polygon -7500403 true true 270 90 225 15 180 90
Polygon -7500403 true true 30 90 75 15 120 90
Circle -1 true false 183 138 24
Circle -1 true false 93 138 24

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
