breed [ humans human ]
breed [ humans2 human2]
breed [ plants plant ]
breed [ insects insect]
breed [ cows cow]
breed [ tigers tiger ]
humans-own [energy birth-energy]
cows-own [energy birth-energy]
humans2-own [energy birth-energy]
insects-own [energy birth-energy]
tigers-own [energy birth-energy]

to setup
  clear-all
  setup-environment
  setup-turtles 
  reset-ticks
end

to setup-environment
  ask patches [set pcolor 65]
end

to setup-turtles
  ask n-of initial-humans patches with [pcolor = 65] 
 [  sprout-humans initial-humans
    [ 
      set breed humans
      set color 32
      set shape "person"
      set size 3]
   ]
  ask n-of green-settlers patches with [pcolor = 65]
  [  sprout-humans2 green-settlers
    [
      set breed humans2
      set color 94
      set shape "person"
      set size 3]
  ]
  ask n-of initial-plants patches with [pcolor = 65]
  [  sprout-plants initial-plants
    [
      set breed plants
      set color 52
      set shape "plant"
      set size 2]
  ]
  ask n-of initial-insects patches with [pcolor = 65]
  [  sprout-insects initial-insects
    [
      set breed insects
      set color 125
      set shape "bug"
      set size 2]
  ]
  ask n-of initial-cows patches with [pcolor = 65]
  [  sprout-cows initial-cows
    [
      set breed cows
      set color 5
      set shape "cow"
      set size 2]
    ]
  ask n-of initial-tigers patches with [pcolor = 65]
  [ sprout-tigers initial-tigers
    [
      set breed tigers
      set color 43
      set shape "cat"
      set size 2]
  ]
end

to go
  tick
  move-humans
  reproduce-humans
  move-cows
  reproduce-cows
  reproduce-plants
  move-humans2
  reproduce-humans2
  move-insects
  reproduce-insects
  move-tigers
  reproduce-tigers
  reproduce-plants
  move-plants
end

to move-plants
    ask plants[ if random 360 < .5 [
    ask one-of plants in-radius 1 [die]
    ]
  ]
end

to move-humans
  ask humans 
  [
   set heading random 360
   fd 1
   set energy (energy - 0.5)
   
   if any? plants in-radius 1 [
     ask one-of plants in-radius 1 [die]
     set energy (energy + 5)]

   if any? cows in-radius 1 [ 
    ask one-of cows in-radius 1 [die]
    set energy (energy + 10)]
   
   if any? tigers in-radius 3 [
     ask one-of tigers in-radius 3 [die]
     set energy (energy + 10)]
   
   if energy <= 1 [die]
  ]
end

to move-humans2
  ask humans2
  [
    set heading random 360
    fd 1
    set energy (energy - 0.05)
    
    if any? plants in-radius 1 [
      ask one-of plants in-radius 1 [die]
      set energy (energy + 5)]
    
    if any? cows in-radius 1 [
      ask one-of cows in-radius 1 [die]
      set energy (energy + 10)]
    
    if any? tigers in-radius 3 [
     ask one-of tigers in-radius 3 [die]
     set energy (energy + 10)]
    
    if any? plants in-radius 1 [
      ask one-of plants in-radius 1 [hatch 2 fd 2]
      ]
    
    if energy <= 1 [die]
  
  ]
end

to move-cows
  ask cows
  [
    set heading random 360
    fd 1
    set energy (energy - 2)
    
    if any? plants in-radius 1 [
      ask one-of plants in-radius 1 [die]
      set energy (energy + 5)]
    
    if any? insects in-radius 5 [
      ask one-of insects in-radius 5 [die]
      set energy (energy + 10)]
    
    if energy <= 1 [die]
  ]
end

to move-insects
  ask insects
  [
    set heading random 360
    fd 3
    set energy (energy - 1)
    
    if any? plants in-radius 5 [
      ask one-of plants in-radius 5 [die]
      set energy (energy + 5)]
    
    if energy <= 1 [die]
  ]
end

to move-tigers
  ask tigers
  [
    set heading random 360
    fd 2
    set energy (energy - 1)
    
    if any? cows in-radius 5 [
      ask one-of cows in-radius 5 [die]
      set energy (energy + 15)]
    
    if energy <= 1 [die]
  ]
end
     

to reproduce-humans
  ask humans [
    set birth-energy energy / 4
    if energy > 200 [
      set energy energy / 4 
      hatch 1 [set energy birth-energy ]
    ]
  ]
end

to reproduce-humans2
  ask humans2 [
    set birth-energy energy / 4
    if energy > 100 [
      set energy energy / 4 
      hatch 1 [set energy birth-energy ]
     ]
  ]
end

to reproduce-cows
  ask cows [
   set birth-energy energy / 2
    if energy > 100 [
      set energy energy / 2 
      hatch 1 
    ]
  ]
end

to reproduce-insects
  ask insects [
    set birth-energy energy / 2
    if energy > 50 [
      set energy energy / 2
      hatch 1 
    ]
  ]
end

to reproduce-tigers
  ask tigers [
    set birth-energy energy / 2
    if energy > 100 [
      set energy energy / 2
      hatch 1 
    ]
  ]
end

to reproduce-plants
  ask plants[ if random 360 < 1 [
    ask one-of plants in-radius 1 [hatch 1 fd 4 ]
    ]
  ]
  end
    

to add-ten-humans
create-humans 10 
[ set energy random 20 
  set shape "person" set size 2 
  set color 32
  setxy random-xcor random-ycor] 
end 
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
26
51
92
84
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
132
51
195
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
25
107
197
140
initial-humans
initial-humans
0
15
0
1
1
NIL
HORIZONTAL

SLIDER
25
160
197
193
Initial-Plants
Initial-Plants
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
26
215
198
248
initial-cows
initial-cows
0
100
61
1
1
NIL
HORIZONTAL

SLIDER
26
270
198
303
initial-insects
initial-insects
0
100
5
1
1
NIL
HORIZONTAL

SLIDER
26
336
198
369
initial-tigers
initial-tigers
0
100
5
1
1
NIL
HORIZONTAL

BUTTON
658
10
796
43
add-ten-humans
add-ten-humans
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
27
393
199
426
green-settlers
green-settlers
0
15
5
1
1
NIL
HORIZONTAL

MONITOR
660
53
723
98
humans
count humans
17
1
11

MONITOR
667
288
724
333
plants
count plants
17
1
11

MONITOR
664
108
721
153
cows
count cows
17
1
11

MONITOR
665
227
722
272
insects
count insects
17
1
11

MONITOR
663
167
722
212
tigers
count tigers
17
1
11

MONITOR
749
53
847
98
green settlers
count humans2
17
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

cat
false
0
Line -7500403 true 285 240 210 240
Line -7500403 true 195 300 165 255
Line -7500403 true 15 240 90 240
Line -7500403 true 285 285 195 240
Line -7500403 true 105 300 135 255
Line -16777216 false 150 270 150 285
Line -16777216 false 15 75 15 120
Polygon -7500403 true true 300 15 285 30 255 30 225 75 195 60 255 15
Polygon -7500403 true true 285 135 210 135 180 150 180 45 285 90
Polygon -7500403 true true 120 45 120 210 180 210 180 45
Polygon -7500403 true true 180 195 165 300 240 285 255 225 285 195
Polygon -7500403 true true 180 225 195 285 165 300 150 300 150 255 165 225
Polygon -7500403 true true 195 195 195 165 225 150 255 135 285 135 285 195
Polygon -7500403 true true 15 135 90 135 120 150 120 45 15 90
Polygon -7500403 true true 120 195 135 300 60 285 45 225 15 195
Polygon -7500403 true true 120 225 105 285 135 300 150 300 150 255 135 225
Polygon -7500403 true true 105 195 105 165 75 150 45 135 15 135 15 195
Polygon -7500403 true true 285 120 270 90 285 15 300 15
Line -7500403 true 15 285 105 240
Polygon -7500403 true true 15 120 30 90 15 15 0 15
Polygon -7500403 true true 0 15 15 30 45 30 75 75 105 60 45 15
Line -16777216 false 164 262 209 262
Line -16777216 false 223 231 208 261
Line -16777216 false 136 262 91 262
Line -16777216 false 77 231 92 261

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
