extensions [bitmap]        ; allows for import of png map (later in code - during setup)

globals 
     [habitats]
                           ; some globals seen in other models - seemed applicable, these 
                          ; represent things that all agents interact with so apply to all in model
breed [bats bat]
breed [peoples people]
breed [specialists specialist]
breed [caves cave]        ; names the different agentsets in the model
breed [lands land]


bats-own
  [age 
  days
  eat-bugs
  fly-around
  check-death
  bat-energy
  hibernate         ; defines specific bat behavior attributes
  max-lifespan
  gets-sick
  average-offspring
  ]
  
peoples-own 
   [visit-caves
   carries-disease 
]
                            ; some of visitors will carry disease into cave
patches-own 
    [habitat-cave         ; differentiates between area that is cave,
    caves-with-disease         ;; whether cave has G. destructans growing
    habitat-land          ; and whether area is open land for bats to fly around
]

specialists-own
   [inspect-caves
   find-cave-has-disease
   ]                                          ; defines what wildlife specialists do
                                              ; label caves that have WNS (color is white, 9.9)  

to setup                                           
  __clear-all-and-reset-ticks             ; (for this model to work with NetLogo's new plotting features
  
  import-pcolors-rgb "Bat-caves.png"      ; the map used that shows W.Va and Va.cave areas in karst topo
  create-bats number-bats [
  setup-habitats
  setup-agents
  ]
  do-plots
end

to setup-habitats
  ask patches [
         if pcolor > 1 and pcolor < 6 [
           set pcolor 47
           set habitats habitat-cave
         ]
         if pcolor > 31 and pcolor < 38 [
           set pcolor 47
           set habitats habitat-cave
         ]
         if pcolor > 51 and pcolor < 68 [          ; this section of the code changes the perception of the
           set pcolor 47                                       ; bitmap for agents so that some areas (near kartst, where there a                                      ; be green for bat habitat in which they fly, eat and then hiberna                           ; (and in some cases get sick) in the caves
           set habitats habitat-cave
           ]
  ask patches [ 
           if pcolor > 47 and pcolor < 47 [
            set pcolor 67 
            set habitats habitat-land
  ]]]
end  

to setup-agents 
  ask bats [set shape "bats"
           set size .5 
           set color 35]
  
  ask specialists [set shape "person"
                  set size 2 
                  set color green
             set inspect-caves 12] 
                                                ; distinguishes shapes sizes and colors 
  ask peoples [set shape "person"
              set size 2 
              set color black]                  ; of 3 diff. agents: bats, people & specialists         
end



to setup-bats
  ask patches[
    hatch n-of 100 [number-bats]
      set bat-energy random 30 
      set age random 25               ; starts bats with shape, energy, color and lifespan of 25 max
      show count gets-sick                  ; average offspring is set to 5 (in nature is 5 or 6)
      set max-lifespan 25
      set average-offspring 5
      if bat-energy = 0 [die]
  ]
end
      
to go 
      move-bats  
     if not any? bats [stop]
     if count bats > 1200 [stop]           ; these are the basics to start up the model with moving bats
      set hibernate ticks                   ; people and wildlife specialists, but to first check that
      move-people                           ; there are in fact bats, (when there are none model will stop or if
                                            ; there are so many, like  1200                           
      set carries-disease random 3         ; this only allows for up to 3 people to carry the disease to caves
      inspect habitat-cave                                ; for this size model
      do-plots
      tick
end
 
 
to move-bats  
    ask bats [set age age + 1]
    if age > 25 [die]
      if average-offspring < 5 [                  ; the most challenging part of the code was to get
        hatch 1]                                  ; bats to move, eat, gain and lose energy, hibernate
      set bat-energy bat-energy - 25              ; graze, reproduce and get sick if in contact with
      ask bats [                                  ; cave patches carrying G. destructans
        set bat-energy bat-energy + 25
   ]                                               ; to identify their two parts of habitat (caves and land)
   ask bats [
     set hibernate habitat-cave
     let c one-of (habitat-cave in-radius 1)
      move-to habitat-cave
      if days = 75 [ 
         move-to habitat-cave 
         set hibernate habitat-cave = 25 
         set bat-energy bat-energy - 10
      if patch-here ? pcolor white 
           set gets-sick]
    [if (bats-on or if bat 0 bat 2 bat 9 gets-sick)
       self gets-sick] [
    set bat-energy bat-energy - 20
      ]]
     
  ]]]
end  
     
to move-people
  ask people [ 
    let p n-of 5 people                                   ; should move people (6 per year?) into caves randomly, 
    move-to visit-caves                                   ; and this would leave disease if person is a carrier
    let k min-one-of habitat-cave [distance myself]
    face k
    move-to k  fd 2 rt 30 fd 1 lt 30 fd 2 lt 180 fd 5]
    let d n-of 1 carries-disease
    if carries-disease [
      ask one-of patches [set pcolor white]             ; the cave patch turns white to show it has disease now
    ]
end
   
to check-for-disease
  ask specialist [
    let s n-of 3 specialist 
    move-to habitat-cave 
    let t min-one-of habitat-cave [distance myself]       ; specialists inspect and label the caves that have disease
    face t 
    move-to t [range-of-view 60 radius 2]
     fd 2 rt 30 fd 1 rt 30 fd 2 lt 45 fd 1 lt 60]
     if patch [self] pcolor white
        [set cave-with-disease
          add count + 1
]
end

to do-plots
    ; update plots with new values
  
  set-current-plot "Bat Population" 
  set-current-plot-pen "healthy/" 
  plot count bats                                ; plot Total number of bats
  set-current-plot-pen "sick bats"                ; plot number of bats sick
  plot count becomes-sick  
  set-current-plot "Human visits to caves"
  set-current-plot-pen "people visit caves"
  plot count visit-caves
         
end

to ruler    
                                                               ; set up the white ruler lines around the edge of the model window
                                                               ; to give an approximate linear scale to the 'map'
  ask patches with [pxcor = max-pxcor ][set pcolor 78]         ; a nice touch taken from Orangatango model
  ask patches with [pycor = max-pycor ][set pcolor 78]
  ask patches with [pxcor = min-pxcor ][set pcolor 78]
  ask patches with [pycor = min-pycor ][set pcolor 78]

    ask patches with [pxcor mod 10 = 0 and
                    pycor < (min-pycor + 2)]
    [ set pcolor black ]     
    ask patches with [pxcor mod 100 = 0 and
                    pycor < (min-pycor + 8)]
    [ set pcolor black ]     
    ask patches with [pxcor < (min-pxcor + 2) and
                    pycor mod 10 = 0]
    [ set pcolor black ]
    ask patches with [pxcor < (min-pxcor + 8) and
                    pycor mod 100 = 0]
    [ set pcolor black ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
701
470
18
16
13.0
1
10
1
1
1
0
1
1
1
-18
18
-16
16
1
1
1
ticks
30.0

BUTTON
15
10
82
43
setup
to setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
116
10
179
43
go
to go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
13
50
185
83
number-bats
number-bats
10
100
85
5
1
NIL
HORIZONTAL

SLIDER
5
91
194
124
cave-visits
cave-visits
0
10
5
1
1
NIL
HORIZONTAL

PLOT
726
36
956
218
Bat Population
years
healthy/ sick bats
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"healthy bats" 1.0 0 -12440034 true "" ""
"sick bats" 1.0 0 -5298144 true "" ""

PLOT
727
229
960
413
Human Visits to caves
per year
number of visits
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"people-visit-cave" 1.0 0 -16777216 true "" ""

MONITOR
12
242
134
287
bat deaths
count n-of bats death
1
1
11

MONITOR
13
188
136
233
bats sick                
count bats gets-sick
1
1
11

MONITOR
13
136
133
181
sick caves             
count patches with [pcolor = white]
2
1
11

@#$#@#$#@
## WHAT IS IT?

This model is a simple look at the spread of "White Nose Bat Syndrome" which is a result of a microbial, newly discovered fungus that grows on the muzzles, ears and skin of bats during their hibernation, in colder temperatures, in the U.S.  It is not known how this was first brought to the U.S. but is thought to be from tourists who visit the caves.  The microbe is found in parts of Europe but does not harm bats there.  In the US since 2006 it has killed 7 million bats, and is now found in 22 States.

## HOW IT WORKS

The model begins with a set, and rather small amount of bats who are in a range within Va. and W. Va. based on maps that were imported from USGS website.  The smaller population allows the user to see the result of visitors to the cave who carry the disease.  The model user may change the bat population and observe the monitors and plots along the way.

## HOW TO USE IT

Before hitting the set-up button, consider the bat population in size.  It can start out small, in increments of 10 and go up to 100.  Because bats only reproduce 5 - 6 pups in their lifetime and only once per year, this was pre-set into the model and cannot be changed.

## THINGS TO NOTICE

It might be interesting to notice the number of visits to caves and how this affects the changes in sick and healthy bat populations.  Both are plotted and monitored with a number count.  One can also change the number of visits within a small range and see what affect this has on the spread of this disease.  It should be noted that not all visitors carry the microbial organism into a cave on clothing or equipment - this is set randomly to a low number of visits such as 2 or 3 per year.

## THINGS TO TRY

The only adjustable monitors are the number of bats that we start with as well as the number of cave visits by people that could carry the disease into the caves.

## EXTENDING THE MODEL

One idea of something to change or add to extend this model, as it has been found in research to be a crucial component of this agentset, is the introduce the variable of temperature.  It has been found that colonies of the microbe grow larger in the temperatures closer to the top range of 4 - 15 degrees C.  These are normal ranges for hibernating bats.   The illness strikes them while hibernating, and tends to disturb their sleep, which causes bats to deplete their stored energy and die.  In addition, awake bats disturb their sleeping neighbors, which in turn awakens them - this would be another complex but interesting variable to add to this model.


## NETLOGO FEATURES

This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

## RELATED MODELS

Helpful models were found in the Biology section of the Models Library, such as Sheep and Wolves, Ants, as well as a few in the Code examples section of the Library, such as Virus and Cone-vision which helped with movement when looking for something, as well as the idea of an illness spreading (Influenza for example).

## CREDITS AND REFERENCES

Of course Netlogos many online references were very helpful, and especially the work of Uri Wilensky on so many complex models.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bat
true
3
Polygon -6459832 true true 171 46 150 39 138 45 136 38 132 50 142 57 144 62 112 63 112 70 96 79 79 80 69 82 60 85 33 114 22 147 30 146 27 165 48 147 53 163 78 134 95 150 112 134 129 147 139 149 144 172 154 165 167 174 163 149 167 130 177 121 182 109 205 119 214 98 251 109 248 88 274 87 261 74 272 72 238 47 196 61 175 64 171 66 167 60 173 39 167 44 167 45

bats
true
3
Polygon -6459832 true true 171 46 150 39 138 45 136 38 132 50 142 57 144 62 112 63 112 70 96 79 79 80 69 82 60 85 33 114 22 147 30 146 27 165 48 147 53 163 78 134 95 150 112 134 129 147 139 149 144 172 154 165 167 174 163 149 167 130 177 121 182 109 205 119 214 98 251 109 248 88 274 87 261 74 272 72 238 47 196 61 175 64 171 66 167 60 173 39 167 44 167 45

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
