globals [ dead-house-list list-of-target-lists list-of-player-names number-of-players player-lineup step-list]    ;; global variable that tracks dead houses
                                                                                                                  ;; all players' target lists
                                                                                                                  ;; all player names corresponding to the target lists
                                                                                                                  ;; number of players total
                                                                                                                  ;; roster of player numbers in the current run
                                                                                                                  ;; list of the current step each turtle is on
breed [people person]
people-own [target points target-list player-name step]

breed [houses house]
houses-own [value-of-house]

to setup
  clear-all
  set dead-house-list []                                ;; initialize the variable as an empty list
  set step-list (n-values number-of-people [0])         ;; initialize as a list of zeros
  set number-of-houses 20                               ;; set the slider since this is hard-coded for 20 houses

  set-default-shape houses "house"
ifelse game-type = "Random"
   [ create-houses number-of-houses
  ]
  ;; CREATE-ORDERED-<BREEDS> distributes the houses evenly
 [ create-ordered-houses number-of-houses
    [
    fd max-pxcor
    ]
  ]
  if game-type = "Random" [ ask houses [ setxy random-xcor random-ycor ] ]  ;;this starts houses at random coordinates
   let sorted-turtles sort turtles      ; sorted-turtles sort turtles =/
 foreach sorted-turtles [
   x -> ask x [                       ; x is the house ID
      let y (who - 1)
      set value-of-house y         ; set each house value to its ID plus once since IDs start at zero
set value-of-house value-of-house + 1  ; this gives house values 0-99
     if game-type = "Spiral"[
      let z who
      facexy 0 0                    ; Put the houses in a spiral configuration, with the distance from (0,0) corresponding to their relative value
      fd ((19 - who) * .75)
      ]
    ]
 ]


  create-people number-of-people [
    ;; setxy random-xcor random-ycor   ;;this would start everyone at random coordinates
    setxy 0 0 ;; start everyone in the center
    set target one-of houses
    set size 1.15
    set points 0 ;; these are the points that we're measuring
    set step 0 ;; steps synchronize the evaluation of which people are on a house at a given time
    face target
     ]

  ;; Player names here
  set list-of-player-names [ "Sweepy" "Lilac" "Zinnia" "Marigold" "Daffodil" "Mac" "Timmy" "7" "8" "9" "10" "11" "12" "13" "14" ] ;; can have more players available than are active on a given run
  set number-of-players length list-of-player-names

  ;; Turtle target lists are here
  set list-of-target-lists [

    [19 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0]  ; Player0
    [17 15 13 11 10 9 8 7 6 5 4 19 18 3 2 1 16 14 12 0]  ; Player1
    [18 15 19 17 16 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0]  ; Player2
    [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 0]  ; Player3
    [19 18 15 14 13 10 9 8 7 6 5 4 3 2 1 17 16 12 11 0]  ; Player4
    [10 11 9 12 8 13 7 14 6 15 7 16 6 17 7 18 8 19 9 0]  ; Player5
    [18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0 19]  ; Player6
    [8 7 6 5 4 3 2 1 0 19 9 10 11 12 13 14 15 16 17 18]  ; Player7
    [12 11 10 9 8 7 6 5 4 3 2 1 0 19 17 15 13 14 16 18]  ; Player8
    [19 18 10 9 8 7 6 5 4 3 2 1 0 17 16 15 14 13 12 11]  ; Player9
    [6 5 4 3 2 1 0 19 7 8 9 10 11 12 13 14 15 16 17 18]  ; Player10
    [11 1 11 11]; Player11
    [12 12 12 12]; Player12
    [18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0 19]; Player13
    [17 16 15 13 12 10 9 6 5 4 3 2 1 0 19]; Player14

 ]


  ;; Assign target lists
  ask turtle 20                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player1-Number list-of-target-lists
    set target house first target-list  ;; Set target
    face target
    set player-name item Player1-Number list-of-player-names
  ]

  if number-of-people > 1 [
  ask turtle 21                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player2-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player2-Number list-of-player-names
  ]
  ]

  if number-of-people > 2 [
    ask turtle 22                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player3-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player3-Number list-of-player-names
  ]
  ]

  if number-of-people > 3 [
      ask turtle 23                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player4-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player4-Number list-of-player-names
  ]
  ]

  if number-of-people > 4 [
      ask turtle 24                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player5-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player5-Number list-of-player-names
  ]
  ]

  if number-of-people > 5 [
  ask turtle 25                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player6-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player6-Number list-of-player-names
  ]
  ]

    if number-of-people > 6 [
  ask turtle 26                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player7-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player7-Number list-of-player-names
  ]
  ]

    if number-of-people > 7 [
  ask turtle 27                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player8-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player8-Number list-of-player-names
  ]
  ]

    if number-of-people > 8 [
  ask turtle 28                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player9-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player9-Number list-of-player-names
  ]
  ]

    if number-of-people > 9 [
  ask turtle 29                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player10-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player10-Number list-of-player-names
  ]
  ]

    if number-of-people > 10 [
  ask turtle 30                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player11-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player11-Number list-of-player-names
  ]
  ]

    if number-of-people > 11 [
  ask turtle 31                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player12-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player12-Number list-of-player-names
  ]
  ]

    if number-of-people > 12 [
  ask turtle 32                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player13-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player13-Number list-of-player-names
  ]
  ]

    if number-of-people > 13 [
  ask turtle 33                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player14-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player14-Number list-of-player-names
  ]
  ]

    if number-of-people > 14 [
  ask turtle 34                        ;; turtle number is hard coded for # houses setup
  [
    set target-list item Player15-Number list-of-target-lists
    set target house first target-list
    face target
    set player-name item Player15-Number list-of-player-names
  ]
  ]

  reset-ticks
end

to grab-cash ; people procedure
  ;if number-of-houses = 0 [ stop ]               ; stop the run when there are no more houses

  let prey one-of houses-here                   ; grab a random house
  if prey != nobody                             ; did we get one? if so,
  [
    let y [ value-of-house ] of prey            ; value-from has been deprecated in this version of Netlogo, so use 'of'
    set dead-house-list lput y dead-house-list  ; add the dead house value (which is also its ID) to the list
    ask prey [ die ]                            ; grab the house, and...
    set number-of-houses number-of-houses - 1   ; use this to set the stop condition, drives the slider down
    if not any? other turtles-here              ; only give points if there is not a tie - nobody gets points if there's a tie
        [ set points points + y ]               ; people get points value from grabbing the cash

  ]
end

to go
  if number-of-houses = 0 [ stop ]               ; stop the run when there are no more houses
 let step-size 1
    if fine-steps? [ set step-size 0.1 ]
  if game-type = "Moving" [ ask houses [ fd (house-speed * step-size) ] ]          ;; moving the houses
    ;; This is to stop BehaviorSpace runs that contain multiple iterations of the same player
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      if block-dupes? [
    set player-lineup (list Player1-Number Player2-Number Player3-Number Player4-Number Player5-Number Player6-Number Player7-Number Player8-Number Player9-Number Player10-Number Player11-Number Player12-Number Player13-Number Player14-Number Player15-Number)
    let deduped-player-lineup remove-duplicates player-lineup
    if length player-lineup != length deduped-player-lineup [
     ask people [
        set points -1
    ]
      stop ]
  ]


    display-values ;; show the value of each house next to the house

  ask people [

    display-labels ;; show the player names next to the arrows
   let cleaned-list filter [ x -> not member? x dead-house-list ] target-list     ;; update the target-list to remove any values on the dead-house-list
        set target-list cleaned-list
      if target-list = [] [ stop ]                 ; stop the run when the target list is empty
    if target = nobody ;; case where target not picked off already
      [ set target house first target-list             ;; set the target to the next one on the list
        ]
    face target

    set step (step + 1)
    let step-synch false
    set step-list (replace-item (who - 20) step-list step)    ;;;;;!!!!!


    ;; move towards target.  once the distance is less than 2 step-sizes,
    ;; use move-to to land exactly on the target.
    ifelse distance target < ( 2 * step-size)                        ;;Takes about an extra click to eat the house if this is set to 1 vs. 2
      [ move-to target ]                                             ;;because the fractional distance costs a whole click, but with fine movement increments of 0.1 this is irrelevant
      [ fd step-size ]
  ]

    ;; evaluate whether all turtles have moved and are now on the same step by checking if all the steps in the step-list are identical
    let step-synch false
    if (length remove-duplicates step-list) = 1 [
    set step-synch true
  ]

    ;; if at target, choose a new target
    ask people [
       let cleaned-list filter [ x -> not member? x dead-house-list ] target-list     ;; update the target-list to remove any values on the dead-house-list
        set target-list cleaned-list
     if target-list = [] [ stop ]                 ; stop the run when the target list is empty
    if target = nobody ;; case where target not picked off already
      [ set target house first target-list             ;; set the target to the next one on the list
        ]
    face target
    if ((distance target = 0) and (step-synch))
    [   grab-cash                                    ;; people grab the cash on their patch, based on Wolf Sheep Predation "eat-sheep"
      set cleaned-list filter [ x -> not member? x dead-house-list ] target-list     ;; update the target-list to remove any values on the dead-house-list
        set target-list cleaned-list                                                     ;;
        if target-list = [] [ stop ]                 ; stop the run when the target list is empty
        set target house first target-list
        face target
  ]
  ]

tick
  end

to display-values
      ask houses [ set label " " ]
  if show-values? [
      ask houses [ set label value-of-house  ]
  ]
end

to display-labels
      ask people [ set label " " ]
  if show-names? [
      ask people [ set label player-name ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
196
10
1029
844
-1
-1
25.0
1
13
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
5
108
90
141
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
90
108
175
141
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
5
38
175
71
number-of-people
number-of-people
1
15
6.0
1
1
NIL
HORIZONTAL

SLIDER
5
73
175
106
number-of-houses
number-of-houses
3
20
0.0
1
1
NIL
HORIZONTAL

SWITCH
39
288
173
321
show-names?
show-names?
0
1
-1000

MONITOR
1086
95
1143
140
Points
[ points ] of turtle 20
17
1
11

MONITOR
1086
142
1143
187
Points
[ points ] of turtle 21
17
1
11

MONITOR
1086
189
1143
234
Points
[ points ] of turtle 22
17
1
11

SLIDER
1149
102
1321
135
Player1-Number
Player1-Number
0
14
0.0
1
1
NIL
HORIZONTAL

SLIDER
1149
147
1321
180
Player2-Number
Player2-Number
0
14
1.0
1
1
NIL
HORIZONTAL

SLIDER
1149
197
1321
230
Player3-Number
Player3-Number
0
14
2.0
1
1
NIL
HORIZONTAL

MONITOR
1026
95
1083
140
Player1
item Player1-Number list-of-player-names
17
1
11

MONITOR
1026
142
1083
187
Player2
item Player2-Number list-of-player-names
17
1
11

MONITOR
1026
189
1083
234
Player3
item Player3-Number list-of-player-names
17
1
11

MONITOR
1086
236
1143
281
Points
[ points ] of turtle 23
17
1
11

MONITOR
1086
283
1143
328
Points
[ points ] of turtle 24
17
1
11

MONITOR
1086
330
1143
375
Points
[ points ] of turtle 25
17
1
11

SLIDER
1148
241
1320
274
Player4-Number
Player4-Number
0
14
3.0
1
1
NIL
HORIZONTAL

SLIDER
1148
289
1320
322
Player5-Number
Player5-Number
0
14
4.0
1
1
NIL
HORIZONTAL

SLIDER
1148
335
1320
368
Player6-Number
Player6-Number
0
14
5.0
1
1
NIL
HORIZONTAL

MONITOR
1026
236
1083
281
Player4
item Player4-Number list-of-player-names
17
1
11

MONITOR
1027
283
1084
328
Player5
item Player5-Number list-of-player-names
17
1
11

MONITOR
1027
330
1084
375
Player6
item Player6-Number list-of-player-names
17
1
11

SWITCH
38
327
172
360
fine-steps?
fine-steps?
0
1
-1000

SWITCH
37
366
171
399
block-dupes?
block-dupes?
1
1
-1000

SWITCH
38
248
173
281
show-values?
show-values?
0
1
-1000

CHOOSER
7
160
174
205
game-type
game-type
"Circle" "Spiral" "Random" "Moving"
0

SLIDER
7
461
173
494
house-speed
house-speed
0
.99
0.2
.01
1
NIL
HORIZONTAL

MONITOR
1028
377
1084
422
Player7
item Player7-Number list-of-player-names
17
1
11

SLIDER
1149
379
1321
412
Player7-Number
Player7-Number
0
14
6.0
1
1
NIL
HORIZONTAL

SLIDER
1148
430
1320
463
Player8-Number
Player8-Number
0
14
7.0
1
1
NIL
HORIZONTAL

SLIDER
1149
476
1321
509
Player9-Number
Player9-Number
0
14
8.0
1
1
NIL
HORIZONTAL

SLIDER
1150
522
1322
555
Player10-Number
Player10-Number
0
14
9.0
1
1
NIL
HORIZONTAL

SLIDER
1152
568
1324
601
Player11-Number
Player11-Number
0
14
10.0
1
1
NIL
HORIZONTAL

SLIDER
1153
615
1325
648
Player12-Number
Player12-Number
0
14
11.0
1
1
NIL
HORIZONTAL

SLIDER
1155
663
1327
696
Player13-Number
Player13-Number
0
14
12.0
1
1
NIL
HORIZONTAL

SLIDER
1156
708
1328
741
Player14-Number
Player14-Number
0
14
13.0
1
1
NIL
HORIZONTAL

SLIDER
1158
757
1330
790
Player15-Number
Player15-Number
0
14
14.0
1
1
NIL
HORIZONTAL

MONITOR
1028
424
1085
469
Player8
item Player8-Number list-of-player-names
17
1
11

MONITOR
1028
471
1085
516
Player9
item Player9-Number list-of-player-names
17
1
11

MONITOR
1027
517
1086
562
Player10
item Player10-Number list-of-player-names
17
1
11

MONITOR
1028
564
1086
609
Player11
item Player11-Number list-of-player-names
17
1
11

MONITOR
1027
611
1089
656
Player12
item Player12-Number list-of-player-names
17
1
11

MONITOR
1027
659
1089
704
Player13
item Player13-Number list-of-player-names
17
1
11

MONITOR
1027
707
1089
752
Player14
item Player14-Number list-of-player-names
17
1
11

MONITOR
1028
755
1089
800
Player15
item Player15-Number list-of-player-names
17
1
11

MONITOR
1087
377
1144
422
Points
[ points ] of turtle 26
17
1
11

MONITOR
1087
424
1144
469
Points
[ points ] of turtle 27
17
1
11

MONITOR
1087
471
1144
516
Points
[ points ] of turtle 28
17
1
11

MONITOR
1088
517
1145
562
Points
[ points ] of turtle 29
17
1
11

MONITOR
1089
565
1146
610
Points
[ points ] of turtle 30
17
1
11

MONITOR
1092
612
1149
657
Points
[ points ] of turtle 31
17
1
11

MONITOR
1093
659
1150
704
Points
[ points ] of turtle 32
17
1
11

MONITOR
1094
706
1151
751
Points
[ points ] of turtle 33
17
1
11

MONITOR
1095
755
1152
800
Points
[ points ] of turtle 34
17
1
11

@#$#@#$#@
## WHAT IS IT?

Cakewalk is a deterministic asynchronous multi-player game where the goal is to earn the most points.

## HOW TO PLAY

There are 20 houses numbered from 0 to 19, arranged in a pattern. Each house number corresponds to its point value, so house 19 is worth 19 points.

Players provide a list of values from 0 to 19 in the order they would like to target the houses.

When a person reaches their target house, they capture its points and the house is no longer in play.

BUT, when two people reach the same target house at the same time, no points are awarded to either player and the house is removed from play.

When a person reaches their target, or if their current target is captured they pick the next available target house from their target list and head towards that.

## NOTE

For the "Moving Houses" configuration to execute correctly, the horizontal and vertical world wraps must be checked in the Options menu.

<!-- 2024 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="RunAllPlayers" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="200"/>
    <metric>[ points ] of turtle 20</metric>
    <metric>[ points ] of turtle 21</metric>
    <metric>[ points ] of turtle 22</metric>
    <metric>[ points ] of turtle 23</metric>
    <metric>[ points ] of turtle 24</metric>
    <metric>[ points ] of turtle 25</metric>
    <enumeratedValueSet variable="Player1-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Player2-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Player3-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Player4-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Player5-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Player6-Number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-houses">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-people">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fine-steps?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
