breed [ants ant] ; ants!
breed [sWorkers sWorker] ; small workers
breed [lWorkers lWorker] ; large workers
breed [sSoldiers sSoldier] ; small soldiers
breed [queens queen] ; queen
breed [qScents qScent] ; queenscent
ants-own [breach]
sWorkers-own [mud vibration] ; patch in front of the workers' color
qScents-own [energy]
patches-own [class qLevel sigStr] 
; qLevel- queen scent in the air in the nest
; sigStr- breach signal strength
globals [ breachx breachy qx qy qMoves]
; qx - queen xcor
; qy - queen ycor
; qMoves - # of times the queen has moved
; class- patch classification system 
; 0 for dirt
; 1 for nest air
; 2 for outside air
; 3 for queens nest
; 4 for new dirt 
; 5 for emergency exit


;########################################
; SETUP
;########################################
to setup
  
  clear-all
  
  set majorBreach false
  set qMoves 0
  
  set-default-shape turtles "bug"
  
  import-pcolors "nest.bmp"
  ; import of paintbrush .bmp files dimensions 60x75
  ; light gray for queens nest
  ; dark gray for hive air
  ; black for dirt
  ; white for outside air
  
  ;DIRT PATCHES - 0
  ask patches with [pcolor = 0] ; ask dirt patches
  [
    nestDirt
  ]
  
  ;NEST AIR - 4.5
  ask patches with [pcolor = 4.5]
  [
    nestAir
  ]
  
  ;OUTSIDE AIR - 9.9
  ask patches with [pcolor = 9.9]
  [
    outsideAir
  ]
  
  ;QUEENS NEST - 7.3
  ask patches with [pcolor = 7.3]
  [
    queensRoom
  ]
  
  ;POPULATE NEST
  setupTermites
  setupAnts
  
  ;EMERGENCY EXIT
  ask patches with [pcolor = 14.9]
  [
    set class 5
  ]
    
  ;SETUP PLOTS
  do-plots
end

;**************************
;PLOT SETUP
to do-plots
  set-current-plot "Totals"
  set-current-plot-pen "sSoldiers"
  plot count sSoldiers
  set-current-plot-pen "ants"
  plot count ants
  set-current-plot-pen "sWorkers"
  plot count sWorkers
end

;**************************
;TERMITE SETUP
to setupTermites
  
  ;workers and soldiers
  ask patch 5 11
  [
    sprout-sWorkers startTermiteCount * .8
    [
      set color gray
      set size 1
      set mud 0
    ]
    sprout-sSoldiers startTermiteCount * .2
    [
      set shape "soldier"
      set color red
      set size 1
    ]
  ]
  
  ;spawn queen
  ask patch 6 -14
  [  
    sprout-queens 1
    [
      set shape "queen"
      set size 10
      set heading 270
      set color yellow + 4
      set qx xcor + 3
      set qy ycor
    ]
  ]
  ;setup scent trail
  ask queens
  [
    ask patch xcor ycor 
    [
      sprout-qScents 100
      [
        set energy 90
        set size 0
      ]
    ]
  ]
end 

;**************************
; ANT SETUP
to setupAnts
  ask patch -16 8
  [  
    sprout-ants startAntCount
    [
      set color black
      set size 1
      set heading 90
      set breach 0
    ]
  ]
end


;########################################
; GO
;########################################
to go
  
  
  tick
  
  
  ;**************************
  ; STOP CONDITIONS
  if qx < -23
  [ show "Queen escapes safely."
    stop ]
  
  if count queens = 0
  [ show "Queen has been slain."
    stop]
  
  
  ;**************************  
  ; DEMO CODE
  if demoMode = true
  [
    ask patches with [class = 1 or class = 4 or class = 3 or class = 5]
    [set pcolor qLevel]
    ask patches with [class = 2]
    [
      if sigStr > .1
      [
        set pcolor 20 - sigStr
      ]
    ]
  ]
    
  ;**************************
  ;SMALL WORKER GO
  ask sWorkers
  [
    ifelse majorBreach = false
    [ 
      mudWork
      terMove
    ]
    [
      evacuateWorkers
      ;next if statement is simply code
      if any? neighbors4 with [class = 2] or count neighbors4 with [class = 0] > 3
      [ die ]
    ]
  ]
    
  ;**************************
  ;SMALL SOLDIER GO
  ask sSoldiers
  [ 
    ifelse majorBreach = false
    [ 
      ifelse count neighbors4 with [class = 2] > 0 ; if the soldier is exposed to outside air
      [ guardBreach ]
      [ sSolMove ]
    ]
    [ 
      protectTheQueen 
      ;next if statement is simply cleanup code
      if any? neighbors4 with [class = 2] or count neighbors4 with [class = 0] > 3
      [ die ]
    ]
    sSFight
  ]
  
  
  ;**************************
  ; ANT GO
  ask ants
  [
    ifelse breach = 0
    [antMove]
    [
      ifelse breach = 1
      [assault]
      [
        if breach = 2
        [
          retreat
          ;next if statement is simply cleanup code
          if any? neighbors4 with [class = 2] or count neighbors4 with [class = 0] > 3
          [ die ]
        ]
      ]
    ]
    antFight
  ]
  
  
  ;**************************
  ; QUEEN SCENT GO
  if any? qScents
  [
    ask qScents
    [
      qMove
    ]
  ]
  
  
  ;**************************
  ; NEST MAINTENENCE
  ifelse majorBreach = false
  [
    ;PATCH REPAIR  
    ask patches
    [ updateNest ]
    
    ask patches with [class = 4] ; new dirt
    [
      if count neighbors with [class = 2] < 1 ; if disturbances have been fixed
      [
        ; remove unnecessary new-dirt patches
        nestAir
        ;show max-one-of neighbors4 [qLevel]
        let highQ [qLevel] of max-one-of neighbors4 [qLevel]
        set qLevel highQ - .1
      ]
    ]
  ]
  [ ;else if majorBreach = true
    ask queens [queenMove]
    ask patches with [class = 4] ; new dirt
    [
      if pcolor < 32
      [
        nestDirt
      ]
    ]
  ]
  
  
  ;**************************
  ; MOUSE ATTACK
  if mouse-down? ; if the mouse is clicked
  [ ask patch mouse-xcor mouse-ycor 
    [ if class = 0 ; and the patch that is clicked is dirt
      [
        if any? neighbors with [class = 2] ; and the patch is an outside dirt patch
        [ 
          outsideAir
          set qLevel 0
          ask neighbors4 with [class = 0]
          [
            outsideAir
            set qLevel 0
          ] 
        ]
      ] 
    ]
  ]
  
  ;PLOT UPDATE
  do-plots
end


;########################################
; SMALL WORKER TERMITE COMMANDS
;########################################
;**************************
; MUDWORK
to mudWork
  ;pickup
  if mud = 0 ; if not carrying mud
  [
    ifelse ycor < -21 ; if in the cellar of the nest
    [ 
      if any? neighbors4 with [class = 0]
      [
        ask one-of neighbors4 with [class = 0]
        [
          set pcolor pcolor + .1
        ]
        set mud 1
      ]
    ]
    [
      if random 100 < 10 ; 10% chance to pick up dirt from anywhere
      [
        if any? neighbors4 with [class = 0]
        [
          if mud = 0
          [
            set mud 1
            ask one-of neighbors4 with [class = 0]
            [
              set pcolor pcolor + .05
            ]
          ]
        ]
      ]
    ]
  ]
  ;dropoff
  if mud = 1
  [ 
    ifelse any? neighbors4 with [class = 2] ; if you have mud, and any of your neighboring patches are air
    [
      ;drop your mud
      set mud 0
      ask patch-here
      [
        mudDrop
      ]
    ]
    [
      if ycor > -21 ; if not in cellar
      [
        nestMaintenence
      ]
    ]
  ] 
end
;**************************
; GENERAL MAINTENENCE
to nestMaintenence
  ; repair any mound dirt that may have been damaged
  if any? neighbors4 with [class = 0 and pcolor > 32] 
  [
    set mud 0
    ask one-of neighbors4 with [class = 0 and pcolor > 32]
    [
      set pcolor pcolor - .1
    ]
  ]
  ; also, if worker termite is standing on a patch of newdirt, and is holding mud, drop mud
  ask patch-here
  [
    if class = 4
    [                
      ask sWorkers-here with [mud = 1]
      [
        ;show "DROP HERE"
        set mud 0;
        ask patch-here
        [
          set pcolor pcolor - .1
        ]
      ]
      if pcolor < 32
      [
        nestDirt
      ]
    ]
  ]
end
;**************************
; PROTECT THE QUEEN
to queenChain
  if distancexy qx qy > 4
  [
    face patch qx qy
    fd .05
  ]
end
to farQueenChain
  if distancexy qx qy > 8
  [
    face patch qx qy
    set heading heading + random 45 - 22.5
    fd .05
    if [class] of patch-here = 0
    [ 
      set heading heading + 180
      fd .25
      set heading (heading + random 180) + 90
    ]
  ]
end


;########################################
; SMALL SOLDIER TERMITE COMMANDS
;########################################
;GUARD BREACH
to guardBreach 
  ask patch-here
  [ ; if the patch being guarded gets restored
    if class = 0
    [
      ask sSoldiers-here 
      [ atEase ]
    ]
  ]
end
;BACK TO NORMAL
to atEase
  facexy 5 -26 ; face middle of the next
  fd .5 ; move soldiers back in
end
;COMBAT
to sSFight
  if any? ants-on neighbors4
  [
    ask one-of ants-on neighbors4
    [
      die 
    ]
    if count ants = 0
    [
      show "Termites win this round."
      ask patches with [class = 2 or class = 0]
      [set sigStr 0]
    ]  
    ask patch-here ;if the ants have reached the inner chimney of the nest
    [
      if qLevel > deepBreach and count neighbors with [class = 1] > 6
      [
        set majorBreach true
      ]
    ]
  ]
end


;########################################
; ANT COMMANDS
;########################################
;REINFORCEMENTS
to addAnts
  ask patch -16 8
  [
    ifelse sigStr > 0
    [
      sprout-ants 10
      [
        set color black
        set size 1
        set heading 90
        set breach 1
      ]
    ]
    [
      sprout-ants 10
      [
        set color black
        set size 1
        set heading 90
        set breach 0
      ]
    ]
  ]
end
to addMadAnts
  ask patch -16 8
  [
    ifelse sigStr > 0
    [
      sprout-ants 100
      [
        set color black
        set size 1
        set heading 90
        set breach 1
      ]
    ]
    [
      sprout-ants 100
      [
        set color black
        set size 1
        set heading 90
        set breach 0
      ]
    ]
  ]
end
;COMBAT
to antFight
  ; if ants surround termites they can kill them
  
  if count ants-on neighbors4 > 30
  [
    if any? queens-on neighbors4
    [
      ask one-of queens-on neighbors4
      [ 
        die 
      ]
    ]
  ]
  
  if count ants-on neighbors4 > 3
  [
    if any? sSoldiers-on neighbors4
    [
      ask one-of sSoldiers-on neighbors4
      [ die ]
    ]
  ]
  if any? sWorkers-on patch-here
  [ 
    ask one-of sWorkers-on patch-here
    [ 
      die 
    ]
  ]
end
;SIGNAL TO OTHER ANTS
to sendSignal
  ask ants 
  [
    set breach 1
  ]
  ask one-of neighbors4 with [class = 4]
  [
    set breachx pxcor
    set breachy pycor
  ]
  
  ask patches with [class = 2 or class = 4]
  [
    let howFar 7 / (.1 + (distancexy breachx breachy) * (distancexy breachx breachy))
    set sigStr howFar
  ]
  
end



;########################################
; PATCH SET COMMANDS
;########################################

;**************************
;NEST MAINTENENCE
to updateNest
  
  ; Cellar Update
  if class = 0 and pcolor > 39.5; if dirt patch has been depleted, change it to nest air
  [ nestAir ] ; ie in the cellar
  ; SpillOver
  ; programs newDirt patch darkening to allow for spillover that one of the neighbors 4 is outer air
  if class = 4 and pcolor < 38 ; if newdirt patch is dark enough
  [
    ask neighbors with [class = 2] ; ask outer air neighbors
    [     
      ifelse pcolor = 9.9 ; if first spillover
      [
        set pcolor 39.5 ; change color to very light brown
      ]
      [ ; else, just darken the patch
        ifelse pcolor > 32 
        [
          set pcolor pcolor - .1
        ]
        [ ; if the patch gets dark enough, change it to nestdirt
          nestDirt
          ;ask myself [nestDirt]
        ]
      ]
    ]
    ; if any of the neighboring patches are new dirt, make sure they get filled completely (through spillover) 
    ; before filling in the parent dirt patch
    if any? neighbors4 with [class = 4]
    [
      set pcolor 38
    ]
  ]
end

to outsideAir
  set class 2 ; change the dirt to outside air
  set pcolor 9.9
end
to nestDirt
  set class 0
  set pcolor 32
end
to nestAir
  set qLevel 0
  set class 1
  set pcolor 59.5 ; very light green - 55 is darker green
end
to queensRoom
  set class 3
  set pcolor 7.3
end
to newDirt
  set class 4
  set pcolor 39
end
to mudDrop
  ifelse class = 2 or class = 1; if the patch is air
  [
    newDirt
  ]
  [
    if class = 4 ; if the patch is new dirt
    [
      set pcolor pcolor - .1
    ]
  ]
end


;########################################
; MOVEMENT RULES
;########################################

;**************************
;DEFAULT WORKER MOVEMENT
to terMove
  let class-ahead [class] of patch-ahead 1
  ifelse class-ahead = 1 or class-ahead = 4 or class-ahead = 3
  [ fd .25 ]
  [ set heading heading + ((random 150) - 75)]
end
;ASSAULT WORKER MOVEMENT
to evacuateWorkers
  let my-class [class] of patch-here
  let higherClass any? neighbors4 with [class > my-class]
  
  ifelse my-class = 1 ;current location is nest air
  [
    ifelse higherClass = false ;get to the queens chamber
    [
      if any? neighbors with [qLevel > 0]
      [
        face max-one-of neighbors4 [qLevel]
        fd .3
        if [class] of patch-here = 0
        [ 
          set heading heading + 180
          fd .35 
        ]
      ]
    ]
    [ ;when you are at the border, enter the queens chamber
      face one-of neighbors4 with [class > my-class] 
      fd .2
      backstep
    ]
  ]
  [ ;current location is queens nest, new dirt, or escape route
     
    let class-ahead [class] of patch-ahead 1
    ifelse class-ahead = 3 or class-ahead = 5 or class-ahead = 4
    [ fd .3 ]
    [ set heading heading + ((random 150) - 75)]
    
    ifelse higherClass = false 
    [
      ;not on the border
    ]
    [
      ifelse qx > -2
      [
        ;on the border
        if (count neighbors with [class = 5] >= 2) and (count neighbors with [class = 3] >= 2)
        [
          if mud = 1
          [
            set mud 0
            ask neighbors4
            [ newDirt ]
            ask patch-here
            [ newDirt ]
          ]
        ]
      ]
      [
        ifelse (count neighbors with [class = 5] >= 2) and (count neighbors with [class = 3] >= 2)
        []
        [
          if mud = 1
          [
            if any? neighbors4 with [class = 4]
            [
              ask one-of neighbors4 with [class = 4]
              [
                set pcolor pcolor - .1
              ]
            ]
          ]
        ]
      ]
    ]
    ifelse qx > -2
    [queenChain]
    [
      ifelse [class] of patch-here = 3 ;stuck in queens nest
      [
        terMove
      ]
      [farQueenChain]
    ]
  ]

end

;**************************
;DEFAULT SOLDIER MOVEMENT
to sSolMove
  let class-ahead [class] of patch-ahead 1
  let y-ahead [pycor] of patch-ahead 1
  ifelse (class-ahead = 1 or class-ahead = 4) and y-ahead > -17
  [ fd .2 ]
  [ set heading heading + ((random 150) - 75)]
end
;ASSAULT SOLDIER MOVEMENT
to protectTheQueen
  ifelse any? neighbors with [qLevel > 0] ;queens nest
  [
    face max-one-of neighbors4 [qLevel]
    let class-ahead [class] of patch-ahead 1
    ifelse class-ahead = 1
    [ fd .2 ]
    [ ifelse class-ahead = 3
      [ ;patrol
        set heading ((random 3) - 1) * 90
        fd .2
        backstep
      ]
      [set heading heading + ((random 150) - 75)]
    ]
  ]
  [
    set heading heading + 180
    fd .2
  ]
end

;**************************
;DEFAULT ANT MOVEMENT
to antMove
  let class-ahead [class] of patch-ahead 1
  let x-ahead [pxcor] of patch-ahead 1
  let y-ahead [pycor] of patch-ahead 1
  let temp false
  
  ask patch-ahead 1
  [
    set temp any? neighbors4 with [class = 0]
  ]
  
  ifelse (class-ahead = 1 or class-ahead = 4 or class-ahead = 2) and (temp = true)
  [ 
    
    fd .125
    if any? neighbors4 with [class = 4]
    [
      ;signal to other ants of the breach
      sendSignal
      ;show "SEND SIGNAL"
      bk .125
      set breachx xcor
      set breachy ycor
      fd .125
    ]
  ]
  [ set heading heading + ((random 150) - 75)]
end
;ASSAULT ANT MOVEMENT
to assault
  let fightOrMove any? sSoldiers-on neighbors4
  if fightOrMove = false
  [
    ifelse any? neighbors4 with [qLevel > 0]
    [
      face max-one-of neighbors4 [qLevel]
      let retreatCheck [class] of patch-ahead 1
      if retreatCheck = 0 ;termites have escaped
      [
        set breach 2
      ]
      fd .1
      if [class] of patch-here = 0
      [ 
        set heading heading + 180
        fd .125
      ]
    ]
    [
      ifelse any? neighbors with [sigStr > 0]
      [
        face max-one-of neighbors4 [sigStr]
        fd .1
        if [class] of patch-here = 0
        [ 
          set heading heading + 180
          fd .125
        ]
        if ([class] of patch-here = 2 and [pcolor] of patch-here > 32)
        [ 
          ask patch-here [set pcolor 39]
        ]
      ]
      [
        ;show "NOTHING"
        set heading heading + 180
        fd .125
      ]
    ]
  ]
end
;ANT RETREAT
to retreat
  termove
end

to backStep
  if [class] of patch-here = 0
  [ 
    set heading heading + 180
    fd .25
  ]
end

;**************************
;QUEEN SCENT MOVEMENT
to qMove
  let class-ahead [class] of patch-ahead 1
  ifelse class-ahead = 1 or class-ahead = 4 or class-ahead = 3 or class-ahead = 5
  [
    fd 1
    set energy energy - .1
    if energy < 80
    [ die ]
    setQlevel energy
    if class-ahead = 2
    [ set heading random 360 ]
  ]
  [ set heading heading + ((random 150) - 75)]
end
to setQlevel [en] ; keeps only shortest path
  ask patch-here
  [
    if en > qlevel
    [
      set qLevel en
      sprout-qScents 4
      [
        set energy [qLevel] of patch-here
        set size 0
      ]
      
    ]
  ]
end

;**************************
;QUEEN MOVEMENT
to queenMove
  set qx xcor + 3
  set qy ycor
  
  if count sWorkers-on neighbors4 > 25 ;startTermiteCount / 100
  [
    let yourPatch [class] of patch-here
    ifelse yourPatch = 3; queens nest
    [
      set heading 255 + random 30
      fd .05
      set qMoves qMoves + .005
      ask patches with [pxcor = [pxcor] of myself and pycor = [pycor] of myself - 3 + random 6 ]
      [
        set qLevel 90 + qMoves
      ]
    ]
    [
      let class-ahead [class] of patch-ahead 3
      ifelse class-ahead = 5 or class-ahead = 4 or class-ahead = 3
      [ 
        fd .05 
        set qMoves qMoves + .005
        ask patches with [pxcor = [pxcor] of myself and pycor = [pycor] of myself - 3 + random 6 ]
        [
          if class != 0
          [
            set qLevel 90 + qMoves
            ;show qLevel
          ]
        ]
      ]
      [ set heading 240 + random 60 ]
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
225
10
1028
1016
30
37
13.0
1
10
1
1
1
0
1
1
1
-30
30
-37
37
0
0
1
ticks
BUTTON
10
205
90
238
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
95
205
180
238
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
MONITOR
10
570
205
615
Nest Air
count patches with [class = 1]
17
1
11
MONITOR
10
435
90
480
Soldiers
count sSoldiers
17
1
11
MONITOR
10
515
205
560
Workers  Count
count sWorkers
17
1
11
MONITOR
125
435
205
480
Ants
count ants
17
1
11
BUTTON
10
325
90
358
+ 10 Ants
addAnts
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
PLOT
10
635
205
785
Totals
time
sSoldiers
0.0
10.0
0.0
10.0
true
true
PENS
"sSoldiers" 1.0 0 -2674135 true
"ants" 1.0 0 -16777216 true
"sWorkers" 1.0 0 -7500403 true
BUTTON
95
325
180
358
+ 100 Ants
addMadAnts
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
SLIDER
10
125
180
158
startAntCount
startAntCount
0
1000
500
50
1
NIL
HORIZONTAL
SLIDER
10
85
180
118
startTermiteCount
startTermiteCount
0
2500
1500
100
1
NIL
HORIZONTAL
SWITCH
10
245
180
278
majorBreach
majorBreach
1
1
-1000
SLIDER
10
165
180
198
deepBreach
deepBreach
85
89
87
.2
1
NIL
HORIZONTAL
SWITCH
10
285
180
318
demoMode
demoMode
1
1
-1000
TEXTBOX
100
450
120
468
vs
14
0.0
1
TEXTBOX
35
415
185
451
War of the Underworld
14
0.0
1
TEXTBOX
80
495
130
511
Civilians\\n
15
0.0
1
TEXTBOX
15
60
165
81
Controls
18
0.0
1
TEXTBOX
10
385
160
406
Monitors
18
0.0
1
TEXTBOX
10
15
215
50
TERMITE DEFENSE
24
0.0
1
@#$#@#$#@
WHAT IS IT?
-----------
Termite Defense is a netLogo project in which termites attempt to defend their queen against an attack from ants.
It is an attempt to model the seemingly complex aggregate behavior exhibited by termites in the physical world.

HOW IT WORKS
------------
There are 4 main species of turtles in this model.
Queen Termite - is pulled to safety during a critical breach by worker termites
Worker Termites - responsible for the rebuilding of the nest, and pulling the queen to safety
Soldier Termites - responsible for defending the nest against intruders, and killing ants 
Ants - ants roam the surface of the nest until a breach is found, upon which point in time, they signal to their army the location of the breach, and commence assault.
Given a small enough number of ants, the colony will defend itself, but when the large inner chamber is breached, the termites enter an emergency mode to protect its queen.
The majorBreach switch is for forcing major breach behavior.
The demoMode switch displays the colored queen's pheromone level per inside patch, and the assault signal on the outer patches for the ants.

HOW TO USE IT
-------------
Use the top two sliders, startTermiteCount and startAntCount to choose the starting populations of both termites and ants.
As a rule, soldier termites make up 1/5th of the population, and worker termites make up the remaining 4/5ths.
Use the deepBreach slider to determine how far into the nest the ant's must go before the breach is declared a major breach, and the termites go into phase two.  
The leftmost value will initiate queen protection mode very soon after the ants enter the nest.  
The rightmost value will allow the ants to catch and kill the queen.
The default value of this slider is the approximate value of main chimney vent in the middle of the nest.
After deciding these parameters, click the SETUP BUTTON.
Then click the GO BUTTON.
After allowing the queen's scent (clock based- approx 200 ticks) to permeate through the nest, LEFT-CLICK the outer surface of the termite mound near the ant army to initiate an assault on the termite queen.

THINGS TO NOTICE
----------------
If you create a breach away from the army of ants, the termites do a relatively good job in holding them off and rebuilding the nest.
The soldier termites, block the entrance to the nest, killing intruders and protecting the workers.
The worker termites will slowly patch up the breach.  Large breaches are patched up using an overspill of dirt, as the way it commonly occurs in the natural world.  Dirt is continually piled at the sites of the breaches until the nest has been returned to normal.

THINGS TO TRY
-------------
The critical value of ants according to the combat protocols specified is approximately  1.2 times the number of soldier termites, or .24 times the entire termite population.
Even if all the ants eventually get killed by the soldier termites, 1.2 times the number of soldier termites will cause phase 2, the reaction to a serious breach.
It may be of interest to see the method behind the ant navigation and signaling.
This can be seen if the SEMICOLONS are removed from the 7 lines of code following the "@@ DEMO CODE @@" comment in the GO SECTION.

EXTENDING THE MODEL
-------------------
1. Implement a mode of retreat for the ants.
2. Implement the repopulation of the ant nest including the reopening of the escape chamber as well as the queen producing more young.
3. Implement large soldiers and workers
4. Simulate the respiratory nature and temperature management of the nest.
5. Use the temperature to more accurately simulate breach repair for more severe breaches as well.

NETLOGO FEATURES
----------------
Temporary variable declaration as a means of accessing patch variables for use by turtles was used.
In particular, 
  let class-ahead [class] of patch-ahead 1
  let y-ahead [pycor] of patch-ahead 1
is used very frequently.
The distancexy primitive saved much time when attempting to calculate the radius from one patch or turtle to another.  This was particularly useful in modelling the assault notice.
The background nest image is a 1:1 ratio 61x75 .bmp image hand drawn in msPaint. 
import-pcolors "nest.bmp"

RELATED MODELS
--------------
Online Link to this model:
http://modelingcommons.org/browse/one_model/2593
Wilensky, U. (1997).  NetLogo Ants model.  http://ccl.northwestern.edu/netlogo/models/Ants.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

CREDITS AND REFERENCES
----------------------
Attenborough, David. "Termites - Life's Ultimate Architects". BBC - YouTube. June 01, 2009 <http://www.youtube.com/watch?v=0m7odGafpQU>.
Maeterlinck, Maurice. The Life of the White Ant. London: George Allen & Unwin LTD, 1927. 
Schoning, Caspar, and Mark Moffett. "Driver Ants Invading a Termite Nest: Why Do the Most Catholic Predators of All Seldom Take This Abundant Prey?". University of Copenhagen. June 02, 2009 <http://www1.bio.ku.dk/forskning/oe/cse/media/schoening2007_biotropica.pdf/>. 
Turner, Scott . "Structure of Macrotermes mounds". State University of New York College of Environmental Science and Forestry. June 01, 2009 <http://www.esf.edu/efb/turner/termite/termhome.htm>.
"Wars of the Underworld". VidMax - YouTube. June 01, 2009 <http://www.youtube.com/watch?v=mY9LNEJNrZs&feature=related>.
Wilensky, U. (1997).  NetLogo Ants model.  http://ccl.northwestern.edu/netlogo/models/Ants.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
queen
true
0
Circle -7500403 true true 96 227 108
Circle -7500403 true true 89 136 122
Circle -7500403 true true 130 50 40
Line -7500403 true 150 75 135 30
Line -7500403 true 150 70 165 30
Circle -7500403 true true 101 71 96
Polygon -16777216 true false 150 142 135 150 150 160 165 150
Polygon -16777216 true false 150 216 135 225 150 234 165 225
soldier
true
0
Circle -7500403 true true 90 266 120
Circle -7500403 true true 105 197 90
Circle -7500403 true true 75 55 150
Polygon -7500403 true true 135 0 120 0 75 45 105 75 135 75 105 45 135 0
Polygon -7500403 true true 165 0 195 45 165 75 195 75 225 45 180 0
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
