globals [
  max-infected
  cumulative-output
  daily-delta
  total-infected
  avg-daily-delta
  total-delta
  moving-average
  day-1
  day-2
  day-3
  day-4
  day-5
  transmissibility
]


turtles-own[
  infected?
  immune?
  mask?
  dead?
]

to setup
  clear-all
  set-patch-size (275 / max-pxcor)
  setup-turtles
  setup-infected
  setup-unmasked
  set max-infected (count turtles with [infected?])
  set cumulative-output (0)
  set transmissibility (1)
  reset-ticks
end

to setup-turtles
  create-turtles num-people [
    set color blue
    set shape "person"
    set size 2
    set infected? false
    set immune? false
    set mask? true
    set dead? false
    setxy random-pxcor random-pycor
  ]
end

to setup-unmasked
  ask n-of ((percent-unmasked / 100) * num-people) turtles [
    set color white
    set mask? false
  ]
end

to setup-infected
  ask n-of init-infected turtles [
   set infected? true
    ifelse mask?
      [set color red]
      [set color orange]
  ]



end

to go
  ;;stop if everyone or noone is infected
  ;;if (count turtles with [infected? and not dead?] = 0)
  ;;or (count turtles with [infected?] = num-people)

  infect-susceptibles
  recover-infected
  death
  recolor
  move-normal
  calculate-max-infected
  calculate-daily-delta
  if ticks > 0
  [calculate-avg-daily-delta]
  calculate-total-infected
  recolor
  calculate-moving-average

  tick

end





to infect-susceptibles ;; S -> I
   ask turtles with [not infected? and not immune?][
    let infected-masked-neighbors (count turtles-here with [infected? and mask?])
    if (random-float 1 <  1 - (((1 - masked-transmissibility) ^ infected-masked-neighbors)))
    [set infected? true]
    let infected-neighbors (count turtles-here with [infected? and not mask?])
    if (random-float 1 <  1 - (((1 - transmissibility) ^ infected-neighbors)))
    [set infected? true]
   ;let infected-neighbors (count other turtles with [infected?] in-radius 1)
  ; if (random-float 1 <  1 - (((1 - transmissibility) ^ infected-neighbors)) and not immune?)
   ;[set infected? true]
]
end

to recolor
  ask turtles with [infected? and not dead? and mask?]
  [ set color red]
  ask turtles with [infected? and not dead? and not mask?]
  [ set color orange]
  ask turtles with [mask? and not infected?]
  [set color blue]
  ask turtles with [not mask? and not infected?]
  [set color white]
  ask turtles with [immune?]
  [set color gray]
  ask turtles with [dead?]
  [ set color pink]

end

to move-normal

  ask turtles with [not dead?] [
    right random 360 ;;get a new random heading
    forward random sociability
  ]

end


to recover-infected ;;I -> R

  ;;avg case length is 2 weeks.
  ;;should have 50% chance of becoming immune at 2 weeks
  ;;if we are saying each tick equals 1 day,
  ;;daily odds of recovering should be (1-x)^14=.5, x= 0.0483


  ask turtles with [infected? and not dead?]
  [
    if random-float 1 < 0.0483
    [
      set infected? false
      ifelse are-survivors-immune?
      [
        set immune? true
        set color gray
      ]
      [set color white]
    ]
  ]
end

to death
  ;;avg case length is 2 weeks.
  ;;1% of infected die,
  ;;if we are saying each tick equals 1 day,
  ;;and 1% of sick patients should be dead at 2 weeks
  ;;daily mortality should be (1-x)^14=.99, x= 0.000717624
  ask turtles with [infected?]
  [
    if random-float 1 < 0.000717624
    [set dead? true
    set color pink
    set infected? false
    ]
  ]
end

to calculate-max-infected
  let x (count turtles with [infected? and not dead?])
  if x > max-infected
  [set max-infected x]
end

to calculate-total-infected
  set total-infected ((count turtles with [infected? and not dead?]))
end

to calculate-daily-delta
  set daily-delta (count turtles with [infected? and not dead?] - total-infected)
end

to calculate-avg-daily-delta
  let y (daily-delta)
  set total-delta (total-delta + y)
  set avg-daily-delta (total-delta / ticks)
end

to calculate-moving-average

  set day-1 (day-2)
  set day-2 (day-3)
  set day-3 (day-4)
  set day-4 (day-5)
  set day-5 (daily-delta)
 if (ticks > 4) [
  set moving-average ((day-1 + day-2 + day-3 + day-4 + day-5) / 5)
  ]
end



to-report total-adjusted-output
  report cumulative-output / (num-people * 2 * (ticks))
end


to-report max-infected-prop
  report max-infected / num-people
end


to-report prop-dead
  let y (count turtles with [dead?])
  report y / num-people
end

to-report prop-uninfected
  report (count turtles with [not infected? and not immune?]) / num-people
end
@#$#@#$#@
GRAPHICS-WINDOW
245
13
808
577
-1
-1
5.5
1
10
1
1
1
0
1
1
1
-50
50
-50
50
1
1
1
days
30.0

BUTTON
47
22
114
56
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
120
22
184
56
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
36
63
210
96
num-people
num-people
0
10000
2000.0
100
1
NIL
HORIZONTAL

SLIDER
36
99
209
132
init-infected
init-infected
1
1000
100.0
1
1
NIL
HORIZONTAL

SLIDER
35
178
210
211
sociability
sociability
0
10
3.2
.1
1
NIL
HORIZONTAL

PLOT
850
10
1459
334
infection
time
proportion infected
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"infected" 1.0 0 -2674135 true "" "plot (count turtles with [infected? and not dead?]) / num-people\n"
"susceptible" 1.0 0 -16777216 true "" "plot (count turtles with [not infected? and not immune?]) / num-people"
"recovered" 1.0 0 -7500403 true "" "plot (count turtles with [immune?]) / num-people"
"dead" 1.0 0 -2064490 true "" "plot (count turtles with [dead?]) / num-people"

SWITCH
36
526
213
559
are-survivors-immune?
are-survivors-immune?
0
1
-1000

MONITOR
850
341
984
386
NIL
max-infected-prop
5
1
11

MONITOR
999
341
1116
386
NIL
prop-uninfected
17
1
11

SLIDER
35
138
225
171
percent-unmasked
percent-unmasked
0
100
97.0
1
1
%
HORIZONTAL

SLIDER
35
217
240
250
masked-transmissibility
masked-transmissibility
0
1
0.9
.01
1
NIL
HORIZONTAL

MONITOR
1133
342
1213
387
NIL
prop-dead
17
1
11

TEXTBOX
18
345
268
443
Key:\nBlue = Healthy, mask\nWhite = Healthy, no mask\nRed = Infected, mask\nOrange = Infected, no mask\nGrey = Recovered, immune\nPink = Dead
11
0.0
1

PLOT
850
402
1463
619
5-day-moving-average-new-cases
NIL
NIL
0.0
10.0
-10.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -5825686 true "" "plot moving-average"

@#$#@#$#@
## WHAT IS IT?

A model of an infectious disease within a community.

People move about randomly, and if they run into a person who is sick, they have a chance of getting sick themselves. The illness runs on average two weeks, and has a 1% death rate.
These processes are all stochastic, so somebody could die on day 2 of the illness, or could have it for a month

Here is what makes this model unique:


I have seen a couple of models online which illustrate the effects of social distancing on the spread of a disease, but they typically did this by social distancing the entire population, which to me seems like a bit of an unnecessary oversimplification. For this model, I'm interested in breaking down social distancing into two of its components:
	1. How many people are distancing? Is it half the population? 75%? 10%?
	2. How aggressively are they distancing? Are they literally staying in one place? or are they just being more cautious, going out less?

This model allows us to explore how varying 1 and 2 affect the outcome of the entire community. Is social distancing useless unless most people do it? Is social distancing useless unless it's extreme? Can we effect a meaningful change in outcome by having only a small proportion of citizens social distance?

Additionally, I've created a self-balancing mechanism which can be turned on or off. 
This self-balancing mechanism is to help try to model how a society would eaase out of social distancing while the virus was still present.
A couple of new variables that the self-balancing uses:

	[threshold] - this is the "acceptable" infected proportion of the population (ie, "the healthcare system can't handle more than 5% of the population sick with this thing at any one time, so we have to keep it under 5%")

	[distance-step-ups] - when the proportion of people currently infected ([prop-infected]) nears the threshold, the proportion of the population social distancing increases. If the [prop-infected] rises above the threshold, or daily net new cases are  too high (indicating rapid growth), the proportion of the population taking social distancing measures increases. So, for example, if 11% of the population is infected, the number of people taking social distancing measures would increase by ([distance-step-ups] * [num-people]) amount every day until prop-infected falls below 10%. 

	[distance-step-downs] - the same as the above, but for easing social distancing restrictions. Once prop-infected falls below ([threshold]*.75) and net new cases are negative, the proportion of people social distancing is decreased by ([distance-step-downs] * [num-people]). 


What should the step-ups and step-downs be? That’s a good question. The granularity with which a society can adjust how many of its citizens are social distancing unclear and subject to political pressures. On one end of the spectrum, we could imagine a government announcing every morning which birthdays were allowed to leave the house. On the other end of the spectrum, we could imagine a government announcing at the start of the month that everyone must stay inside, and at the end of the month, letting everybody out. The most realistic course of action is probably somewhere in the middle. I think most citizens would get awfully fed up with a government micromanaging and making frequent adjustments, however, we probably want something more attentive than the second scenario. This is an added challenge — we want a self-balancing system that takes large enough steps so as not to require super frequent adjustments, but also keeps the virus at acceptable levels. To start, I’ve set the [distancing-step-ups] (by what percentage of the population do we increase the total number of people distancing) at 10%. I’ve done the same for [distancing-step-downs]  (by how much do we decrease the number of people social distancing).  We can imagine city governments being able to adjust social distancing behavior with this sort of granularity by taking steps such as expanding and contracting the list of “essential businesses”. (Note: I am well aware of the fact that opening and shuttering businesses adds a whole new level of economic stress and greatly impacts these business’s ability to plan. That being said, I think what we’re interested in here is the effect of slowly opening or closing the economy on the spread of a virus, not the economic difficulties and feasibility of opening and closing the economy.)




## HOW IT WORKS
&& 
## HOW TO USE IT
(what rules the agents use to create the overall behavior of the model)


I'll go through the variables and what is a good range for them to be set at:

num-people = This is the number of total people in the community, for this size grid, I think 1500 is a decent starting point. Less people -> disease has harder time spreading, more people -> disease spreads more easily

init-infected = This is how many initial cases the community has. You can set it as low as you want


num-people-social-distancing = of the total number of people, how many of them are socially distancing? Play around with this one, you start to be able to really see the impact once it's over 60% of the population. Also try it with zero! REMEMBER: this number must be lower than num-people

sociability-of-non-distancers = how much do non social distancers move around? The higher this number, the larger their movements. Try different numbers for this.

sociability-of-distancers = how much do social distancers move around? This number should be pretty low, I think generally, below 1. Play around with it, but just remember that it should be lower than sociability-of-non-distancers.

NOTE: the sociability of an individual does not change if he becomes infected. Distancers will continue to distance even if they become infected, but they will change color to red.

Once there are no more active infections in the community, people stop social distancing. 


## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

To begin building this, I modified code for an SIR model by Paul Smaldino
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             