globals [XC YC]


patches-own
[ R ]

to setup
  clear-all
  ;;set VERBOSE true;

  ;; make some patches, forest is all resistance <= 2
  ask patches [ set R  2.1 + random-float  5  set pcolor yellow]
  ask patches [ if pxcor > 12 and pycor  > 8 and pycor < 12 [set R 1 + random-float 1 set pcolor green]]

  ;; compute centroid of the green
  set XC   mean [pxcor] of patches with [ pcolor = green ]
  set YC   mean [pycor] of patches with [ pcolor = green ]
       if VERBOSE [ print (word " centroid of green is (" XC " , " YC " ) ") ]

  ask patch XC YC [ set pcolor ( green + 2 )  ]  ;; I'll use test of R to determine when to stop

  create-turtles NUMTURTLES [   set size 2 setxy random-xcor random-ycor set shape "turtle" ]
  ask turtles [pen-down]
  reset-ticks
end

to go
  if ( 0 = count turtles with [ R > 2 ] ) [ stop ]

  ;; since turtles don't own a variable R the next statement checks the patch each turtle is on for an R value
  ask turtles with [  R > 2 ]
  [
    ;; get my distance from the forest centroid
    let Z distancexy XC YC
           if VERBOSE [ print (word  " x: " xcor " y: " ycor "patch R: " R " Z = " Z ) ]

    ;; get a list of my neighbors
    let nearbylist [self] of neighbors
           if VERBOSE [ print ( word "neighbors of turtle " who "shows") ]

    ;; create a list of indices
    let listplace n-values (  length nearbylist) [ i -> i]

    ;; create a list of distance of each neighbor from the forest centroid
    let dlist [];
    foreach nearbylist [ x -> ask (patch xc yc) [ set dlist lput distance x dlist]  ]
           if VERBOSE [ show dlist ]

    ;; let's be sure we have this correctly, so report the patch and the distance
           if VERBOSE [ foreach listplace [ x -> print (word x " " ( item x nearbylist) " is " ( item x dlist) " from XC YC" )]]
           if VERBOSE [ print ( word " and I am now distance "  Z  " from XC YC " ) ]
           if VERBOSE [ print "so i need to discard items further away from me to get a new better short candiate list "]

    ;; create a list of just those neighbors closer to the forest centroid than I am
    let shortlist [];

    foreach listplace [ x ->      if item x dlist < Z [ set shortlist lput item x nearbylist shortlist ]]
           if VERBOSE [ show shortlist ]
           if VERBOSE [ print " and these patches have these resistances "]
           if VERBOSE [ foreach shortlist [ x -> ask x [ print R ]   ] ]

    ;; create a list of the resistances of those candidates for my next move
    let rlist [ ]
    foreach shortlist [ x -> ask x  [set rlist lput   R   rlist] ]
           if VERBOSE [ show rlist ]

    ;; find the smallest resistance  ( may be duplicated )
    let minr min rlist
           if VERBOSE [  print (word "min resistance is " minr )]

    ;; find the first neighbor with the minimum resistance ( stops looking when it finds one )
    set listplace n-values (length shortlist) [ i -> i]
           if VERBOSE [ print (word " listplace is now : " listplace) ]

    ;; initialize target to something in all cases so the compiler is happy
    let target patch 0 0
           if VERBOSE [ print "target initialized" ]

    foreach listplace [ x -> if ( item x rlist = minr )  [ set target ( item x shortlist ) ]  ]
           if VERBOSE [ print ( word "moving to "  target )]

    move-to target
  ]
tick

end


@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
21
215
84
248
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
97
217
160
250
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SWITCH
35
31
143
64
VERBOSE
VERBOSE
1
1
-1000

BUTTON
54
264
140
297
one--step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
31
76
143
109
NUMTURTLES
NUMTURTLES
1
10
10.0
1
1
NIL
HORIZONTAL

TEXTBOX
32
130
182
158
Note - the world does not wrap around
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

   A simple tutorial model where turtles move through patches that have variable resistance to motion,   at each step each turtle moves to the neigbhoring patch with least resistance of patches which are closer to the forest centroid than it is.

## HOW IT WORKS

 
        The world is in yellow and has resistance to motion > 2
        The target forest is in green and has resistance to motion <= 2 

        centroid <- ( XC, YC ) of the center of mass of the forest  
        which we compute once in setup and use globally
    
        listplace is a utility list like [ 0 1 2 3 4 5 6 7 ] of possible list indexes

        If there are stray turtles, each tick, for each turtle not yet in the forest:
         compute:

         nearbylist  <-  ordered list of my neighboring patches  
         dlist       <-  list of the computed distance from each of those to the forest
         shortlist   <-  just those patches in  nearbylist closer to our goal than us 
         rlist       <-  list of the resistances of each patch in the shortlist 
         target      <-  the patch in rlist with the smallest resistance

         and move to the target

## HOW TO USE IT

     Use the VERBOSE switch to toggle on or off verbose printed commments
     Set a number of turtles with the slider ( 1 to 10 )
     Click SETUP
     Click either ONESTEP or GO.

## THINGS TO NOTICE
 
    
   All the decision-making is local.  The turtles do not compute global paths or store information about where they have been.

   Motion is towards the forest centroid, which will not always be the nearest part of a forest especially if the forest has a complex shape.
     

## THINGS TO TRY

 

## EXTENDING THE MODEL
      
    * modify the code so a turtle can run into an obstacle or dead-end and figure out
      how to get out and get in motion towards the goal again.

    * much harder - figure out how to get to the nearest part of the forest, not the 
      centroid of the forest.


## NETLOGO FEATURES

*  illustrates anonymous procedures,  foreach
*  illustrates one way to scan down two lists in parallel looping over an index variable
*  Solves a stated requirement that the turtle not backtrack without requiring either
   turtles or patches to store lists of prior visits

*  illustrates breaking complex calculations into a sequence of simpler steps which 
      --   will run more slowly but
      --   is much easier to understand and debug
      --   requires scanning down two or more lists simulteously in parallel to
           assemble related information that would be all "right there" in a more
           complex code statement that did many things at once.

*  A switch to toggle on/off debugging comments is handy in development ( and when are we
   ever sure we are done with development?! )

*  The world doesn't wrap around but correctly treats neighbors on edges or in a corner
 


## RELATED MODELS

   there are ants and swarm models already in the model library. I didn't explore how those relate to this solution.

## CREDITS AND REFERENCES

 Author: R. Wade Schuette 
 Posted Date:  19 FEB 2021
 Copyright (c) 2021
 Anyone can use this for any purpose but please give me credit

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
