breed [bears bear]

bears-own [
  home-range-size
  abandoned-roads-crossed
  low-traffic-roads-crossed
  high-traffic-roads-crossed
]

to setup

  clear-all

  ask patches [ set pcolor green ]

  let road-busyness-number 0

  if busiest-roads = "abandoned" [ set road-busyness-number 1 ]
  if busiest-roads = "low traffic" [ set road-busyness-number 2 ]
  if busiest-roads = "high traffic" [ set road-busyness-number 3 ]

  if road-busyness-number > 0 [
    let random-patches (list (random 20))
    while [length random-patches < number-of-roads] [
      set random-patches (lput (random 20) random-patches)
      set random-patches (remove-duplicates random-patches)
    ]

    foreach random-patches [
      let x-or-y random 2
      if-else x-or-y = 0
      [ ask patches with [pxcor = ?] [ set pcolor grey ] ]
      [ ask patches with [pycor = ?] [ set pcolor grey ] ]

      let busyness 0

      if-else only-busiest-roads
      [ set busyness road-busyness-number - 1 ]
      [ set busyness random road-busyness-number ]

      if-else busyness = 0
      [ ask patches with [pcolor = grey] [ set pcolor yellow ] ]
      [
        if-else busyness = 1
        [ ask patches with [pcolor = grey] [ set pcolor orange ] ]
        [ ask patches with [pcolor = grey] [ set pcolor red ] ]
      ]
    ]
  ]

  set-default-shape bears "bear"

  create-bears 1
  [
    set color brown
    set size 3
    setxy random-xcor random-ycor
    set home-range-size 0
    set abandoned-roads-crossed 0
    set low-traffic-roads-crossed 0
    set high-traffic-roads-crossed 0
  ]

  ask bears [
    if [pcolor] of patch-here = green [
      set pcolor 57
      set home-range-size home-range-size + 1
    ]
    if [pcolor] of patch-here = yellow [
      set pcolor 47
      set home-range-size home-range-size + 1
      set abandoned-roads-crossed abandoned-roads-crossed + 1
    ]
    if [pcolor] of patch-here = orange [
      set pcolor 27
      set home-range-size home-range-size + 1
      set low-traffic-roads-crossed low-traffic-roads-crossed + 1
    ]
    if [pcolor] of patch-here = red [
      set pcolor 17
      set home-range-size home-range-size + 1
      set high-traffic-roads-crossed high-traffic-roads-crossed + 1
    ]
  ]

  reset-ticks

end

to go

  tick

  ask bears [
    rt ((random 180) - 90)
    if [pcolor] of patch-ahead 1 = green or [pcolor] of patch-ahead 1 = 57 [ fd 1 ]
    if [pcolor] of patch-ahead 1 = yellow or [pcolor] of patch-ahead 1 = 47 [
      let chance-to-cross random-float 1
      if-else chance-to-cross < 0.430
      [
        fd 1
        set abandoned-roads-crossed abandoned-roads-crossed + 1
      ]
      [
        if-else random 2 = 0
        [ rt 90 ]
        [ lt 90 ]
      ]
    ]
    if [pcolor] of patch-ahead 1 = orange or [pcolor] of patch-ahead 1 = 27 [
      let chance-to-cross random-float 1
      if-else chance-to-cross < 0.252
      [
        fd 1
        set low-traffic-roads-crossed low-traffic-roads-crossed + 1
      ]
      [
        if-else random 2 = 0
        [ rt 90 ]
        [ lt 90 ]
      ]
    ]
    if [pcolor] of patch-ahead 1 = red or [pcolor] of patch-ahead 1 = 17 [
      let chance-to-cross random-float 1
      if-else chance-to-cross < 0.184
      [
        fd 1
        set high-traffic-roads-crossed high-traffic-roads-crossed + 1
      ]
      [
        if-else random 2 = 0
        [ rt 90 ]
        [ lt 90 ]
      ]
    ]
    if [pcolor] of patch-here = green [
      set pcolor 57
      set home-range-size home-range-size + 1
    ]
    if [pcolor] of patch-here = yellow [
      set pcolor 47
      set home-range-size home-range-size + 1
    ]
    if [pcolor] of patch-here = orange [
      set pcolor 27
      set home-range-size home-range-size + 1
    ]
    if [pcolor] of patch-here = red [
      set pcolor 17
      set home-range-size home-range-size + 1
    ]
  ]

  if stop-after-100-steps and ticks = 100 [ stop ]

end
@#$#@#$#@
GRAPHICS-WINDOW
206
10
621
446
-1
-1
20.25
1
10
1
1
1
0
1
1
1
0
19
0
19
0
0
1
ticks
30.0

BUTTON
9
10
82
43
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
120
10
183
43
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

CHOOSER
9
97
189
142
busiest-roads
busiest-roads
"no roads" "abandoned" "low traffic" "high traffic"
3

SLIDER
10
192
190
225
number-of-roads
number-of-roads
1
10
10
1
1
NIL
HORIZONTAL

PLOT
10
234
186
391
home range area
time
area
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [home-range-size] of bears"

TEXTBOX
13
394
196
443
Yellow = abandoned \nOrange = low traffic \nRed = high traffic
12
0.0
1

SWITCH
9
152
189
185
only-busiest-roads
only-busiest-roads
1
1
-1000

SWITCH
9
56
188
89
stop-after-100-steps
stop-after-100-steps
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This model looks at how animals react to urbanization. It is based off of a paper showing bears are more reluctant to cross busier roads.

## HOW IT WORKS

The bear wanders randomly (within it's front arc) around its environment. The model will track the size of the bear's home range (everywhere the bear has been). When the bear reaches a road, it will randomly cross the road (or not) by comparing a random number to a fixed percentage, and moving if the random number is under the threshold, with a higher chance to cross less busy roads.

## HOW TO USE IT

There are a few main global variables in this model:

The stop-after-100 steps global variable sets a flag to stop the model after 100 steps for easy side-by-side comparisons of different settings.

The busiest-roads global variable sets the busiest road the model will randomly generate. The bear is more likely to cross abandoned roads than roads with low traffic, and more likely to cross roads with restricted traffic than roads with high traffic.

The only-busiest-roads global variable sets a flag to only spawn roads of the busiest type selected, in order to see the effects of different road types in a vacuum.

The number-of-roads global variable simply sets how many roads will be randomly generated in the environment.

## THINGS TO NOTICE

Watch how the bear's home range changes given both the number of roads and the busyness of the roads. Which do you think has a larger effect?

## THINGS TO TRY

Adjust the number of roads and the busiest type of road. See how not having any roads affects the size of the bear's home range.

## EXTENDING THE MODEL

Try developing a model with multiple bears, or a model with an "unpassable" road, such as an interstate.

## NETLOGO FEATURES

A turtle breed was used to model the bears, and different color patches were used to model different roads (or the absence of a road)?

## RELATED MODELS

Peppered Moths is another model that looks at the affect of urbanization on wildlife.

## CREDITS AND REFERENCES

Brody, A. J., & Pelton, M. R. (1989). Effects of roads on black bear movements in western North Carolina. Wildlife Society Bulletin (1973-2006), 17(1), 5-10.

## COPYRIGHT AND LICENSE

Copyright 2016 Philip McElmurray.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

This model was created as part of an outreach project for the capstone course of the BioBuild program at Virginia Tech.

A big thank you to Fadoua El Moustaid, Zach Gajewski, Matt Hedin, Jess Hernandez, Meredith Keeley, Sam Lane, and Steve McBride for their valuable comments and feedback.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

bear
true
0
Circle -7500403 true true 29 59 182
Polygon -7500403 true true 60 195 60 255 90 270 105 255 90 240 75 195 60 195
Polygon -7500403 true true 150 195 150 255 180 270 195 255 180 240 180 180
Circle -7500403 true true 204 99 42
Circle -7500403 true true 240 165 30
Polygon -7500403 true true 180 195 255 195 255 165 255 150 240 135 210 120 180 120 180 195
Rectangle -16777216 true false 225 150 240 165

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
