turtles-own
  [ status               ;; either: healthy, contact-infected, contact-healthy, sick or immune ;;
    infectious-time      ;; after being infetious for 14 days, become sick
    remaining-immunity   ;; how many days of immunity the turtle has left
    contact-time         ;; how long since last contact
    sick-time            ;; this determines the point in time when the agent recovers
    age                  ;; how old is the turtle
    quarantined?         ;; whether the person is quarantined
    number-of-links      ;; number of links each turtle has
    day-with-no-new-sick ;; count number of days with no new sick people
  ]

globals
  [ %infected            ;; what % of the population is infectious
    max%infected         ;; what was the max infected ever
    %immune              ;; what % of the population is immune
    maximum-population   ;; keep it the same as the number of people who started.
    lifespan             ;; the lifespan of a turtle
    initial-ave-links    ;; initial average number of links
    immunity-duration    ;; turtle being immune in number of days
    total-died           ;; total number of people died from the virus
    total-sick           ;; total number of people who became sick
    max-sick             ;; the highest number at one time hospitalised
    number-sick          ;; number of sick people at any one moment
    new-positive         ;; number newly tested positive
    days-number=criteria ;; how many days have we got no new cases
    number-infected      ;; number of infeccted people but not sick at any one moment, ie contact-infected status
    max-number-sick-at-one-time ;;the maximum sick at any one moemnt, hence the max in hospital
    remove-lockdown?     ;; to start considering removing lock-down
    max-number-of-links  ;; in previous versions, this is a slider value
  ]
to setup
  clear-all
  resize-world 0 (size-of-world - 1) 0 (size-of-world - 1)
  set new-positive 0
  set days-number=criteria 0
  set max%infected 0
  set-patch-size (500 / max-pxcor)
  set-default-shape turtles "person"
  set maximum-population number-people  ;; this is to keep the total populace constant even though some will die
  set max-number-of-links initial-max-number-of-links
  ;; ==================================================

  set lifespan 80 * 365.25  ;; life expectancy set to 80

  ;; set immunity-duration immunity-duration-yr * 365  ;; remain immune for number of years in days as indicated by immunity-duration-yr
  set max-number-sick-at-one-time 0
  set total-died 0
  ;; ===================================================
  create-turtles number-people
    [ set status "healthy"
      set age random lifespan
      set color green
      set sick-time 0
      set contact-time 0
      set remaining-immunity 0
      set size 1.5  ;; easier to see
      set quarantined? false
      setxy random-xcor random-ycor
    ]

;; code for number of links
  ask turtles [make-links]
  set initial-ave-links count links / count turtles
;;  =======================================================================
  ;; the next two line is to get the mean of number-of-links of turtles with high number of links
;  let max-links-turtles max-n-of 1000 turtles [number-of-links]
;  show mean [number-of-links] of max-links-turtles
;;  ========================================================================
  ask n-of initial-infectious-number turtles
    [ set status "contact-infected"
      set infectious-time 1
      set color magenta
    ]

  reset-ticks

  ask links [hide-link]
end

to go
  set new-positive 0 ;; with each new tick = one day, set new-positive to zero to check how many new positive we have for each day
  ask turtles [
    get-older ;; everybody gets older
    if status = "healthy" [
                           reproduce ;; this is to keep population number constant when peole dies
                          ]
    if status = "contact-healthy" and quarantined? = true [set contact-time contact-time + 1
                                                           if contact-time > 14 [ set status "healthy"
                                                                                  set quarantined? false  ;; since he is healthy, can be released from quarantine
                                                                                  make-links              ;; after 14 days, and shown to be not sick, can form links agai.
                                                                                  set color green
                                                                                  set contact-time 0]
                                                          ]
    ;; if a contact has not been qurantined, depending on the efficiency in contact tracing and the delay (as measured by contact-time) in qurantine
    ;; he might be or might not be quarantine. that is determined by a raondom number.
    if status = "contact-healthy" and quarantined? = false [set contact-time contact-time + 1
                                                            if contact-time >= to-quarantine [ if random 100 < contact-tracing [getting-quarantine]]
                                                            if contact-time > 14 [ set status "healthy"
                                                                                  set color green
                                                                                  ;; no need to make links as links are still intact since it is not quarantined
                                                                                  set contact-time 0]
                                                           ]

    if status = "contact-infected" and quarantined? = true [set infectious-time infectious-time + 1
                                                            if infectious-time > random 14 [ set status "sick"             ;; if infectious-time > max incubation time of 14, but can be shorter
                                                                                             set color yellow
                                                                                             ask [my-links] of self [die]  ;; hospitalised, no longer have links to infect
                                                                                             set total-sick total-sick + 1
                                                                                             set sick-time sick-time + 1
                                                                                           ]

                                                           ]
    ;; any newly infected agent might not be identified yet, and therefore quarantined? = false.
    ;; if it is then identified, it will be a new case and then quarantined? set to true.
    ;; if can also become sick and thereofore identified, and that would turn it into a new case
    if status = "contact-infected" and quarantined? = false [infect              ;; these are the agents who were not quarantined, though infectious.
                                                             set infectious-time infectious-time + 1
                                                             set contact-time contact-time + 1
                                                             if contact-time >= to-quarantine [if random 100 < contact-tracing [getting-quarantine]  ;; agent tested positive therefore quarantined
                                                                                               set new-positive new-positive + 1] ;; set counter to note additional new positive
                                                             if infectious-time > random 14 [ set status "sick"             ;; if infectious-time > max incubation time of 14, but can be shorter
                                                                                              set new-positive new-positive + 1
                                                                                              set color yellow
                                                                                              ask [my-links] of self [die]  ;; hospitalised, no longer have links to infect
                                                                                              set total-sick total-sick + 1
                                                                                              set sick-time sick-time + 1
                                                                                            ]

                                                           ]


    if status = "sick" [ infect  ;; this line of code comes before severing links, as he might infect other first before identified and go to hospital
                                 ;; if links are cut already in the previous round, he won't be able to infect others. (See procedure on "to infect"
                         set sick-time sick-time + 1
                         ask [my-links] of self [die]  ;; with links severed, it cannot infect anyone - equivalent of going to hospital
                         if sick-time > random-exponential 14 [recover-or-die]  ;; average sick time is 14 days, beween 6 to  42 days.
                       ]

    if status = "immune" [set color grey
                          ask [my-links] of self [die]
;;                         life long immunity
;                          set remaining-immunity remaining-immunity - 1
;                          if remaining-immunity <= 0 [get-normal] ;; no longer immune, and becomes like normal
                         ]
  ]
  set number-sick count turtles with [status = "sick"] ;; this show the number sick at any ONE time
  set %infected (count turtles with [status = "sick"] + count turtles with [status = "contact-infected"]) / count turtles * 100
  set %immune  count turtles with [status = "immune"] / count turtles * 100
    if number-sick > max-number-sick-at-one-time [set max-number-sick-at-one-time number-sick]
  if %infected > max%infected [set max%infected %infected]
  if %infected / max%infected < (1 - (lift-lockdown-point / 100)) [set max-number-of-links post-lockdown-max-links ;; when number of cases starts to fall
                                           ask turtles with [status = "health"] [make-links]
                                           set chance-infected post-lockdown-chance-infected ;; this comes about by reducing social distancing, not wearing mask etc.
                                           ] ;; if the trend of infection going down to a new cases only for a number of days, can lift lockdown
  if count turtles with [status = "sick"] + count turtles with [status = "contact-infected"] = 0 [stop]

  tick
end

to get-older
  set age age + 1
end

to make-links
  ifelse max-number-of-links = 0
      [let K exp(ln(random-float 1) / (- gamma))
                  if K > count turtles with [quarantined? = false] [ set K count turtles with [quarantined? = false] - 1] ;; only those not with quarantined? = true can form links
                  set K round K
                  create-links-with n-of K other turtles
                  set number-of-links K]
       [let K exp(ln(random-float 1) / (- gamma))
                  if K > max-number-of-links [ set K max-number-of-links] ;; this will set the upper limit of links
                  set K round K
                  create-links-with n-of K other turtles
                  set number-of-links K]
  end

to reproduce
  if count turtles < number-people [hatch (number-people - count turtles) [set status "healthy"
                                                                           set age random lifespan
                                                                           set sick-time 0
                                                                           set remaining-immunity 0
                                                                           set size 1.5  ;; easier to see
                                                                           set quarantined? false
                                                                           make-links
                                                                           setxy random-xcor random-ycor]
                                                                           ]
  ask links [hide-link]
end

to infect
  ask link-neighbors [ifelse random 100 <= chance-infected [set status "contact-infected"  ;; though the agent is infected, he is not yet identified as such.
                                                           set color magenta
                                                           set contact-time 1]  ;; contact time is set as marker for when he is detected to be a contact
                                                          [set status "contact-healthy"
                                                           set color pink - 3
                                                           set contact-time 1 ]  ;; contact time is set as market for when he is detected to be a contact
                     ]
end

to getting-quarantine
  set quarantined? true
  ask [my-links] of self [die] ;; once the agentis quarantined, he is not linked to anyone
end
to recover-or-die
  ifelse random 100 > chance-recover [set total-died total-died + 1
                                      die
                                      print total-died]
                                     [set status "immune"
                                      set color grey
                                      set sick-time 0
                                      set contact-time 0
                                      set quarantined? true
                                      set remaining-immunity immunity-duration-yr * 365
                                     ]
end

;to get-normal
;  set status "healthy"
;  set color green
;  set sick-time 0
;  set contact-time 0
;  set quarantined? false
;  make-links
;end
@#$#@#$#@
GRAPHICS-WINDOW
270
20
787
538
-1
-1
10.204081632653061
1
10
1
1
1
0
1
1
1
0
49
0
49
1
1
1
ticks
30.0

SLIDER
15
405
230
438
duration
duration
1
99.0
5.0
1.0
1
days
HORIZONTAL

SLIDER
15
370
230
403
chance-recover
chance-recover
0.0
100
92.0
1.0
1
%
HORIZONTAL

SLIDER
10
300
225
333
Chance-Infected
Chance-Infected
0.0
100
70.0
10
1
%
HORIZONTAL

BUTTON
10
10
80
45
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
85
10
156
46
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
795
155
1310
325
Populations
days
Percent
0.0
52.0
0.0
100.0
true
true
"" ""
PENS
"sick" 1.0 0 -955883 true "" "plot count turtles with [ status = \"sick\"] / number-people * 100"
"contact-infected" 1.0 0 -5825686 true "" "plot count turtles with [ status = \"contact-infected\" ] / number-people * 100"
"immune" 1.0 0 -7500403 true "" "plot count turtles with [ status = \"immune\" ] / number-people * 100"
"contact-healthy" 1.0 0 -1264960 true "" "count turtles with [status = \"contact-healthy\"]"
"healthy" 1.0 0 -10899396 true "" "plot count turtles with [status = \"healthy\"] / number-people * 100"
"quarantined?" 1.0 0 -13345367 true "" "count turtles with [quarantined? = true]"

SLIDER
5
190
230
223
number-people
number-people
100
100000
10000.0
100
1
NIL
HORIZONTAL

MONITOR
0
565
65
610
NIL
%infected
3
1
11

MONITOR
70
565
135
610
NIL
%immune
1
1
11

MONITOR
140
565
190
610
days
ticks
0
1
11

SLIDER
5
225
230
258
initial-infectious-number
initial-infectious-number
0
100
30.0
1
1
NIL
HORIZONTAL

MONITOR
200
565
262
610
No. Died
total-died
0
1
11

INPUTBOX
15
505
195
565
to-quarantine
5.0
1
0
Number

MONITOR
290
550
452
595
Max no ever hospitalised
total-sick
0
1
11

MONITOR
795
345
957
390
No. Infected but not sick
count turtles with [status = \"contact-infected\"]
0
1
11

MONITOR
800
395
950
440
No. sick
count turtles with [status = \"sick\"]
0
1
11

SLIDER
15
470
230
503
contact-tracing
contact-tracing
0
100
90.0
5
1
%
HORIZONTAL

SLIDER
10
440
227
473
immunity-duration-yr
immunity-duration-yr
0
10
10.0
1
1
years
HORIZONTAL

CHOOSER
165
10
257
55
size-of-world
size-of-world
30 40 50 75 100 200
2

TEXTBOX
800
40
1230
140
min-new-positives: the minimum number of new cases per day that is accepted as a criteria that the disease is under control\n\ndays-criteria: how many days must it be for min-new-positives before lockdown is relaxed
14
0.0
0

TEXTBOX
85
420
235
440
of infection
11
0.0
1

TEXTBOX
105
510
255
528
(delay in days}
11
0.0
1

TEXTBOX
120
485
270
503
efficiency
11
0.0
1

MONITOR
970
345
1057
390
No. contacts
count turtles with [status = \"contact-infected\"] + count turtles with [status = \"contact-healthy\"]
0
1
11

SLIDER
10
55
182
88
gamma
gamma
0.9
3
1.5
0.1
1
NIL
HORIZONTAL

MONITOR
1180
445
1367
490
Running average no. of links
count links / count turtles
1
1
11

PLOT
805
445
1170
595
Histogram of Links
Number of histogram
# of turtles
1.0
30.0
0.0
25.0
true
true
"" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [number-of-links] of turtles"

MONITOR
1180
545
1287
590
Max no. of links
max [number-of-links]of turtles
0
1
11

MONITOR
1180
495
1282
540
Min no. of links
min [number-of-links] of turtles
0
1
11

MONITOR
510
555
747
600
Max number in hospital at same time
max-number-sick-at-one-time
0
1
11

MONITOR
1175
390
1357
435
Initial Average no. of links
initial-ave-links
1
1
11

SLIDER
5
155
230
188
post-lockdown-max-links
post-lockdown-max-links
10
100
100.0
10
1
NIL
HORIZONTAL

SLIDER
10
335
225
368
post-lockdown-chance-infected
post-lockdown-chance-infected
0
100
70.0
10
1
%
HORIZONTAL

SLIDER
10
260
225
293
lift-lockdown-point
lift-lockdown-point
0
100
30.0
5
1
%
HORIZONTAL

SLIDER
5
85
232
118
initial-max-number-of-links
initial-max-number-of-links
0
100
3.0
1
1
NIL
HORIZONTAL

TEXTBOX
240
350
390
368
<--
11
15.0
1

TEXTBOX
245
170
395
188
<--
11
15.0
1

@#$#@#$#@
## WHAT IS IT?

This model is designed to simulate the spread of the virus Covid-19, using what is known regarding some aspects of the virus, and how the usual methods of containment might affect the outcome. It doesn’t include having vaccination of the population as one of the measures. It also simullates the effects of lifting lockdowns

[Report of the WHO-China Joint Mission on Coronavirus Disease 2019 (COVID-19), https://www.who.int/docs/default-source/coronaviruse/who-china-joint-mission-on-covid-19-final-report.pdf]


## HOW IT WORKS

The number of people is selected together with the size of the world. The latter is not important, it is just for visual reasons. 

The population is maintained at a near constant level by birth.

The people could be in either 1 of five status: healthy (colored green), contact-health (colored pink), contact-infected (colored magenta) sick (colored yellow), and immune (colored gray). If the agent is quarantined, on the graph showing percentage of each group of agents, the a line in blue will appear showing percent of agents who are quarantined. 

In the absence of a vaccine, the ways governments tend to try and contain the virus is by isolating the sick, and identifying contacts of the sick or anyone tested positive for the virus. However, there might be delay in the identification of contacts and on how efficient is that method. As human beings live in groups and have connections, some having more connections than other, forming networks, on setting up the program to run, one of the settings is gamma. Gamma determines the number of links the individuals have, and the distribution of the number of links is in the form of power log. The formula that is used in determining how may link an agent has is in the form p(K) = K^(-γ) where
γ is the Greek alphabet for gamma



## HOW TO USE IT

Each "tick" represents a day
.

### NUMBER OF PEOPLE AND SIZE OF THE WORLD
These are the numbers that should first be initialized. If the number is higher than 10,000, it tends to run very slow

### GAMMA
There determines the number of links which an agent might have. Based on the formula for power log distribution. 

### CHANCE-INFECTION

After a healthy person has come into contact with an infected person via the links, this slider sets the chance of the healthy person being infected. We do not have data regarding the chance of infection, so varying the chance might show how critical is this parameter in the epidemiology of the spread of the virus. 

Chance of being infected could be reduced by such measures as social distancing, frequent washing of hands, and the wearing of masks. However, we do not have the data on translating those actions into actual numbers regarding the chance of being infected after having come into contact with an infected person. 

### CHANCE-RECOVER

At the moment, it seems the mortality rate is around 2% - 3%. But we are not sure, as many who are carrying the virus but are not sick would not appear in that statistics. So again, the slider would allow one to change the chance of recovery and to observe the results. 

The duration of sickness on average is 14 days, but can be as long as 42 days. How long an agent has been sick is tracked by the turtle-own variable “sick-time”. At every tick, that number is compared with a random-exponential number with mean of 14, and if it is greater than that, a random number of between 0 and 99, inclusive, is then generated. And if that number is less than the “Chance-Recover”, it is cured, otherwise it dies.

### DURATION OF INFECTION

From actual data, it seems the incubation period of the virus varies from an average of 5 – 6 days, to maximum of 14 days, during which time, it is possible for the infected person or agent, without appearing sick, to transmit the virus. Again , this parameter could be altered with the slider and the result observed.

### IMMUNITY-DURATION-YR

After an agent has recovered, its status changes to “immune” and the duration of that immunity is dependent on the setting of the “immunity-duration-yr” slider.

### CONTACT-TRACING

This slider controls how effective is the contact tracing, and hence how effective can the isolation process be implemented. 

### TO-QUARANTINE

This slider controls the number of days before a quarantine order is given, and will test the effect of any delays in quarantining contacts.

### CONTACTS
Agents linked to an infected agent changes its status from "healthy" to either "contact-healthy" or "contact-infected". The chance of being "contact-infected" is determined by the slider chance-infected.

Once an agent changes its status to either "contact-healthy" or "contact-infected", depending on the "to-quarantine (delay in days)" slider and the "contact-tracing (efficiency)" slider, the agent might become quarantined or not. If the agent becomes quarantined, all the links with it will be broken, or in the language of NetLogo "die". So even though an agent might be "contact-infected" it is unable to infect any other agents as it has no links to anyone. 

With each tick, the contact-time variable will increase and if an agent is "contact-healthy", after 14 ticks, it is returned to being "healthy" and links are reformed. If it is an agent which is "contact-infected", depending on the duration-infected sliked, it might become sick.

### LIFT LOCKDOWN POINT
With this slider, you can set the point at which the lockdown measures, maximum number of links and chance of infection, can be raised. This slider sets the point when number of newly infected agents is of a certain percentage point less than the maximum number of newly infected agents. 

#### POST-LOCKDOWN-MAX-LINK and POST-LOCKDOWN-CHANCE-INFECTED





## THINGS TO NOTICE

The factors controlled by the three sliders interact to influence how likely the virus is to thrive in this population.  Notice that in all cases, these factors must create a balance in which an adequate number of potential hosts remain available to the virus and in which the virus can adequately access those hosts.

Often there will initially be an explosion of infection since no one in the population is immune.  This approximates the initial "outbreak" of a viral infection in a population, one that often has devastating consequences for the humans concerned. Soon, however, the virus becomes less common as the population dynamics change.  What ultimately happens to the virus is determined by the factors controlled by the sliders.

Notice that viruses that are too successful at first (infecting almost everyone) may not survive in the long term.  Since everyone infected generally dies or becomes immune as a result, the potential number of hosts is often limited.  The exception to the above is when the DURATION slider is set so high that population turnover (reproduction) can keep up and provide new hosts.

## THINGS TO TRY


What about chaing the effectiveness of contact tracing or the time it takes to quarantine an infected person. Chance of catching the virus? 

## EXTENDING THE MODEL

Allowing immigration, with an occasional sick person coming in. How will that affect the outcome? 

Arrival of a vaccine?



## RELATED MODEL


Ronald Ng - Mt Elizabeth Medical Center, Singapore. 
e-mail: ronaldpaul.ng@gmail.com
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            